/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Cameras;

import com.jmathanim.Utils.Boxable;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;

public class Camera {
    public boolean perspective;
    public int screenWidth;
    public int screenHeight;
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected double[] resetValues;
    protected double hgap = 0.1;
    protected double vgap = 0.1;
    private final JMathAnimScene scene;
    private double xminB;
    private double xmaxB;
    private double yminB;
    private double ymaxB;

    public Camera(JMathAnimScene scene, int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.scene = scene;
    }

    public void reset() {
        this.setMathXY(this.resetValues[0], this.resetValues[1], this.resetValues[2]);
    }

    public final void setCenter(double x, double y) {
        double mWidth = this.xmax - this.xmin;
        this.setMathXY(x - 0.5 * mWidth, x + 0.5 * mWidth, y);
    }

    public void setCenter(MathObject obj) {
        double xx = obj.getCenter().v.x;
        double yy = obj.getCenter().v.y;
        this.setCenter(xx, yy);
    }

    public Camera setMathXY(double xmin, double xmax, double ycenter) {
        if (xmax <= xmin) {
            return this;
        }
        this.xmin = xmin;
        this.xmax = xmax;
        double ratioScreen = (double)this.screenWidth / (double)this.screenHeight;
        this.ymax = ycenter + 0.5 * (xmax - xmin) / ratioScreen;
        this.ymin = ycenter - 0.5 * (xmax - xmin) / ratioScreen;
        return this;
    }

    public double mathToScreen(double mathScalar) {
        return mathScalar * (double)this.screenHeight / (this.ymax - this.ymin);
    }

    public double[] mathToScreen(double mathX, double mathY) {
        double x = (mathX - this.xmin) * (double)this.screenWidth / (this.xmax - this.xmin);
        double y = (this.ymax - mathY) * (double)this.screenHeight / (this.ymax - this.ymin);
        return new double[]{x, y};
    }

    public double[] screenToMath(double x, double y) {
        double mx = x * (this.xmax - this.xmin) / (double)this.screenWidth + this.xmin;
        double my = -(y * (this.ymax - this.ymin) / (double)this.screenHeight - this.ymax);
        return new double[]{mx, my};
    }

    public double screenToMath(double screenScalar) {
        return screenScalar * (this.xmax - this.xmin) / (double)this.screenWidth;
    }

    public double[] mathToScreenFX(Vec p) {
        return this.mathToScreen(p.x, p.y);
    }

    public void saveState() {
        this.xminB = this.xmin;
        this.xmaxB = this.xmax;
        this.yminB = this.ymin;
        this.ymaxB = this.ymax;
    }

    public void restoreState() {
        this.xmin = this.xminB;
        this.xmax = this.xmaxB;
        this.ymin = this.yminB;
        this.ymax = this.ymaxB;
    }

    public void setWidth(double d) {
        this.scale(d / this.getMathView().getWidth());
    }

    public void setSize(int w, int h) {
        this.screenWidth = w;
        this.screenHeight = h;
    }

    public void setGaps(double h, double v) {
        this.hgap = h;
        this.vgap = v;
    }

    public Camera setMathView(Rect r) {
        this.setMathXY(r.xmin, r.xmax, 0.5 * (r.ymin + r.ymax));
        return this;
    }

    public void shift(Vec v) {
        this.shift(v.x, v.y);
    }

    public void shift(double x, double y) {
        this.setMathXY(this.xmin + x, this.xmax + x, 0.5 * (this.ymin + this.ymax) + y);
    }

    public Camera adjustToRect(Rect rAdjust) {
        Rect r = this.getRectThatContains(rAdjust);
        this.setMathXY(r.xmin, r.xmax, 0.5 * (r.ymax + r.ymin));
        return this;
    }

    public Camera adjustToAllObjects() {
        if (!this.scene.getObjects().isEmpty()) {
            Boxable[] objs = this.scene.getObjects().toArray(new MathObject[this.scene.getObjects().size()]);
            this.adjustToObjects(objs);
        }
        return this;
    }

    public Camera adjustToObjects(Boxable ... objs) {
        Rect r = this.getMathView();
        for (Boxable obj : objs) {
            r = Rect.union(r, obj.getBoundingBox());
        }
        this.adjustToRect(r.addGap(this.hgap, this.hgap));
        return this;
    }

    public Camera centerAtObjects(Boxable ... objs) {
        Rect r = objs[0].getBoundingBox();
        for (Boxable obj : objs) {
            r = Rect.union(r, obj.getBoundingBox());
        }
        if (r != null) {
            this.shift(this.getMathView().getCenter().to(r.getCenter()));
            this.adjustToObjects(objs);
        }
        return this;
    }

    public Camera centerAtAllObjects() {
        if (!this.scene.getObjects().isEmpty()) {
            Boxable[] objs = this.scene.getObjects().toArray(new MathObject[this.scene.getObjects().size()]);
            this.centerAtObjects(objs);
        }
        this.adjustToAllObjects();
        return this;
    }

    public Camera zoomToObjects(MathObject ... objs) {
        Rect r = objs[0].getBoundingBox();
        for (MathObject obj : objs) {
            r = Rect.union(r, obj.getBoundingBox());
        }
        this.adjustToRect(r.addGap(this.hgap, this.hgap));
        return this;
    }

    public Camera zoomToAllObjects() {
        if (!this.scene.getObjects().isEmpty()) {
            MathObject[] objs = this.scene.getObjects().toArray(new MathObject[this.scene.getObjects().size()]);
            this.zoomToObjects(objs);
        }
        return this;
    }

    public Camera scale(double scale) {
        this.setMathView(this.getMathView().scale(scale, scale));
        return this;
    }

    public Rect getRectThatContains(Rect r) {
        Rect resul = new Rect(0.0, 0.0, 0.0, 0.0);
        double ratio = (double)this.screenWidth / (double)this.screenHeight;
        double ratioR = (r.xmax - r.xmin) / (r.ymax - r.ymin);
        if (ratio <= ratioR) {
            double camHeight = (r.ymax - r.ymin) / ratio;
            double minY = 0.5 * (r.ymin + r.ymax - camHeight);
            double maxY = 0.5 * (r.ymin + r.ymax + camHeight);
            resul.xmin = r.xmin;
            resul.xmax = r.xmax;
            resul.ymin = minY;
            resul.ymax = maxY;
        } else {
            double camWidth = (r.ymax - r.ymin) * ratio;
            double minX = 0.5 * (r.xmin + r.xmax - camWidth);
            double maxX = 0.5 * (r.xmin + r.xmax + camWidth);
            resul.xmin = minX;
            resul.xmax = maxX;
            resul.ymin = r.ymin;
            resul.ymax = r.ymax;
        }
        return resul;
    }

    public Rect getMathView() {
        return new Rect(this.xmin, this.ymin, this.xmax, this.ymax);
    }

    public Vec getGaps() {
        return new Vec(this.hgap, this.vgap);
    }

    public void initialize(double xmin, double xmax, double ycenter) {
        this.setMathXY(xmin, xmax, ycenter);
        this.resetValues = new double[]{xmin, xmax, ycenter};
    }
}

