/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Cameras;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Point;

public class Camera3D
extends Camera {
    public final Point eye;
    public final Point look;
    public final Vec up;
    public float fov;

    public Camera3D(JMathAnimScene scene, int screenWidth, int screenHeight) {
        super(scene, screenWidth, screenHeight);
        this.perspective = true;
        this.fov = 45.0f;
        this.eye = (Point)Point.at(0.0, 0.0, 1.125 / Math.tan(1.0 * (double)this.fov * Math.PI / 360.0)).visible(false);
        this.look = (Point)Point.at(0.0, 0.0, 0.0).visible(false);
        this.up = Vec.to(0.0, 0.0, 0.0);
    }

    @Override
    public Camera setMathXY(double xmin, double xmax, double ycenter) {
        super.setMathXY(xmin, xmax, ycenter);
        this.adjustLookAtToMathView();
        return this;
    }

    private void adjustLookAtToMathView() {
        Rect bb = this.getMathView();
        double x = bb.getCenter().v.x;
        double y = bb.getCenter().v.y;
        this.eye.copyFrom(Point.at(x, y, this.getProperEyeHeight(bb)));
        this.look.copyFrom(Point.at(x, y, 0.0));
    }

    public double getProperEyeHeight(Rect bb) {
        return 0.5 * bb.getHeight() / Math.tan(1.0 * (double)this.fov * Math.PI / 360.0);
    }

    public double getMathViewHeight3D(double zDepth) {
        return 2.0 * Math.tan(1.0 * (double)this.fov * Math.PI / 360.0) * zDepth;
    }

    public void lookAt(Point eye, Point look) {
        this.lookAt(eye, look, Vec.to(0.0, 0.0, 0.0));
    }

    public void lookAt(Point eye, Point look, Vec up) {
        this.eye.copyFrom(eye);
        this.look.copyFrom(look);
        this.up.copyFrom(up);
    }

    public Vec getUpVector() {
        Vec l = this.eye.to(this.look);
        if (l.x != 0.0 || l.y != 0.0) {
            return Vec.to(0.0, 0.0, 1.0);
        }
        return Vec.to(0.0, 1.0, 0.0);
    }
}

