/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Constructible.Conics;

import com.jmathanim.Constructible.Conics.ConstrCircleCenterPoint;
import com.jmathanim.mathobjects.Point;

public class ConstrCircleCenter3Points
extends ConstrCircleCenterPoint {
    public final Point P0;
    public final Point P1;
    public final Point P2;

    public static ConstrCircleCenter3Points make(Point P0, Point P1, Point P2) {
        ConstrCircleCenter3Points resul = new ConstrCircleCenter3Points(P0, P1, P2);
        resul.rebuildShape();
        return resul;
    }

    private ConstrCircleCenter3Points(Point P0, Point P1, Point P2) {
        super(Point.origin(), Point.origin());
        this.P0 = P0;
        this.P1 = P1;
        this.P2 = P2;
    }

    @Override
    public void computeCircleCenterRadius() {
        this.findCircle(this.P0.v.x, this.P0.v.y, this.P1.v.x, this.P1.v.y, this.P2.v.x, this.P2.v.y);
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(Math.max(this.P0.getUpdateLevel(), this.P1.getUpdateLevel()), this.P2.getUpdateLevel()) + 1;
    }

    private void findCircle(double x1, double y1, double x2, double y2, double x3, double y3) {
        double x12 = x1 - x2;
        double x13 = x1 - x3;
        double y12 = y1 - y2;
        double y13 = y1 - y3;
        double y31 = y3 - y1;
        double y21 = y2 - y1;
        double x31 = x3 - x1;
        double x21 = x2 - x1;
        double sx13 = x1 * x1 - x3 * x3;
        double sy13 = y1 * y1 - y3 * y3;
        double sx21 = x2 * x2 - x1 * x1;
        double sy21 = y2 * y2 - y1 * y1;
        double f = (sx13 * x12 + sy13 * x12 + sx21 * x13 + sy21 * x13) / (2.0 * (y31 * x12 - y21 * x13));
        double g = (sx13 * y12 + sy13 * y12 + sx21 * y13 + sy21 * y13) / (2.0 * (x31 * y12 - x21 * y13));
        double c = (double)(-((int)(x1 * x1)) - (int)(y1 * y1)) - 2.0 * g * x1 - 2.0 * f * y1;
        double h = -g;
        double k = -f;
        this.circleCenter.v.x = h;
        this.circleCenter.v.y = k;
        this.radius = this.circleCenter.to(this.P0).norm();
    }
}

