/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Constructible.Conics;

import com.jmathanim.Constructible.Constructible;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class ConstrCircleCenterPoint
extends Constructible {
    Point A;
    Point B;
    protected double radius;
    public final Point circleCenter;
    private final Shape originalCircle;
    private final Shape circleToDraw;

    public static ConstrCircleCenterPoint make(Point A, Point B) {
        ConstrCircleCenterPoint resul = new ConstrCircleCenterPoint(A, B);
        resul.rebuildShape();
        return resul;
    }

    protected ConstrCircleCenterPoint(Point A, Point B) {
        this.A = A;
        this.B = B;
        this.originalCircle = Shape.circle();
        this.circleToDraw = new Shape();
        this.circleCenter = Point.at(0.0, 0.0);
    }

    @Override
    public <T extends MathObject> T copy() {
        return (T)ConstrCircleCenterPoint.make(this.A.copy(), this.B.copy());
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        this.circleToDraw.draw(scene, r);
    }

    @Override
    public Rect getBoundingBox() {
        this.rebuildShape();
        return this.circleToDraw.getBoundingBox();
    }

    @Override
    public MathObject getMathObject() {
        return this.circleToDraw;
    }

    @Override
    public final void rebuildShape() {
        this.computeCircleCenterRadius();
        this.circleToDraw.getPath().jmPathPoints.clear();
        this.circleToDraw.getPath().addJMPointsFrom(this.originalCircle.copy().getPath());
        this.circleToDraw.scale(this.radius);
        this.circleToDraw.shift(this.circleCenter.v);
    }

    public void computeCircleCenterRadius() {
        this.radius = this.A.to(this.B).norm();
        this.circleCenter.v.x = this.A.v.x;
        this.circleCenter.v.y = this.A.v.y;
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(this.A.getUpdateLevel(), this.B.getUpdateLevel()) + 1;
    }
}

