/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Constructible;

import com.jmathanim.Constructible.Conics.ConstrCircleCenter3Points;
import com.jmathanim.Constructible.Conics.ConstrCircleCenterPoint;
import com.jmathanim.Constructible.Conics.ConstrCircleCenterRadius;
import com.jmathanim.Constructible.GeogebraLoader;
import com.jmathanim.Constructible.Lines.ConstrLineOrthogonal;
import com.jmathanim.Constructible.Lines.ConstrLineParallel;
import com.jmathanim.Constructible.Lines.ConstrLinePointPoint;
import com.jmathanim.Constructible.Lines.ConstrPerpBisectorPointPoint;
import com.jmathanim.Constructible.Lines.ConstrPerpBisectorSegment;
import com.jmathanim.Constructible.Lines.ConstrSegmentPointPoint;
import com.jmathanim.Constructible.Lines.HasDirection;
import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Scalar;
import com.jmathanim.mathobjects.Shape;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class GeogebraCommandParser {
    protected final HashMap<String, MathObject> geogebraElements = new HashMap();

    private MathObject parseArgument(String argument) {
        if (this.geogebraElements.containsKey(argument)) {
            return this.geogebraElements.get(argument);
        }
        try {
            double value = Double.valueOf(argument);
            return new Scalar(value);
        }
        catch (NumberFormatException value) {
            Pattern pattern = Pattern.compile("\\((.*),(.*)\\)");
            Matcher matcher = pattern.matcher(argument);
            if (matcher.find()) {
                System.out.println(matcher.group(1));
                return Point.at(Double.valueOf(matcher.group(1)), Double.valueOf(matcher.group(2)));
            }
            try {
                throw new Exception("Don't know how to parse this argument " + argument);
            }
            catch (Exception ex) {
                Logger.getLogger(GeogebraLoader.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
    }

    public MathObject get(Object key) {
        return this.geogebraElements.get(key);
    }

    public boolean containsKey(Object key) {
        return this.geogebraElements.containsKey(key);
    }

    public void registerGeogebraElement(String label, MathObject resul) {
        resul.objectLabel = label;
        this.geogebraElements.put(label, resul);
    }

    private String getOutputArgument(Element el, int num) {
        Element elOutput = this.firstElementWithTag(el, "output");
        return elOutput.getAttribute("a" + num);
    }

    protected MODrawProperties parseStylingOptions(Element el) {
        Element pointSize;
        MODrawProperties resul = MODrawProperties.makeNullValues();
        Element show = this.firstElementWithTag(el, "show");
        resul.visible = "true".equals(show.getAttribute("object"));
        Element layer = this.firstElementWithTag(el, "layer");
        resul.setLayer(Integer.valueOf(layer.getAttribute("val")));
        Element objColor = this.firstElementWithTag(el, "objColor");
        int r = Integer.valueOf(objColor.getAttribute("r"));
        int g = Integer.valueOf(objColor.getAttribute("g"));
        int b = Integer.valueOf(objColor.getAttribute("b"));
        double alpha = Double.valueOf(objColor.getAttribute("alpha"));
        JMColor col = JMColor.rgbInt(r, g, b, 255);
        JMColor colFill = JMColor.rgbInt(r, g, b, 255);
        colFill.setAlpha(alpha);
        resul.setDrawColor(col);
        resul.setFillColor(colFill);
        Element lineStyle = this.firstElementWithTag(el, "lineStyle");
        if (lineStyle != null) {
            double thickness = Double.valueOf(lineStyle.getAttribute("thickness"));
            resul.setThickness(thickness);
        }
        if ((pointSize = this.firstElementWithTag(el, "pointSize")) != null) {
            double thickness = Double.valueOf(pointSize.getAttribute("val")) / 3.0;
            resul.setThickness(thickness);
        }
        return resul;
    }

    private Element firstElementWithTag(Element el, String name) {
        if (el.getElementsByTagName(name).getLength() > 0) {
            Element elInput = (Element)el.getElementsByTagName(name).item(0);
            return elInput;
        }
        return null;
    }

    private MathObject[] getArrayOfParameters(Element el) {
        Element elInput = this.firstElementWithTag(el, "input");
        MathObject[] objs = new MathObject[elInput.getAttributes().getLength()];
        for (int i = 0; i < elInput.getAttributes().getLength(); ++i) {
            String label = elInput.getAttribute("a" + i);
            objs[i] = this.geogebraElements.get(label);
        }
        return objs;
    }

    private String[] getArrayOfOutputs(Element el) {
        Element elInput = this.firstElementWithTag(el, "output");
        String[] outputs = new String[elInput.getAttributes().getLength()];
        for (int i = 0; i < elInput.getAttributes().getLength(); ++i) {
            String output;
            outputs[i] = output = elInput.getAttribute("a" + i);
        }
        return outputs;
    }

    protected void processPoint(Element el) {
        String label = el.getAttribute("label");
        Element elCoords = this.firstElementWithTag(el, "coords");
        double x = Double.valueOf(elCoords.getAttribute("x"));
        double y = Double.valueOf(elCoords.getAttribute("y"));
        Point resul = Point.at(x, y);
        resul.objectLabel = label;
        this.geogebraElements.put(label, resul);
        JMathAnimScene.logger.debug("Imported point {}", (Object)label);
    }

    protected void processSegmentCommand(Element el) {
        String label;
        Element elInput = this.firstElementWithTag(el, "input");
        String labelPoint1 = elInput.getAttribute("a0");
        String labelPoint2 = elInput.getAttribute("a1");
        Point p1 = (Point)this.geogebraElements.get(labelPoint1);
        Point p2 = (Point)this.geogebraElements.get(labelPoint2);
        ConstrSegmentPointPoint resul = ConstrSegmentPointPoint.make(p1, p2);
        resul.objectLabel = label = this.firstElementWithTag(el, "output").getAttribute("a0");
        this.geogebraElements.put(label, resul);
        JMathAnimScene.logger.debug("Generated segment {}", (Object)label);
    }

    protected void processLineCommand(Element el) {
        String label = this.getOutputArgument(el, 0);
        MathObject[] params = this.getArrayOfParameters(el);
        Point A = (Point)params[0];
        MathObject B = params[1];
        if (B instanceof Point) {
            this.registerGeogebraElement(label, ConstrLinePointPoint.make(A, (Point)B));
            return;
        }
        if (B instanceof HasDirection) {
            this.registerGeogebraElement(label, ConstrLineParallel.make(A, (HasDirection)((Object)B)));
        }
    }

    protected void processOrthogonalLine(Element el) {
        String label = this.getOutputArgument(el, 0);
        MathObject[] params = this.getArrayOfParameters(el);
        Point A = (Point)params[0];
        MathObject B = params[1];
        if (B instanceof HasDirection) {
            this.registerGeogebraElement(label, ConstrLineOrthogonal.make(A, (HasDirection)((Object)B)));
        }
    }

    void processPerpBisector(Element el) {
        String label = this.getOutputArgument(el, 0);
        MathObject[] params = this.getArrayOfParameters(el);
        if (params.length == 2) {
            Point A = (Point)params[0];
            Point B = (Point)params[1];
            this.registerGeogebraElement(label, ConstrPerpBisectorPointPoint.make(A, B));
        }
        if (params.length == 1) {
            ConstrSegmentPointPoint seg = (ConstrSegmentPointPoint)params[0];
            this.registerGeogebraElement(label, ConstrPerpBisectorSegment.make(seg));
        }
    }

    protected void processPolygonCommand(Element el) {
        String[] outputs = this.getArrayOfOutputs(el);
        String label = outputs[0];
        MathObject[] objs = this.getArrayOfParameters(el);
        Point[] points = new Point[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            points[i] = (Point)objs[i];
        }
        Shape resul = Shape.polygon(points);
        this.geogebraElements.put(label, resul);
        for (int i = 0; i < points.length; ++i) {
            int i2 = i < outputs.length - 2 ? i + 1 : 0;
            this.registerGeogebraElement(outputs[i + 1], ConstrSegmentPointPoint.make(points[i], points[i2]));
        }
    }

    protected void processCircleCommand(Element el) {
        String label = this.getOutputArgument(el, 0);
        Element elInput = this.firstElementWithTag(el, "input");
        int numberOfArguments = elInput.getAttributes().getLength();
        if (numberOfArguments == 3) {
            String str0 = elInput.getAttribute("a0");
            String str1 = elInput.getAttribute("a1");
            String str2 = elInput.getAttribute("a2");
            Point arg0 = (Point)this.parseArgument(str0);
            Point arg1 = (Point)this.parseArgument(str1);
            Point arg2 = (Point)this.parseArgument(str2);
            ConstrCircleCenter3Points resul = ConstrCircleCenter3Points.make(arg0, arg1, arg2);
            this.registerGeogebraElement(label, resul);
            JMathAnimScene.logger.debug("Imported Geogebra Circle " + label + " by 3 points: " + arg0 + ", " + arg1 + ",  " + arg2);
            return;
        }
        if (numberOfArguments == 2) {
            String str0 = elInput.getAttribute("a0");
            String str1 = elInput.getAttribute("a1");
            MathObject arg0 = this.parseArgument(str0);
            MathObject arg1 = this.parseArgument(str1);
            if (arg0 instanceof Point && arg1 instanceof Point) {
                Point p0 = (Point)arg0;
                Point p1 = (Point)arg1;
                ConstrCircleCenterPoint resul = ConstrCircleCenterPoint.make(p0, p1);
                this.registerGeogebraElement(label, resul);
                JMathAnimScene.logger.debug("Imported Geogebra Circle " + label + ", center " + p0 + ", point " + p1);
                return;
            }
            if (arg0 instanceof Point && arg1 instanceof Scalar) {
                Point p0 = (Point)arg0;
                Scalar sc0 = (Scalar)arg1;
                ConstrCircleCenterRadius resul = ConstrCircleCenterRadius.make(p0, sc0);
                this.registerGeogebraElement(label, resul);
                JMathAnimScene.logger.debug("Imported Geogebra Circle " + label + ", center " + p0 + ", radius " + sc0);
            }
        }
    }
}

