/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Constructible;

import com.jmathanim.Constructible.GeogebraCommandParser;
import com.jmathanim.Utils.ResourceLoader;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeogebraLoader {
    private final ResourceLoader rl = new ResourceLoader();
    private final URL url;
    private ZipFile zipFile;
    private ZipEntry zipEntry;
    private InputStream inputStream;
    private final GeogebraCommandParser cp;

    private GeogebraLoader(String fileName) {
        this.url = this.rl.getResource(fileName, "geogebra");
        this.cp = new GeogebraCommandParser();
    }

    public static GeogebraLoader make(String fileName) {
        GeogebraLoader resul = new GeogebraLoader(fileName);
        resul.parseFile(fileName);
        return resul;
    }

    private void parseFile(String fileName) {
        try {
            JMathAnimScene.logger.info("Loading Geogebra file {}", (Object)fileName);
            this.zipFile = new ZipFile(this.url.getFile());
            this.zipEntry = this.zipFile.getEntry("geogebra.xml");
            this.inputStream = this.zipFile.getInputStream(this.zipEntry);
            this.parseGeogebraContents(this.inputStream);
        }
        catch (IOException ex) {
            Logger.getLogger(GeogebraLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void parseGeogebraContents(InputStream inputStream) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(GeogebraLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        Element root = doc.getDocumentElement();
        if (!"geogebra".equals(root.getNodeName())) {
            try {
                throw new Exception("XML File doesn't contain a valid Geogebra file");
            }
            catch (Exception ex) {
                Logger.getLogger(GeogebraLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element el;
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !"construction".equals((el = (Element)node).getNodeName())) continue;
            this.parseConstructionChildren(el);
        }
    }

    private void parseConstructionChildren(Element constructionNode) {
        NodeList nodes = constructionNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            if ("element".equals(el.getNodeName())) {
                this.parseGeogebraElement(el);
            }
            if (!"command".equals(el.getNodeName())) continue;
            this.parseGeogebraCommand(el);
        }
    }

    private void parseGeogebraElement(Element el) {
        String type = el.getAttribute("type");
        String label = el.getAttribute("label");
        switch (type) {
            case "point": {
                this.cp.processPoint(el);
            }
        }
        if (this.cp.containsKey(label)) {
            this.cp.get(label).getMp().copyFrom(this.cp.parseStylingOptions(el));
        }
    }

    private void parseGeogebraCommand(Element el) {
        String name;
        switch (name = el.getAttribute("name")) {
            case "Segment": {
                this.cp.processSegmentCommand(el);
                break;
            }
            case "Polygon": {
                this.cp.processPolygonCommand(el);
                break;
            }
            case "Circle": {
                this.cp.processCircleCommand(el);
                break;
            }
            case "Line": {
                this.cp.processLineCommand(el);
                break;
            }
            case "OrthogonalLine": {
                this.cp.processOrthogonalLine(el);
                break;
            }
            case "LineBisector": {
                this.cp.processPerpBisector(el);
            }
        }
    }

    public MathObject get(Object key) {
        return this.cp.get(key);
    }

    public Collection<MathObject> getObjects() {
        return this.cp.geogebraElements.values();
    }

    public HashMap<String, MathObject> getDict() {
        return this.cp.geogebraElements;
    }
}

