/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Constructible.Lines;

import com.jmathanim.Constructible.Constructible;
import com.jmathanim.Constructible.Lines.HasDirection;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Line;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;

public class ConstrLineParallel
extends Constructible
implements HasDirection {
    Point A;
    HasDirection dir;
    private final Line lineToDraw;

    public static ConstrLineParallel make(Point A, HasDirection dir) {
        ConstrLineParallel resul = new ConstrLineParallel(A, dir);
        resul.rebuildShape();
        return resul;
    }

    private ConstrLineParallel(Point A, HasDirection dir) {
        this.A = A;
        this.dir = dir;
        this.lineToDraw = new Line(A, this.dir.getDirection());
    }

    @Override
    public <T extends MathObject> T copy() {
        return (T)ConstrLineParallel.make(this.A.copy(), this.dir);
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        this.lineToDraw.draw(scene, r);
    }

    @Override
    public Vec getDirection() {
        return this.dir.getDirection();
    }

    @Override
    public MathObject getMathObject() {
        return this.lineToDraw;
    }

    @Override
    public void rebuildShape() {
        this.lineToDraw.getP1().v.x = this.A.v.x;
        this.lineToDraw.getP1().v.y = this.A.v.y;
        this.lineToDraw.getP2().v.x = this.A.v.x + this.dir.getDirection().x;
        this.lineToDraw.getP2().v.y = this.A.v.y + this.dir.getDirection().y;
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(this.A.getUpdateLevel(), ((MathObject)((Object)this.dir)).getUpdateLevel()) + 1;
    }
}

