/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Constructible.Lines;

import com.jmathanim.Constructible.Constructible;
import com.jmathanim.Constructible.Lines.HasDirection;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Line;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;

public class ConstrPerpBisectorPointPoint
extends Constructible
implements HasDirection {
    Point A;
    Point B;
    private final Line lineToDraw;

    public static ConstrPerpBisectorPointPoint make(Point A, Point B) {
        ConstrPerpBisectorPointPoint resul = new ConstrPerpBisectorPointPoint(A, B);
        resul.rebuildShape();
        return resul;
    }

    private ConstrPerpBisectorPointPoint(Point A, Point B) {
        this.A = A;
        this.B = B;
        this.lineToDraw = new Line(Point.origin(), Point.origin());
    }

    @Override
    public <T extends MathObject> T copy() {
        return (T)new ConstrPerpBisectorPointPoint(this.A.copy(), this.B.copy());
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        this.lineToDraw.draw(scene, r);
    }

    @Override
    public Vec getDirection() {
        return this.lineToDraw.getDirection();
    }

    @Override
    public MathObject getMathObject() {
        return this.lineToDraw;
    }

    @Override
    public void rebuildShape() {
        Point C = this.A.interpolate(this.B, 0.5);
        Vec v = this.A.to(this.B);
        this.lineToDraw.getP1().v.x = C.v.x;
        this.lineToDraw.getP1().v.y = C.v.y;
        this.lineToDraw.getP2().v.x = C.v.x - v.y;
        this.lineToDraw.getP2().v.y = C.v.y + v.x;
    }
}

