/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Constructible.Lines;

import com.jmathanim.Constructible.Constructible;
import com.jmathanim.Constructible.Lines.ConstrSegmentPointPoint;
import com.jmathanim.Constructible.Lines.HasDirection;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Line;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;

public class ConstrPerpBisectorSegment
extends Constructible
implements HasDirection {
    ConstrSegmentPointPoint segment;
    private final Line lineToDraw;

    public static ConstrPerpBisectorSegment make(ConstrSegmentPointPoint segment) {
        ConstrPerpBisectorSegment resul = new ConstrPerpBisectorSegment(segment);
        resul.rebuildShape();
        return resul;
    }

    private ConstrPerpBisectorSegment(ConstrSegmentPointPoint segment) {
        this.segment = segment;
        this.lineToDraw = new Line(Point.origin(), Point.origin());
    }

    @Override
    public <T extends MathObject> T copy() {
        return (T)new ConstrPerpBisectorSegment((ConstrSegmentPointPoint)this.segment.copy());
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        this.lineToDraw.draw(scene, r);
    }

    @Override
    public Vec getDirection() {
        return this.lineToDraw.getDirection();
    }

    @Override
    public MathObject getMathObject() {
        return this.lineToDraw;
    }

    @Override
    public void rebuildShape() {
        Point C = this.segment.getA().interpolate(this.segment.getB(), 0.5);
        Vec v = this.segment.getDirection();
        this.lineToDraw.getP1().v.x = C.v.x;
        this.lineToDraw.getP1().v.y = C.v.y;
        this.lineToDraw.getP2().v.x = C.v.x - v.y;
        this.lineToDraw.getP2().v.y = C.v.y + v.x;
    }
}

