/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Renderers.FXRenderer;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Utils.Vec;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.Point;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

public class FXPathUtils {
    public static double EPSILON = 1.0E-4;

    public JMPath createJMPathFromFXPath(Path pa, Camera cam) {
        JMPath resul = new JMPath();
        JMPathPoint previousPP = JMPathPoint.curveTo(Point.origin());
        JMPathPoint currentMoveToPoint = null;
        for (PathElement el : pa.getElements()) {
            JMPathPoint pp;
            double[] xy;
            MoveTo c;
            if (el instanceof MoveTo) {
                c = (MoveTo)el;
                xy = cam.screenToMath(c.getX(), c.getY());
                pp = JMPathPoint.lineTo(Point.at(xy[0], xy[1]));
                pp.isThisSegmentVisible = false;
                resul.addJMPoint(pp);
                previousPP = pp;
                currentMoveToPoint = pp;
            }
            if (el instanceof CubicCurveTo) {
                c = (CubicCurveTo)el;
                xy = cam.screenToMath(c.getX(), c.getY());
                pp = JMPathPoint.curveTo(Point.at(xy[0], xy[1]));
                xy = cam.screenToMath(c.getControlX2(), c.getControlY2());
                pp.cpEnter.v.x = xy[0];
                pp.cpEnter.v.y = xy[1];
                xy = cam.screenToMath(c.getControlX1(), c.getControlY1());
                previousPP.cpExit.v.x = xy[0];
                previousPP.cpExit.v.y = xy[1];
                resul.addJMPoint(pp);
                previousPP = pp;
            }
            if (el instanceof LineTo) {
                c = (LineTo)el;
                xy = cam.screenToMath(c.getX(), c.getY());
                pp = JMPathPoint.lineTo(Point.at(xy[0], xy[1]));
                resul.addJMPoint(pp);
                previousPP = pp;
            }
            if (!(el instanceof ClosePath) || currentMoveToPoint == null) continue;
            JMPathPoint cc = currentMoveToPoint.copy();
            cc.isThisSegmentVisible = true;
            resul.addJMPoint(cc);
        }
        if (resul.jmPathPoints.size() > 0) {
            if (resul.jmPathPoints.get((int)0).p.isEquivalentTo(resul.jmPathPoints.get((int)-1).p, 1.0E-6)) {
                JMPathPoint fp = resul.jmPathPoints.get(0);
                JMPathPoint lp = resul.jmPathPoints.get(-1);
                fp.cpEnter.v.x = lp.cpEnter.v.x;
                fp.cpEnter.v.y = lp.cpEnter.v.y;
                fp.isThisSegmentVisible = true;
                resul.jmPathPoints.remove(lp);
            }
            resul.distille();
        }
        return resul;
    }

    public static Path createFXPathFromJMPath(JMPath jmpath, Camera camera) {
        Path path = new Path();
        Vec p = jmpath.jmPathPoints.get((int)0).p.v;
        double[] scr = camera.mathToScreen(p.x, p.y);
        path.getElements().add((Object)new MoveTo(scr[0], scr[1]));
        for (int n = 1; n < jmpath.size() + 1; ++n) {
            Vec point = jmpath.jmPathPoints.get((int)n).p.v;
            Vec cpoint1 = jmpath.jmPathPoints.get((int)(n - 1)).cpExit.v;
            Vec cpoint2 = jmpath.jmPathPoints.get((int)n).cpEnter.v;
            double[] xy = camera.mathToScreenFX(point);
            double[] cxy1 = camera.mathToScreenFX(cpoint1);
            double[] cxy2 = camera.mathToScreenFX(cpoint2);
            if (jmpath.jmPathPoints.get((int)n).isThisSegmentVisible) {
                if (jmpath.jmPathPoints.get((int)n).isCurved) {
                    path.getElements().add((Object)new CubicCurveTo(cxy1[0], cxy1[1], cxy2[0], cxy2[1], xy[0], xy[1]));
                    continue;
                }
                path.getElements().add((Object)new LineTo(xy[0], xy[1]));
                continue;
            }
            if (n >= jmpath.size() + 1) continue;
            path.getElements().add((Object)new MoveTo(xy[0], xy[1]));
        }
        return path;
    }

    public void distille(Path path) {
        int n = 0;
        Double[] xyPrevious = new Double[]{null, null};
        while (n < path.getElements().size() - 1) {
            PathElement el2;
            PathElement el1 = (PathElement)path.getElements().get(n);
            if (FXPathUtils.isFirstElementRedundant(xyPrevious, el1, el2 = (PathElement)path.getElements().get(n + 1))) {
                path.getElements().remove((Object)el1);
                n = 0;
                continue;
            }
            if (FXPathUtils.isSecondElementRedundant(xyPrevious, el1, el2)) {
                path.getElements().remove((Object)el2);
                n = 0;
                continue;
            }
            xyPrevious = FXPathUtils.getXYFromPathElement(el1);
            ++n;
        }
    }

    private static boolean isSecondElementRedundant(Double[] xyPrevious, PathElement el1, PathElement el2) {
        if (FXPathUtils.sameXY(el1, el2)) {
            if (el1 instanceof CubicCurveTo && el2 instanceof CubicCurveTo) {
                CubicCurveTo cc1 = (CubicCurveTo)el1;
                CubicCurveTo cc2 = (CubicCurveTo)el2;
                cc1.setControlX2(cc2.getControlX2());
                cc1.setControlY2(cc2.getControlY2());
            }
            return true;
        }
        return el1 instanceof MoveTo && el2 instanceof ClosePath;
    }

    private static boolean isFirstElementRedundant(Double[] xyPrevious, PathElement el1, PathElement el2) {
        if (el1 instanceof MoveTo && el2 instanceof MoveTo) {
            return true;
        }
        if (el1 instanceof LineTo && el2 instanceof LineTo) {
            Double[] xy1 = FXPathUtils.getXYFromPathElement(el1);
            Double[] xy2 = FXPathUtils.getXYFromPathElement(el2);
            Vec v1 = Vec.to(xy1[0] - xyPrevious[0], xy1[1] - xyPrevious[1]);
            Vec v2 = Vec.to(xy2[0] - xyPrevious[0], xy2[1] - xyPrevious[1]);
            double n1 = v1.norm();
            double n2 = v2.norm();
            if (v1.dot(v2) / (n1 * n2) == 1.0) {
                return true;
            }
        }
        return false;
    }

    private static boolean sameXY(PathElement el1, PathElement el2) {
        Double[] xy1 = FXPathUtils.getXYFromPathElement(el1);
        Double[] xy2 = FXPathUtils.getXYFromPathElement(el2);
        return Math.abs(xy1[0] - xy2[0]) < EPSILON && Math.abs(xy1[1] - xy2[1]) < EPSILON;
    }

    private static Double[] getXYFromPathElement(PathElement el) {
        MoveTo elTyped;
        Double[] resul = new Double[2];
        if (el instanceof MoveTo) {
            elTyped = (MoveTo)el;
            resul[0] = elTyped.getX();
            resul[1] = elTyped.getY();
        }
        if (el instanceof LineTo) {
            elTyped = (LineTo)el;
            resul[0] = elTyped.getX();
            resul[1] = elTyped.getY();
        }
        if (el instanceof CubicCurveTo) {
            elTyped = (CubicCurveTo)el;
            resul[0] = elTyped.getX();
            resul[1] = elTyped.getY();
        }
        if (el instanceof ClosePath) {
            resul[0] = Double.NaN;
            resul[1] = Double.NaN;
        }
        return resul;
    }
}

