/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Renderers.FXRenderer;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.FXRenderer.FXPathUtils;
import com.jmathanim.Renderers.FXRenderer.StandaloneSnapshot;
import com.jmathanim.Renderers.MovieEncoders.VideoEncoder;
import com.jmathanim.Renderers.MovieEncoders.XugglerVideoEncoder;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.ResourceLoader;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.AbstractJMImage;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javax.imageio.ImageIO;

public class JavaFXRenderer
extends Renderer {
    private static final double XMIN_DEFAULT = -2.0;
    private static final double XMAX_DEFAULT = 2.0;
    private static final double MIN_THICKNESS = 0.2;
    public final FXPathUtils fXPathUtils;
    public Camera camera;
    public Camera fixedCamera;
    private final HashMap<String, Image> images;
    private PerspectiveCamera fxCamera;
    public double FxCamerarotateX = 0.0;
    public double FxCamerarotateY = 0.0;
    public double FxCamerarotateZ = 0.0;
    private Scene fxScene;
    private Group group;
    private Group groupRoot;
    private Group groupBackground;
    private Group groupDebug;
    DropShadow dropShadow;
    private final ArrayList<Node> fxnodes = new ArrayList();
    private final ArrayList<Node> debugFXnodes = new ArrayList();
    private VideoEncoder videoEncoder;
    private File saveFilePath;
    public double correctionThickness;

    public JavaFXRenderer(JMathAnimScene parentScene) throws Exception {
        super(parentScene);
        this.images = new HashMap();
        this.fXPathUtils = new FXPathUtils();
        this.camera = new Camera(this.scene, this.config.mediaW, this.config.mediaH);
        this.fixedCamera = new Camera(this.scene, this.config.mediaW, this.config.mediaH);
        this.correctionThickness = (double)this.config.mediaW * 1.0 / 1066.0;
    }

    @Override
    public void initialize() {
        this.camera.initialize(-2.0, 2.0, 0.0);
        this.fixedCamera.initialize(-2.0, 2.0, 0.0);
        try {
            this.prepareEncoder();
        }
        catch (Exception ex) {
            Logger.getLogger(JavaFXRenderer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public final void prepareEncoder() throws Exception {
        JMathAnimScene.logger.info("Preparing encoder");
        this.initializeJavaFXWindow();
        if (this.config.isCreateMovie()) {
            this.videoEncoder = new XugglerVideoEncoder();
            File tempPath = new File(this.config.getOutputDir().getCanonicalPath());
            tempPath.mkdirs();
            this.saveFilePath = new File(this.config.getOutputDir().getCanonicalPath() + File.separator + this.config.getOutputFileName() + "_" + this.config.mediaH + ".mp4");
            JMathAnimScene.logger.info("Creating movie encoder for {}", (Object)this.saveFilePath);
            this.videoEncoder.createEncoder(this.saveFilePath, this.config);
        }
        if (this.config.drawShadow) {
            this.dropShadow = new DropShadow();
            this.dropShadow.setRadius((double)this.config.shadowKernelSize);
            this.dropShadow.setOffsetX((double)this.config.shadowOffsetX);
            this.dropShadow.setOffsetY((double)this.config.shadowOffsetY);
            this.dropShadow.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)this.config.shadowAlpha));
        }
    }

    public final void initializeJavaFXWindow() throws Exception {
        new Thread(() -> Application.launch(StandaloneSnapshot.FXStarter.class, (String[])new String[0])).start();
        StandaloneSnapshot.FXStarter.awaitFXToolkit();
        final JavaFXRenderer r = this;
        FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                JavaFXRenderer.this.group = new Group();
                JavaFXRenderer.this.groupRoot = new Group();
                JavaFXRenderer.this.groupBackground = new Group();
                JavaFXRenderer.this.groupDebug = new Group();
                if (JavaFXRenderer.this.config.getBackGroundImage() != null) {
                    ImageView background = new ImageView(new Image(JavaFXRenderer.this.config.getBackGroundImage().openStream()));
                    Rectangle2D viewport = new Rectangle2D(0.0, 0.0, (double)((JavaFXRenderer)JavaFXRenderer.this).config.mediaW, (double)((JavaFXRenderer)JavaFXRenderer.this).config.mediaH);
                    background.setViewport(viewport);
                    JavaFXRenderer.this.groupBackground.getChildren().clear();
                    JavaFXRenderer.this.groupBackground.getChildren().add((Object)background);
                }
                JavaFXRenderer.this.groupRoot.getChildren().add((Object)JavaFXRenderer.this.groupBackground);
                JavaFXRenderer.this.groupRoot.getChildren().add((Object)JavaFXRenderer.this.group);
                JavaFXRenderer.this.groupRoot.getChildren().add((Object)JavaFXRenderer.this.groupDebug);
                JavaFXRenderer.this.fxScene = new Scene((Parent)JavaFXRenderer.this.groupRoot, (double)((JavaFXRenderer)JavaFXRenderer.this).config.mediaW, (double)((JavaFXRenderer)JavaFXRenderer.this).config.mediaH);
                JavaFXRenderer.this.fxScene.setFill(JavaFXRenderer.this.config.getBackgroundColor().getFXPaint(r, JavaFXRenderer.this.camera));
                StandaloneSnapshot.FXStarter.stage.setScene(JavaFXRenderer.this.fxScene);
                JavaFXRenderer.this.fxCamera = new PerspectiveCamera();
                JavaFXRenderer.this.fxScene.setCamera((javafx.scene.Camera)JavaFXRenderer.this.fxCamera);
                if (JavaFXRenderer.this.config.isShowPreview()) {
                    JMathAnimScene.logger.info("Creating preview window");
                    StandaloneSnapshot.FXStarter.stage.setHeight((double)(((JavaFXRenderer)JavaFXRenderer.this).config.mediaH + 38));
                    StandaloneSnapshot.FXStarter.stage.setWidth((double)(((JavaFXRenderer)JavaFXRenderer.this).config.mediaW + 16));
                    StandaloneSnapshot.FXStarter.stage.show();
                }
                return 1;
            }
        });
        Platform.runLater(task);
        task.get();
    }

    public final void endJavaFXEngine() {
        Platform.exit();
    }

    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public Camera getFixedCamera() {
        return this.fixedCamera;
    }

    @Override
    public void saveFrame(final int frameCount) {
        Rectangle clip = new Rectangle(8000.0, 6000.0);
        clip.setLayoutX(25.0);
        clip.setLayoutY(25.0);
        BufferedImage bi = new BufferedImage(this.config.mediaW, this.config.mediaH, 2);
        final JavaFXRenderer r = this;
        FutureTask<WritableImage> task = new FutureTask<WritableImage>(new Callable<WritableImage>(){

            @Override
            public WritableImage call() throws Exception {
                JavaFXRenderer.this.fxScene.setFill(JavaFXRenderer.this.config.getBackgroundColor().getFXPaint(r, JavaFXRenderer.this.camera));
                JavaFXRenderer.this.group.getChildren().clear();
                JavaFXRenderer.this.groupDebug.getChildren().clear();
                JavaFXRenderer.this.fxCamera.getTransforms().clear();
                JavaFXRenderer.this.fxCamera.getTransforms().addAll((Object[])new Transform[]{new Translate((double)(((JavaFXRenderer)JavaFXRenderer.this).config.mediaW / 2), (double)(((JavaFXRenderer)JavaFXRenderer.this).config.mediaH / 2), 0.0), new Rotate(JavaFXRenderer.this.FxCamerarotateX, Rotate.X_AXIS), new Rotate(JavaFXRenderer.this.FxCamerarotateY, Rotate.Y_AXIS), new Rotate(JavaFXRenderer.this.FxCamerarotateZ, Rotate.Z_AXIS), new Translate((double)(-((JavaFXRenderer)JavaFXRenderer.this).config.mediaW / 2), (double)(-((JavaFXRenderer)JavaFXRenderer.this).config.mediaH / 2), 0.0)});
                JavaFXRenderer.this.group.getChildren().addAll((Collection)JavaFXRenderer.this.fxnodes);
                if (((JavaFXRenderer)JavaFXRenderer.this).config.showFrameNumbers) {
                    JavaFXRenderer.this.showDebugFrame(frameCount, 1.0 * (double)frameCount / (double)((JavaFXRenderer)JavaFXRenderer.this).config.fps);
                }
                JavaFXRenderer.this.groupDebug.getChildren().addAll((Collection)JavaFXRenderer.this.debugFXnodes);
                if (((JavaFXRenderer)JavaFXRenderer.this).config.drawShadow) {
                    JavaFXRenderer.this.group.setEffect((Effect)JavaFXRenderer.this.dropShadow);
                }
                SnapshotParameters params = new SnapshotParameters();
                params.setFill(JavaFXRenderer.this.config.getBackgroundColor().getFXPaint(r, JavaFXRenderer.this.camera));
                params.setViewport(new Rectangle2D(0.0, 0.0, (double)((JavaFXRenderer)JavaFXRenderer.this).config.mediaW, (double)((JavaFXRenderer)JavaFXRenderer.this).config.mediaH));
                params.setCamera(JavaFXRenderer.this.fxScene.getCamera());
                return JavaFXRenderer.this.fxScene.getRoot().snapshot(params, null);
            }
        });
        Platform.runLater(task);
        try {
            WritableImage img2 = task.get();
            bi = SwingFXUtils.fromFXImage((Image)img2, null);
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(JavaFXRenderer.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.config.isCreateMovie()) {
            this.videoEncoder.writeFrame(bi, frameCount);
        }
        if (this.config.isSaveToPNG()) {
            try {
                File fpng = new File(this.config.getOutputDir().getCanonicalPath() + File.separator + this.config.getOutputFileName() + String.format("%06d", frameCount) + ".png");
                ImageIO.write((RenderedImage)bi, "png", fpng);
            }
            catch (IOException ex) {
                Logger.getLogger(JavaFXRenderer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void finish(int frameCount) {
        JMathAnimScene.logger.info(String.format("%d frames created, %.2fs total time", frameCount, Float.valueOf(1.0f * (float)frameCount / (float)this.config.fps)));
        if (this.config.isCreateMovie()) {
            JMathAnimScene.logger.info("Finishing movie...");
            this.videoEncoder.finish();
            if (this.videoEncoder.isFramesGenerated()) {
                JMathAnimScene.logger.info("Movie created at " + this.saveFilePath);
            }
        }
        this.endJavaFXEngine();
    }

    @Override
    public void clear() {
        this.fxnodes.clear();
        this.debugFXnodes.clear();
    }

    @Override
    public void drawPath(Shape mobj) {
        this.drawPath(mobj, this.camera);
    }

    private void drawPath(Shape mobj, Camera cam) {
        JMPath c = mobj.getPath();
        int numPoints = c.size();
        if (numPoints >= 2) {
            Path path = FXPathUtils.createFXPathFromJMPath(c, cam);
            this.applyDrawingStyles(path, mobj);
            this.fxnodes.add((Node)path);
        }
        if (!"".equals(mobj.getDebugText())) {
            this.debugText(mobj.getDebugText(), mobj.getCenter().v);
        }
    }

    private void applyDrawingStyles(Path path, Shape mobj) {
        path.setStrokeLineCap(mobj.getMp().getLinecap());
        path.setStrokeLineJoin(StrokeLineJoin.ROUND);
        path.setStrokeType(StrokeType.CENTERED);
        path.setStroke(mobj.getMp().getDrawColor().getFXPaint(this, this.camera));
        double th = this.computeThickness(mobj);
        path.setStrokeWidth(th);
        path.setFill(mobj.getMp().getFillColor().getFXPaint(this, this.camera));
        switch (mobj.getMp().getDashStyle()) {
            case SOLID: {
                break;
            }
            case DASHED: {
                path.getStrokeDashArray().addAll((Object[])new Double[]{this.MathWidthToThickness(0.025), this.MathWidthToThickness(0.005)});
                path.setStrokeLineCap(StrokeLineCap.BUTT);
                break;
            }
            case DOTTED: {
                path.getStrokeDashArray().addAll((Object[])new Double[]{this.MathWidthToThickness(0.0025), this.MathWidthToThickness(0.005)});
                path.setStrokeLineCap(StrokeLineCap.BUTT);
                break;
            }
            case DASHDOTTED: {
                path.getStrokeDashArray().addAll((Object[])new Double[]{this.MathWidthToThickness(0.025), this.MathWidthToThickness(0.005), this.MathWidthToThickness(0.0025), this.MathWidthToThickness(0.005)});
                path.setStrokeLineCap(StrokeLineCap.BUTT);
            }
        }
    }

    public double computeThickness(MathObject mobj) {
        Camera cam = mobj.getMp().isAbsoluteThickness() != false ? this.fixedCamera : this.camera;
        return Math.max(mobj.getMp().getThickness() / cam.getMathView().getWidth() * this.correctionThickness, 0.2);
    }

    @Override
    public double MathWidthToThickness(double w) {
        return w * 1066.0;
    }

    @Override
    public double ThicknessToMathWidth(double th) {
        return th / 1066.0;
    }

    @Override
    public double ThicknessToMathWidth(MathObject obj) {
        Camera cam = obj.getMp().isAbsoluteThickness() != false ? this.fixedCamera : this.camera;
        return obj.getMp().getThickness() / 1066.0 * 4.0 / cam.getMathView().getWidth();
    }

    @Override
    public void drawAbsoluteCopy(Shape sh, Vec anchor) {
        Shape shape = sh.copy();
        Vec vFixed = this.defaultToFixedCamera(anchor);
        shape.shift(vFixed.minus(anchor));
        this.drawPath(shape, this.fixedCamera);
    }

    public Vec defaultToFixedCamera(Vec v) {
        double[] ms = this.camera.mathToScreenFX(v);
        double[] coords = this.fixedCamera.screenToMath(ms[0], ms[1]);
        return new Vec(coords[0], coords[1]);
    }

    @Override
    public Rect createImage(String fileName) {
        Rect r = new Rect(0.0, 0.0, 0.0, 0.0);
        try {
            Image image;
            if (!this.images.containsKey(fileName)) {
                ResourceLoader rl = new ResourceLoader();
                URL imageResource = rl.getResource(fileName, "images");
                image = new Image(imageResource.openStream());
                this.images.put(fileName, image);
                JMathAnimScene.logger.info("Loaded image " + fileName);
            } else {
                image = this.images.get(fileName);
            }
            r.ymin = -this.camera.screenToMath(image.getHeight());
            r.xmax = this.camera.screenToMath(image.getWidth());
        }
        catch (IOException ex) {
            JMathAnimScene.logger.warn("Could'nt load image " + fileName);
        }
        return r;
    }

    public Image getImageFromCatalog(AbstractJMImage obj) {
        return this.images.get(obj.getId());
    }

    @Override
    public void drawImage(AbstractJMImage obj) {
        ImageView imageView;
        if (obj.isCached()) {
            Image image = this.getImageFromCatalog(obj);
            imageView = new ImageView(image);
        } else {
            imageView = new ImageView(obj.getImage());
        }
        double[] xy = this.camera.mathToScreenFX(obj.bbox.getUL().v);
        imageView.setX(xy[0]);
        imageView.setY(xy[1]);
        imageView.setFitHeight(this.camera.mathToScreen(obj.bbox.getHeight()));
        imageView.setFitWidth(this.camera.mathToScreen(obj.bbox.getWidth()));
        imageView.setPreserveRatio(obj.preserveRatio);
        imageView.setSmooth(true);
        imageView.setCache(true);
        imageView.setOpacity(obj.getMp().getDrawColor().getAlpha());
        imageView.setRotate(-obj.rotateAngle / (Math.PI / 180));
        this.fxnodes.add((Node)imageView);
    }

    @Override
    public void debugText(String text, Vec loc) {
        double[] xy = this.camera.mathToScreenFX(loc);
        Text t = new Text(text);
        t.setFont(new Font(16.0));
        Bounds b1 = t.getLayoutBounds();
        t.setX(xy[0] - 0.5 * b1.getWidth());
        t.setY(xy[1] + 0.5 * b1.getHeight());
        Bounds b = t.getLayoutBounds();
        double gap = 2.0;
        Rectangle rectangle = new Rectangle(b.getMinX() - gap, b.getMinY() - gap, b.getWidth() + gap, b.getHeight() + gap);
        rectangle.setFill((Paint)Color.LIGHTBLUE);
        rectangle.setStroke((Paint)Color.DARKBLUE);
        this.debugFXnodes.add((Node)rectangle);
        this.debugFXnodes.add((Node)t);
    }

    private void showDebugFrame(int numFrame, double time) {
        Text t = new Text("Frame: " + numFrame + " (" + String.format("%.2f", time) + "s)");
        t.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)48.0));
        t.setFill((Paint)Color.ALICEBLUE);
        t.setStroke((Paint)Color.BLACK);
        t.setX(0.0);
        t.setY(0.0);
        t.setTextOrigin(VPos.TOP);
        this.debugFXnodes.add((Node)t);
    }

    public void addSound(File soundFile, int frameCount) {
        try {
            this.videoEncoder.addSound(soundFile, frameCount);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaFXRenderer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

