/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Renderers.FXRenderer;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javax.imageio.ImageIO;

public class StandaloneSnapshot {
    public int w;
    public int h;

    protected void manipulatePdf() throws Exception {
        WritableImage img1 = this.image1();
        BufferedImage bImg1 = SwingFXUtils.fromFXImage((Image)img1, (BufferedImage)new BufferedImage((int)img1.getWidth(), (int)img1.getHeight(), 2));
        ImageIO.write((RenderedImage)bImg1, "png", new File("rect.png"));
        WritableImage img2 = this.image2();
        BufferedImage bImg2 = SwingFXUtils.fromFXImage((Image)img2, (BufferedImage)new BufferedImage((int)img2.getWidth(), (int)img2.getHeight(), 2));
        ImageIO.write((RenderedImage)bImg2, "png", new File("chart.png"));
    }

    private WritableImage image1() throws Exception {
        Rectangle rectangle = new Rectangle();
        rectangle.setX(50.0);
        rectangle.setY(50.0);
        rectangle.setWidth(300.0);
        rectangle.setHeight(20.0);
        rectangle.setStroke((Paint)Color.WHITE);
        LinearGradient linearGrad = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)0, (int)0, (double)1.0)), new Stop(0.25, Color.rgb((int)255, (int)255, (int)0, (double)1.0)), new Stop(0.5, Color.rgb((int)255, (int)255, (int)255, (double)1.0)), new Stop(0.75, Color.rgb((int)124, (int)252, (int)0, (double)1.0)), new Stop(1.0, Color.rgb((int)0, (int)255, (int)0, (double)1.0))});
        rectangle.setFill((Paint)linearGrad);
        FutureTask<WritableImage> task = new FutureTask<WritableImage>(() -> {
            new Scene((Parent)new Pane(new Node[]{rectangle}));
            WritableImage img = new WritableImage((int)rectangle.getWidth(), (int)rectangle.getHeight());
            rectangle.snapshot(null, img);
            return img;
        });
        Platform.runLater(task);
        return task.get();
    }

    private WritableImage image2() throws Exception {
        BarChart chart = new BarChart((Axis)new CategoryAxis(), (Axis)new NumberAxis());
        Random rng = new Random();
        XYChart.Series series = new XYChart.Series();
        series.setName("Data");
        for (int i = 1; i <= 10; ++i) {
            series.getData().add((Object)new XYChart.Data((Object)("Group " + i), (Object)rng.nextDouble()));
        }
        chart.getData().add((Object)series);
        FutureTask<WritableImage> task = new FutureTask<WritableImage>(() -> {
            new Scene((Parent)chart);
            WritableImage img = chart.snapshot(null, null);
            return img;
        });
        Platform.runLater(task);
        return task.get();
    }

    public static class FXStarter
    extends Application {
        public static Stage stage;
        private static final CountDownLatch latch;

        public static void awaitFXToolkit() throws InterruptedException {
            latch.await();
        }

        public void init() {
            latch.countDown();
        }

        public void start(Stage primaryStage) {
            stage = primaryStage;
            stage.setTitle("JMathAnim preview window");
        }

        static {
            latch = new CountDownLatch(1);
        }
    }
}

