/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Renderers.MovieEncoders;

import com.jmathanim.Renderers.MovieEncoders.VideoEncoder;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class XugglerVideoEncoder
extends VideoEncoder {
    IMediaWriter writer;
    private double fps;
    private boolean framesGenerated;
    private boolean playSound;
    public static int BITRATE = 48000;
    public static int NUM_CHANNELS = 2;
    private long soundFrame;

    @Override
    public void createEncoder(File output, JMathAnimConfig config) throws IOException {
        this.framesGenerated = false;
        this.writer = ToolFactory.makeWriter((String)output.getCanonicalPath());
        this.writer.addVideoStream(0, 0, ICodec.ID.CODEC_ID_H264, config.mediaW, config.mediaH);
        this.writer.addAudioStream(1, 0, NUM_CHANNELS, BITRATE);
        this.soundFrame = 0L;
        this.fps = config.fps;
    }

    @Override
    public void addSound(File soundFile, int frameCount) throws IOException {
        IContainer containerAudio = IContainer.make();
        containerAudio.open(soundFile.getCanonicalPath(), IContainer.Type.READ, null);
        int audiostreamt = -1;
        int numStreamAudio = containerAudio.getNumStreams();
        for (int i = 0; i < numStreamAudio; ++i) {
            IStream stream = containerAudio.getStream((long)i);
            IStreamCoder code = stream.getStreamCoder();
            if (code.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            audiostreamt = i;
            break;
        }
        IStreamCoder audioCoder = containerAudio.getStream((long)audiostreamt).getStreamCoder();
        System.out.println("Channels: " + audioCoder.getChannels());
        if (audioCoder.open() < 0) {
            throw new RuntimeException("Cant open audio coder");
        }
        this.addSilence((long)frameCount - this.soundFrame);
        IPacket packetaudio = IPacket.make();
        while (containerAudio.readNextPacket(packetaudio) >= 0) {
            IAudioSamples samples = IAudioSamples.make((long)512L, (long)audioCoder.getChannels(), (IAudioSamples.Format)IAudioSamples.Format.FMT_S32);
            ByteBuffer aa = packetaudio.getData().getByteBuffer(0, packetaudio.getSize());
            byte[] myBytes = new byte[aa.remaining()];
            aa.get(myBytes);
            short[] mySamples = new short[myBytes.length / 2];
            for (int i = 0; i < mySamples.length; ++i) {
                mySamples[i] = (short)(myBytes[2 * i] << 8 | myBytes[2 * i + 1]);
            }
            this.writer.encodeAudio(1, mySamples);
            this.soundFrame = (long)((double)this.soundFrame + (double)mySamples.length * this.fps / (double)NUM_CHANNELS / (double)BITRATE);
        }
        containerAudio.close();
        audioCoder.close();
    }

    private void addSilence(long numFrame) {
        int size = (int)((double)numFrame / this.fps * (double)NUM_CHANNELS * (double)BITRATE);
        short[] silence = new short[size];
        for (int i = 0; i < silence.length; ++i) {
            silence[i] = 0;
        }
        this.writer.encodeAudio(1, silence);
        this.soundFrame += numFrame;
    }

    @Override
    public void writeFrame(BufferedImage image, int frameCount) {
        this.framesGenerated = true;
        BufferedImage bgrScreen = XugglerVideoEncoder.convertToType(image, 5);
        long nanosecondsElapsed = (long)(1.0E9 * (double)frameCount / this.fps);
        if (frameCount == 60) {
            long l = (long)(1.0E9 * (double)frameCount / this.fps);
        }
        this.writer.encodeVideo(0, bgrScreen, nanosecondsElapsed, TimeUnit.NANOSECONDS);
    }

    @Override
    public void finish() {
        if (this.framesGenerated) {
            this.writer.close();
        } else {
            JMathAnimScene.logger.info("No frames generated. Empty movie created.");
        }
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }

    @Override
    public boolean isFramesGenerated() {
        return this.framesGenerated;
    }

    public void getSampleFromAudioFile(File fileIn) {
        int totalFramesRead = 0;
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(fileIn);
            int bytesPerFrame = audioInputStream.getFormat().getFrameSize();
            if (bytesPerFrame == -1) {
                bytesPerFrame = 1;
            }
            int numBytes = 1024 * bytesPerFrame;
            byte[] audioBytes = new byte[numBytes];
            try {
                int numBytesRead = 0;
                int numFramesRead = 0;
                while ((numBytesRead = audioInputStream.read(audioBytes)) != -1) {
                    numFramesRead = numBytesRead / bytesPerFrame;
                    totalFramesRead += numFramesRead;
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (IOException | UnsupportedAudioFileException exception) {
            // empty catch block
        }
    }
}

