/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Styling;

import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.ResourceLoader;
import com.jmathanim.jmathanim.JMathAnimScene;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigLoader {
    private static ResourceLoader resourceLoader;

    public static void parseFile(String filename) {
        resourceLoader = new ResourceLoader();
        try {
            JMathAnimConfig config = JMathAnimConfig.getConfig();
            URL configURL = resourceLoader.getResource(filename, "config");
            JMathAnimScene.logger.info("Loading config file {}", (Object)filename);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            InputStream stream = configURL.openStream();
            Document doc = dBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            if (!"JMathAnimConfig".equals(root.getNodeName())) {
                try {
                    throw new Exception("XML File doesn't contain a valid config file");
                }
                catch (Exception ex) {
                    Logger.getLogger(ConfigLoader.class.getName()).log(Level.SEVERE, null, ex);
                    System.exit(1);
                }
            }
            ConfigLoader.parseLoadConfigOptions(root.getElementsByTagName("include"));
            ConfigLoader.parseVideoOptions(config, root.getElementsByTagName("video"));
            ConfigLoader.parseBackgroundOptions(config, root.getElementsByTagName("background"));
            ConfigLoader.parseStyles(config, root.getElementsByTagName("styles"));
        }
        catch (IOException | NullPointerException | ParserConfigurationException | SAXException ex) {
            JMathAnimScene.logger.error("Error loading config file " + filename + ": " + ex.toString());
        }
    }

    private static void parseVideoOptions(JMathAnimConfig config, NodeList videos) {
        for (int k = 0; k < videos.getLength(); ++k) {
            NodeList videoChilds = videos.item(k).getChildNodes();
            block17: for (int n = 0; n < videoChilds.getLength(); ++n) {
                Node item = videoChilds.item(n);
                switch (item.getNodeName()) {
                    case "size": {
                        Element el = (Element)item;
                        config.mediaW = Integer.parseInt(el.getAttribute("width"));
                        config.mediaH = Integer.parseInt(el.getAttribute("height"));
                        config.fps = Integer.parseInt(el.getAttribute("fps"));
                        JMathAnimScene.logger.debug("Config read: Dimensions set to ({},{}), {} fps", new Object[]{config.mediaW, config.mediaH, config.fps});
                        continue block17;
                    }
                    case "createMovie": {
                        boolean createMovie = Boolean.parseBoolean(item.getTextContent());
                        config.setCreateMovie(createMovie);
                        JMathAnimScene.logger.debug("Config read: Create movie set to {}", (Object)createMovie);
                        continue block17;
                    }
                    case "saveToPNG": {
                        boolean saveToPNG = Boolean.parseBoolean(item.getTextContent());
                        config.setSaveToPNG(saveToPNG);
                        JMathAnimScene.logger.debug("Config read: Save to PNG flag set to {}", (Object)saveToPNG);
                        continue block17;
                    }
                    case "showPreviewWindow": {
                        boolean previewWindow = Boolean.parseBoolean(item.getTextContent());
                        config.setShowPreviewWindow(previewWindow);
                        JMathAnimScene.logger.debug("Config read: Show preview window set to {}", (Object)previewWindow);
                        continue block17;
                    }
                    case "outputDir": {
                        config.setOutputDir(item.getTextContent());
                        JMathAnimScene.logger.debug("Config read: Output dir set to {}", (Object)item.getTextContent());
                        continue block17;
                    }
                    case "outputFileName": {
                        config.setOutputFileName(item.getTextContent());
                        JMathAnimScene.logger.debug("Config read: Output filename set to {}", (Object)item.getTextContent());
                    }
                }
            }
        }
    }

    private static void parseBackgroundOptions(JMathAnimConfig config, NodeList backgrounds) throws IOException {
        if (backgrounds.getLength() == 0) {
            return;
        }
        Node background = backgrounds.item(backgrounds.getLength() - 1);
        NodeList bgChilds = background.getChildNodes();
        block10: for (int n = 0; n < bgChilds.getLength(); ++n) {
            Node item = bgChilds.item(n);
            switch (item.getNodeName()) {
                case "color": {
                    String colorId = item.getTextContent();
                    config.setBackgroundColor(JMColor.parse(colorId));
                    JMathAnimScene.logger.debug("Config read: Background color set to {}", (Object)colorId);
                    continue block10;
                }
                case "shadows": {
                    config.drawShadow = Boolean.parseBoolean(item.getTextContent());
                    Element el = (Element)item;
                    config.shadowKernelSize = Integer.parseInt(el.getAttribute("kernelSize"));
                    config.shadowOffsetX = Integer.parseInt(el.getAttribute("offsetX"));
                    config.shadowOffsetY = Integer.parseInt(el.getAttribute("offsetY"));
                    config.shadowAlpha = Float.parseFloat(el.getAttribute("alpha"));
                    JMathAnimScene.logger.debug("Config read: Draw shadows set to {}", (Object)config.drawShadow);
                    continue block10;
                }
                case "image": {
                    String backgroundFilename = item.getTextContent();
                    if ("".equals(backgroundFilename)) continue block10;
                    config.setBackGroundImage(resourceLoader.getResource(backgroundFilename, "images"));
                    JMathAnimScene.logger.debug("Config read: Background image set to {}", (Object)backgroundFilename);
                }
            }
        }
    }

    private static void parseStyles(JMathAnimConfig config, NodeList styles) {
        for (int k = 0; k < styles.getLength(); ++k) {
            Element elStyle = (Element)styles.item(k);
            NodeList templChilds = elStyle.getElementsByTagName("style");
            for (int n = 0; n < templChilds.getLength(); ++n) {
                Node item = templChilds.item(n);
                MODrawProperties mp = ConfigLoader.parseMathObjectDrawingProperties(item);
                if (item.getNodeType() != 1) continue;
                Element el = (Element)item;
                config.getStyles().put(el.getAttribute("name").toUpperCase(), mp);
            }
        }
    }

    private static MODrawProperties parseMathObjectDrawingProperties(Node template) {
        MODrawProperties mp = new MODrawProperties();
        NodeList childs = template.getChildNodes();
        block16: for (int n = 0; n < childs.getLength(); ++n) {
            String name;
            Node item = childs.item(n);
            switch (name = item.getNodeName()) {
                case "drawColor": {
                    mp.setDrawColor(JMColor.parse(item.getTextContent()));
                    continue block16;
                }
                case "fillColor": {
                    mp.setFillColor(JMColor.parse(item.getTextContent()));
                    continue block16;
                }
                case "thickness": {
                    mp.thickness = Double.parseDouble(item.getTextContent());
                    continue block16;
                }
                case "dashStyle": {
                    mp.dashStyle = MODrawProperties.parseDashStyle(item.getTextContent());
                    continue block16;
                }
                case "absoluteThickness": {
                    mp.absoluteThickness = Boolean.parseBoolean(item.getTextContent());
                    continue block16;
                }
                case "dotStyle": {
                    mp.dotStyle = MODrawProperties.parseDotStyle(item.getTextContent());
                }
            }
        }
        return mp;
    }

    private static void parseLoadConfigOptions(NodeList includeTags) {
        for (int n = 0; n < includeTags.getLength(); ++n) {
            Node item = includeTags.item(n);
            JMathAnimScene.logger.debug("Including file {}", (Object)item.getTextContent());
            ConfigLoader.parseFile(item.getTextContent());
        }
    }
}

