/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Styling;

import com.jmathanim.Styling.JMColor;
import java.util.HashMap;
import javafx.scene.paint.Stop;

public class GradientStop {
    private final HashMap<Double, JMColor> colors;

    public GradientStop() {
        this(new HashMap<Double, JMColor>());
    }

    public GradientStop(HashMap<Double, JMColor> colors) {
        this.colors = colors;
    }

    public <T extends GradientStop> T add(double t, JMColor col) {
        this.colors.put(t, col);
        return (T)this;
    }

    public <T extends GradientStop> T remove(double t) {
        this.colors.remove(t);
        return (T)this;
    }

    public Stop[] toFXStop(double alpha) {
        if (this.colors.isEmpty()) {
            this.add(0.0, JMColor.WHITE);
            this.add(1.0, JMColor.BLACK);
        }
        Stop[] resul = new Stop[this.colors.size()];
        int k = 0;
        for (Double t : this.colors.keySet()) {
            resul[k] = new Stop(t.doubleValue(), this.colors.get(t).getFXColor(alpha));
            ++k;
        }
        return resul;
    }

    protected void addInterpolatedColor(double t) {
        if (this.colors.containsKey(t)) {
            return;
        }
        double upper = 1.0;
        double lower = 0.0;
        for (double tt : this.colors.keySet()) {
            if (tt < t && lower < tt) {
                lower = tt;
            }
            if (!(t < tt) || !(tt < upper)) continue;
            upper = tt;
        }
        JMColor colA = this.colors.get(lower);
        JMColor colB = this.colors.get(upper);
        JMColor newColor = (JMColor)colA.interpolate(colB, (t - lower) / (upper - lower));
        this.colors.put(t, newColor);
    }

    public HashMap<Double, JMColor> getColorHashMap() {
        return this.colors;
    }

    public GradientStop copy() {
        GradientStop copy = new GradientStop();
        for (double t : this.colors.keySet()) {
            copy.add(t, this.colors.get(t).copy());
        }
        return copy;
    }
}

