/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Styling;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.FXRenderer.JavaFXRenderer;
import com.jmathanim.Styling.JMLinearGradient;
import com.jmathanim.Styling.JMRadialGradient;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.jmathanim.JMathAnimScene;
import java.lang.reflect.Field;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JMColor
extends PaintStyle {
    public static JMColor NONE = new JMColor(0.0, 0.0, 0.0, 0.0);
    public static JMColor WHITE = new JMColor(1.0, 1.0, 1.0, 1.0);
    public static JMColor BLACK = new JMColor(0.0, 0.0, 0.0, 1.0);
    public static JMColor RED = new JMColor(1.0, 0.0, 0.0, 1.0);
    public static JMColor GREEN = new JMColor(0.0, 1.0, 0.0, 1.0);
    public static JMColor BLUE = new JMColor(0.0, 0.0, 1.0, 1.0);
    public static JMColor GRAY = new JMColor(0.5, 0.5, 0.5, 1.0);
    public double r;
    public double g;
    public double b;
    private double alpha;

    public JMColor(double r, double g, double b, double alpha) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
    }

    public static JMColor rgbInt(int r, int g, int b, int alpha) {
        return new JMColor((float)r * 1.0f / 255.0f, (float)g * 1.0f / 255.0f, (float)b * 1.0f / 255.0f, (float)alpha * 1.0f / 255.0f);
    }

    public java.awt.Color getAwtColor() {
        return new java.awt.Color((float)this.r, (float)this.g, (float)this.b, (float)this.alpha);
    }

    public Color getFXColor() {
        return new Color((double)((float)this.r), (double)((float)this.g), (double)((float)this.b), (double)((float)this.alpha));
    }

    public Color getFXColor(double alpha) {
        return new Color((double)((float)this.r), (double)((float)this.g), (double)((float)this.b), (double)((float)alpha));
    }

    public JMColor getInverse() {
        return new JMColor(1.0 - this.r, 1.0 - this.g, 1.0 - this.b, this.alpha);
    }

    @Override
    public JMColor copy() {
        return new JMColor(this.r, this.g, this.b, this.alpha);
    }

    public final void copyFrom(JMColor jmcolor) {
        if (jmcolor != null) {
            this.r = jmcolor.r;
            this.g = jmcolor.g;
            this.b = jmcolor.b;
            this.alpha = jmcolor.alpha;
        }
    }

    @Override
    public PaintStyle interpolate(PaintStyle p, double t) {
        if (p instanceof JMColor) {
            JMColor B = (JMColor)p;
            double rr = (1.0 - t) * this.r + t * B.r;
            double gg = (1.0 - t) * this.g + t * B.g;
            double bb = (1.0 - t) * this.b + t * B.b;
            double aa = (1.0 - t) * this.alpha + t * B.alpha;
            return new JMColor(rr, gg, bb, aa);
        }
        if (p instanceof JMLinearGradient) {
            return ((JMLinearGradient)p).interpolate(this, 1.0 - t);
        }
        if (p instanceof JMRadialGradient) {
            return ((JMRadialGradient)p).interpolate(this, 1.0 - t);
        }
        return this.copy();
    }

    public static JMColor random() {
        return new JMColor(Math.random(), Math.random(), Math.random(), 1.0);
    }

    public static JMColor parse(String str) {
        Color col = Color.WHITE;
        if ("NONE".equals(str = str.toUpperCase().trim())) {
            return new JMColor(0.0, 0.0, 0.0, 0.0);
        }
        if ("RANDOM".equals(str)) {
            return JMColor.random();
        }
        if (str.startsWith("#")) {
            col = Color.valueOf((String)str);
        } else {
            try {
                Field field = Color.class.getField(str.toUpperCase());
                col = (Color)field.get(JMColor.class);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                JMathAnimScene.logger.warn("Color {} not recognized ", (Object)str);
            }
        }
        return JMColor.fromFXColor(col);
    }

    public static JMColor fromFXColor(Color col) {
        JMColor resul = new JMColor(1.0, 1.0, 1.0, 1.0);
        resul.r = col.getRed();
        resul.g = col.getGreen();
        resul.b = col.getBlue();
        resul.alpha = col.getOpacity();
        return resul;
    }

    public String toString() {
        return "JMcolor(" + this.r + ", " + this.g + "," + this.b + ", " + this.alpha + ')';
    }

    @Override
    public Paint getFXPaint(JavaFXRenderer r, Camera cam) {
        return this.getFXColor();
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

