/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Styling;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.FXRenderer.JavaFXRenderer;
import com.jmathanim.Styling.GradientStop;
import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.mathobjects.Point;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;

public class JMLinearGradient
extends PaintStyle {
    protected Point start;
    protected Point end;
    protected GradientStop stops;
    protected boolean relativeToShape;
    protected CycleMethod cycleMethod;

    public JMLinearGradient(Point start, Point end) {
        this.start = start;
        this.end = end;
        this.stops = new GradientStop();
        this.relativeToShape = false;
        this.cycleMethod = CycleMethod.NO_CYCLE;
    }

    @Override
    public JMLinearGradient copy() {
        JMLinearGradient resul = new JMLinearGradient(this.start.copy(), this.end.copy());
        resul.relativeToShape = this.relativeToShape;
        resul.stops = this.stops.copy();
        resul.cycleMethod = this.cycleMethod;
        resul.setAlpha(this.getAlpha());
        return resul;
    }

    @Override
    public Paint getFXPaint(JavaFXRenderer r, Camera cam) {
        double[] ee;
        double[] ss;
        if (!this.relativeToShape) {
            ss = cam.mathToScreenFX(this.start.v);
            ee = cam.mathToScreenFX(this.end.v);
        } else {
            ss = new double[]{this.start.v.x, 1.0 - this.start.v.y};
            ee = new double[]{this.end.v.x, 1.0 - this.end.v.y};
        }
        return new LinearGradient(ss[0], ss[1], ee[0], ee[1], this.relativeToShape, this.cycleMethod, this.stops.toFXStop(this.getAlpha()));
    }

    @Override
    public PaintStyle interpolate(PaintStyle p, double t) {
        if (p instanceof JMColor) {
            JMColor pc = (JMColor)p;
            JMLinearGradient resul = this.copy();
            GradientStop interStops = resul.getStops();
            for (double tt : interStops.getColorHashMap().keySet()) {
                JMColor col = interStops.getColorHashMap().get(tt);
                interStops.add(tt, (JMColor)col.interpolate(pc, t));
            }
            resul.setAlpha((1.0 - t) * resul.getAlpha() + t * pc.getAlpha());
            return resul;
        }
        if (p instanceof JMLinearGradient) {
            JMLinearGradient lp = (JMLinearGradient)p;
            if (lp.cycleMethod == this.cycleMethod && lp.relativeToShape == this.relativeToShape) {
                JMLinearGradient resul = this.copy();
                for (double tt : lp.stops.getColorHashMap().keySet()) {
                    resul.stops.addInterpolatedColor(tt);
                }
                for (double tt : resul.stops.getColorHashMap().keySet()) {
                    lp.stops.addInterpolatedColor(tt);
                }
                for (double tt : resul.stops.getColorHashMap().keySet()) {
                    JMColor colA = resul.stops.getColorHashMap().get(tt);
                    JMColor colB = lp.stops.getColorHashMap().get(tt);
                    resul.stops.add(tt, (JMColor)colA.interpolate(colB, t));
                }
                resul.start = resul.start.interpolate(lp.start, t);
                resul.end = resul.end.interpolate(lp.end, t);
                resul.setAlpha((1.0 - t) * resul.getAlpha() + t * lp.getAlpha());
                return resul;
            }
        }
        return this.copy();
    }

    public boolean isRelativeToShape() {
        return this.relativeToShape;
    }

    public <T extends JMLinearGradient> T setRelativeToShape(boolean relativeToShape) {
        this.relativeToShape = relativeToShape;
        return (T)this;
    }

    public GradientStop getStops() {
        return this.stops;
    }

    public <T extends JMLinearGradient> T add(double t, String strCol) {
        this.stops.add(t, JMColor.parse(strCol));
        return (T)this;
    }

    public <T extends JMLinearGradient> T add(double t, JMColor col) {
        this.stops.add(t, col);
        return (T)this;
    }

    public <T extends JMLinearGradient> T remove(double t) {
        this.stops.remove(t);
        return (T)this;
    }

    public CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public <T extends JMLinearGradient> T setCycleMethod(CycleMethod cycleMethod) {
        this.cycleMethod = cycleMethod;
        return (T)this;
    }
}

