/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Styling;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.FXRenderer.JavaFXRenderer;
import com.jmathanim.Styling.GradientStop;
import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.mathobjects.Point;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;

public class JMRadialGradient
extends PaintStyle {
    protected Point center;
    protected double focusAngle;
    protected double focusDistance;
    protected double radius;
    protected GradientStop stops;
    protected boolean relativeToShape;
    protected CycleMethod cycleMethod;

    public JMRadialGradient(Point center, double radius) {
        this(center, 0.0, 0.0, radius);
    }

    public JMRadialGradient(Point center, double focusAngle, double focusDistance, double radius) {
        this.center = center;
        this.focusAngle = focusAngle;
        this.focusDistance = focusDistance;
        this.radius = radius;
        this.stops = new GradientStop();
        this.relativeToShape = false;
        this.cycleMethod = CycleMethod.NO_CYCLE;
    }

    @Override
    public JMRadialGradient copy() {
        JMRadialGradient resul = new JMRadialGradient(this.center.copy(), this.focusAngle, this.focusDistance, this.radius);
        resul.relativeToShape = this.relativeToShape;
        resul.stops = this.stops.copy();
        resul.cycleMethod = this.cycleMethod;
        resul.setAlpha(this.getAlpha());
        return resul;
    }

    @Override
    public Paint getFXPaint(JavaFXRenderer r, Camera cam) {
        double realRadius;
        double[] cc;
        if (!this.relativeToShape) {
            cc = cam.mathToScreenFX(this.center.v);
            realRadius = cam.mathToScreen(this.radius);
        } else {
            cc = new double[]{this.center.v.x, 1.0 - this.center.v.y};
            realRadius = this.radius;
        }
        return new RadialGradient(this.focusAngle, this.focusDistance, cc[0], cc[1], realRadius, this.relativeToShape, this.cycleMethod, this.stops.toFXStop(this.getAlpha()));
    }

    @Override
    public PaintStyle interpolate(PaintStyle p, double t) {
        if (p instanceof JMColor) {
            JMColor pc = (JMColor)p;
            JMRadialGradient resul = this.copy();
            GradientStop interStops = resul.getStops();
            for (double tt : interStops.getColorHashMap().keySet()) {
                JMColor col = interStops.getColorHashMap().get(tt);
                interStops.add(tt, (JMColor)col.interpolate(pc, t));
            }
            resul.setAlpha((1.0 - t) * resul.getAlpha() + t * pc.getAlpha());
            return resul;
        }
        if (p instanceof JMRadialGradient) {
            JMRadialGradient rp = (JMRadialGradient)p;
            if (rp.cycleMethod == this.cycleMethod && rp.relativeToShape == this.relativeToShape) {
                JMRadialGradient resul = this.copy();
                for (double tt : rp.stops.getColorHashMap().keySet()) {
                    resul.stops.addInterpolatedColor(tt);
                }
                for (double tt : resul.stops.getColorHashMap().keySet()) {
                    rp.stops.addInterpolatedColor(tt);
                }
                for (double tt : resul.stops.getColorHashMap().keySet()) {
                    JMColor colA = resul.stops.getColorHashMap().get(tt);
                    JMColor colB = rp.stops.getColorHashMap().get(tt);
                    resul.stops.add(tt, (JMColor)colA.interpolate(colB, t));
                }
                resul.center = resul.center.interpolate(rp.center, t);
                resul.focusAngle = (1.0 - t) * resul.focusAngle + t * rp.focusAngle;
                resul.focusDistance = (1.0 - t) * resul.focusDistance + t * rp.focusDistance;
                resul.radius = (1.0 - t) * resul.radius + t * rp.radius;
                resul.setAlpha((1.0 - t) * resul.getAlpha() + t * rp.getAlpha());
                return resul;
            }
        }
        return this.copy();
    }

    public boolean isRelativeToShape() {
        return this.relativeToShape;
    }

    public JMRadialGradient setRelativeToShape(boolean relativeToShape) {
        this.relativeToShape = relativeToShape;
        return this;
    }

    public GradientStop getStops() {
        return this.stops;
    }

    public JMRadialGradient add(double t, String strCol) {
        this.stops.add(t, JMColor.parse(strCol));
        return this;
    }

    public JMRadialGradient add(double t, JMColor col) {
        this.stops.add(t, col);
        return this;
    }

    public JMRadialGradient remove(double t) {
        this.stops.remove(t);
        return this;
    }

    public CycleMethod getCycleMethod() {
        return this.cycleMethod;
    }

    public JMRadialGradient setCycleMethod(CycleMethod cycleMethod) {
        this.cycleMethod = cycleMethod;
        return this;
    }
}

