/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Styling;

import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Stateable;
import java.awt.Color;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import javafx.scene.shape.StrokeLineCap;

public class MODrawProperties
implements Stylable,
Stateable {
    public Boolean faceToCamera = false;
    public Vec faceToCameraPivot = Vec.to(0.0, 0.0);
    public Boolean absoluteThickness = true;
    public Boolean visible = true;
    public DashStyle dashStyle = DashStyle.SOLID;
    public Point.DotSyle dotStyle = Point.DotSyle.CIRCLE;
    private PaintStyle drawColor;
    private PaintStyle fillColor;
    private Integer layer = null;
    public StrokeLineCap linecap = StrokeLineCap.ROUND;
    private MODrawProperties mpBackup;
    public Double thickness = 1.0;

    public static MODrawProperties createFromStyle(String name) {
        MODrawProperties resul = MODrawProperties.makeNullValues();
        resul.loadFromStyle(name);
        return resul;
    }

    public static MODrawProperties makeNullValues() {
        MODrawProperties nullMP = new MODrawProperties();
        nullMP.drawColor = null;
        nullMP.fillColor = null;
        nullMP.thickness = null;
        nullMP.absoluteThickness = null;
        nullMP.dashStyle = null;
        nullMP.absoluteThickness = null;
        nullMP.layer = null;
        nullMP.absoluteThickness = null;
        nullMP.dotStyle = null;
        nullMP.linecap = null;
        nullMP.faceToCamera = null;
        return nullMP;
    }

    static DashStyle parseDashStyle(String str) {
        DashStyle resul = DashStyle.SOLID;
        try {
            resul = DashStyle.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            JMathAnimScene.logger.error("Dash pattern {} not recognized, using default {}", (Object)str, (Object)resul);
        }
        return resul;
    }

    static Point.DotSyle parseDotStyle(String str) {
        Point.DotSyle resul = Point.DotSyle.CIRCLE;
        try {
            resul = Point.DotSyle.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            JMathAnimScene.logger.error("Dot style {} not recognized, using default {}", (Object)str, (Object)resul);
        }
        return resul;
    }

    public static Color randomColor() {
        int r = ThreadLocalRandom.current().nextInt(0, 256);
        int g = ThreadLocalRandom.current().nextInt(0, 256);
        int b = ThreadLocalRandom.current().nextInt(0, 256);
        return new Color(r, g, b);
    }

    public MODrawProperties() {
        this.drawColor = new JMColor(1.0, 1.0, 1.0, 1.0);
        this.fillColor = new JMColor(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public MODrawProperties copy() {
        MODrawProperties resul = new MODrawProperties();
        resul.copyFrom(this);
        return resul;
    }

    @Override
    public void copyFrom(Stylable prop) {
        if (prop == null) {
            return;
        }
        if (prop.getDrawColor() != null) {
            this.drawColor = prop.getDrawColor().copy();
        }
        if (prop.getFillColor() != null) {
            this.fillColor = prop.getFillColor().copy();
        }
        this.thickness = prop.getThickness() == null ? this.thickness : prop.getThickness();
        this.dashStyle = prop.getDashStyle() == null ? this.dashStyle : prop.getDashStyle();
        this.absoluteThickness = prop.isAbsoluteThickness() == null ? this.absoluteThickness : prop.isAbsoluteThickness();
        this.dotStyle = prop.getDotStyle() == null ? this.dotStyle : prop.getDotStyle();
        this.layer = prop.getLayer() == null ? this.layer : prop.getLayer();
        this.linecap = prop.getLinecap() == null ? this.linecap : prop.getLinecap();
        this.visible = prop.isVisible() == null ? this.visible : prop.isVisible();
        this.faceToCamera = prop.isFaceToCamera() == null ? this.faceToCamera : prop.isFaceToCamera();
        this.faceToCameraPivot = prop.getFaceToCameraPivot() == null ? this.faceToCameraPivot : prop.getFaceToCameraPivot();
    }

    @Override
    public void setAbsoluteThickness(Boolean absThickness) {
        this.absoluteThickness = absThickness;
    }

    @Override
    public DashStyle getDashStyle() {
        return this.dashStyle;
    }

    @Override
    public void setDashStyle(DashStyle dashStyle) {
        this.dashStyle = dashStyle;
    }

    @Override
    public Point.DotSyle getDotStyle() {
        return this.dotStyle;
    }

    @Override
    public void setDotStyle(Point.DotSyle dotStyle) {
        this.dotStyle = dotStyle;
    }

    @Override
    public void setDrawAlpha(double alpha) {
        this.drawColor.setAlpha(alpha);
    }

    @Override
    public PaintStyle getDrawColor() {
        return this.drawColor;
    }

    @Override
    public void setDrawColor(PaintStyle drawColor) {
        if (drawColor != null) {
            this.drawColor = drawColor.copy();
        }
    }

    @Override
    public void setFillAlpha(double alpha) {
        this.fillColor.setAlpha(alpha);
    }

    @Override
    public PaintStyle getFillColor() {
        return this.fillColor;
    }

    @Override
    public void setFillColor(PaintStyle fillColor) {
        if (fillColor != null) {
            this.fillColor = fillColor.copy();
        }
    }

    @Override
    public MODrawProperties getFirstMP() {
        return this;
    }

    @Override
    public Integer getLayer() {
        if (this.layer == null) {
            this.layer = 0;
        }
        return this.layer;
    }

    @Override
    public void setLayer(int layer) {
        this.layer = layer;
    }

    @Override
    public StrokeLineCap getLinecap() {
        return this.linecap;
    }

    @Override
    public void setLinecap(StrokeLineCap linecap) {
        this.linecap = linecap;
    }

    @Override
    public void setMultDrawAlpha(double alphaScale) {
        double newAlpha = this.getDrawColor().getAlpha() * alphaScale;
        newAlpha = newAlpha > 1.0 ? 1.0 : newAlpha;
        newAlpha = newAlpha < 0.0 ? 0.0 : newAlpha;
        this.setDrawAlpha(newAlpha);
    }

    @Override
    public void setMultFillAlpha(double alphaScale) {
        double newAlpha = this.getFillColor().getAlpha() * alphaScale;
        newAlpha = newAlpha > 1.0 ? 1.0 : newAlpha;
        newAlpha = newAlpha < 0.0 ? 0.0 : newAlpha;
        this.setFillAlpha(newAlpha);
    }

    @Override
    public Stylable getSubMP(int n) {
        return this;
    }

    @Override
    public Double getThickness() {
        return this.thickness;
    }

    @Override
    public void setThickness(Double thickness) {
        this.thickness = thickness;
    }

    @Override
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    public void interpolateFrom(Stylable a, Stylable b, double alpha) {
        if (alpha == 1.0) {
            this.copyFrom(b);
            return;
        }
        if (b.getDrawColor() != null) {
            this.drawColor = a.getDrawColor().interpolate(b.getDrawColor(), alpha);
        }
        if (b.getFillColor() != null) {
            this.fillColor = a.getFillColor().interpolate(b.getFillColor(), alpha);
        }
        if (b.getThickness() != null) {
            this.thickness = (1.0 - alpha) * a.getThickness() + alpha * b.getThickness();
        }
    }

    @Override
    public void interpolateFrom(Stylable dst, double alpha) {
        this.interpolateFrom(this, dst, alpha);
    }

    @Override
    public Boolean isAbsoluteThickness() {
        return this.absoluteThickness;
    }

    public boolean isFilled() {
        return this.fillColor.getAlpha() > 0.0;
    }

    @Override
    public void setFilled(boolean fill) {
        if (fill && this.fillColor.getAlpha() == 0.0) {
            this.setFillAlpha(1.0);
        }
        if (!fill) {
            this.setFillAlpha(0.0);
        }
    }

    @Override
    public Boolean isVisible() {
        return this.visible;
    }

    @Override
    public void loadFromStyle(String name) {
        name = name.toUpperCase();
        HashMap<String, MODrawProperties> styles = JMathAnimConfig.getConfig().getStyles();
        if (styles.containsKey(name)) {
            this.copyFrom(styles.get(name));
        } else {
            JMathAnimScene.logger.warn("No style with name {} found", (Object)name);
        }
    }

    @Override
    public void multThickness(double multT) {
        this.setThickness(this.getThickness() * multT);
    }

    @Override
    public void rawCopyFrom(MODrawProperties mp) {
        this.drawColor = mp.drawColor.copy();
        this.fillColor = mp.fillColor.copy();
        this.thickness = mp.thickness;
        this.dashStyle = mp.dashStyle;
        this.absoluteThickness = mp.absoluteThickness;
        this.dashStyle = mp.dashStyle;
        this.layer = mp.layer;
        this.dotStyle = mp.dotStyle;
        this.linecap = mp.linecap;
        this.visible = mp.visible;
        this.faceToCamera = mp.faceToCamera;
        this.faceToCameraPivot = mp.faceToCameraPivot;
    }

    @Override
    public void restoreState() {
        this.copyFrom(this.mpBackup);
    }

    @Override
    public void saveState() {
        this.mpBackup = this.copy();
    }

    @Override
    public Boolean isFaceToCamera() {
        return this.faceToCamera;
    }

    @Override
    public void setFaceToCamera(Boolean faceToCamera) {
        this.faceToCamera = faceToCamera;
    }

    @Override
    public Vec getFaceToCameraPivot() {
        return this.faceToCameraPivot;
    }

    @Override
    public void setFaceToCameraPivot(Vec pivot) {
        this.faceToCameraPivot = pivot;
    }

    public static enum DashStyle {
        SOLID,
        DASHED,
        DOTTED,
        DASHDOTTED;

    }
}

