/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Styling;

import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Vec;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Stateable;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.shape.StrokeLineCap;

public class MODrawPropertiesArray
implements Stylable,
Stateable {
    private ArrayList<MathObject> objects;
    private final MODrawProperties mpRef;

    public MODrawPropertiesArray(MODrawProperties mp) {
        this.mpRef = new MODrawProperties();
        this.mpRef.copyFrom(mp);
        this.objects = new ArrayList();
    }

    public MODrawPropertiesArray() {
        this.mpRef = new MODrawProperties();
        this.mpRef.copyFrom(JMathAnimConfig.getConfig().getDefaultMP());
        this.objects = new ArrayList();
    }

    public MODrawPropertiesArray(ArrayList<MathObject> objects) {
        this.objects = objects;
        this.mpRef = new MODrawProperties();
    }

    public ArrayList<MathObject> getObjects() {
        return this.objects;
    }

    public void add(MathObject ... objs) {
        this.objects.addAll(Arrays.asList(objs));
    }

    public void setObjects(ArrayList<MathObject> objects) {
        this.objects = objects;
    }

    @Override
    public void setVisible(Boolean visible) {
        for (MathObject obj : this.objects) {
            obj.getMp().setVisible(visible);
        }
        this.mpRef.setVisible(visible);
    }

    @Override
    public Boolean isVisible() {
        return this.mpRef.isVisible();
    }

    public boolean remove(MathObject o) {
        return this.objects.remove(o);
    }

    @Override
    public MODrawProperties copy() {
        return this.mpRef.copy();
    }

    @Override
    public void copyFrom(Stylable prop) {
        for (MathObject obj : this.objects) {
            obj.getMp().copyFrom(prop);
        }
        this.mpRef.copyFrom(prop);
    }

    @Override
    public void interpolateFrom(Stylable dst, double alpha) {
        for (MathObject obj : this.objects) {
            obj.getMp().interpolateFrom(dst, alpha);
        }
        this.mpRef.interpolateFrom(dst, alpha);
    }

    @Override
    public void interpolateFrom(Stylable a, Stylable b, double alpha) {
        for (MathObject obj : this.objects) {
            obj.getMp().interpolateFrom(a, b, alpha);
        }
        this.mpRef.interpolateFrom(a, b, alpha);
    }

    @Override
    public void loadFromStyle(String name) {
        for (MathObject obj : this.objects) {
            obj.getMp().loadFromStyle(name);
        }
        this.mpRef.loadFromStyle(name);
    }

    @Override
    public void rawCopyFrom(MODrawProperties mp) {
        for (MathObject obj : this.objects) {
            obj.getMp().rawCopyFrom(mp);
        }
        this.mpRef.rawCopyFrom(mp);
    }

    @Override
    public void restoreState() {
        for (MathObject obj : this.objects) {
            obj.getMp().restoreState();
        }
        this.mpRef.restoreState();
    }

    @Override
    public void saveState() {
        for (MathObject obj : this.objects) {
            obj.getMp().saveState();
        }
        this.mpRef.saveState();
    }

    @Override
    public void setDrawAlpha(double alpha) {
        for (MathObject obj : this.objects) {
            obj.getMp().setDrawAlpha(alpha);
        }
        this.mpRef.setDrawAlpha(alpha);
    }

    @Override
    public void setDrawColor(PaintStyle drawColor) {
        for (MathObject obj : this.objects) {
            obj.getMp().setDrawColor(drawColor);
        }
        this.mpRef.setDrawColor(drawColor);
    }

    @Override
    public void setFillAlpha(double alpha) {
        for (MathObject obj : this.objects) {
            obj.getMp().setFillAlpha(alpha);
        }
        this.mpRef.setFillAlpha(alpha);
    }

    @Override
    public void setFillColor(PaintStyle fillColor) {
        for (MathObject obj : this.objects) {
            obj.getMp().setFillColor(fillColor);
        }
        this.mpRef.setFillColor(fillColor);
    }

    @Override
    public void setFilled(boolean fill) {
        for (MathObject obj : this.objects) {
            obj.getMp().setFilled(fill);
        }
        this.mpRef.setFilled(fill);
    }

    @Override
    public void setLayer(int layer) {
        for (MathObject obj : this.objects) {
            obj.getMp().setLayer(layer);
        }
        this.mpRef.setLayer(layer);
    }

    @Override
    public Integer getLayer() {
        return this.mpRef.getLayer();
    }

    @Override
    public void setMultFillAlpha(double alpha) {
        for (MathObject obj : this.objects) {
            obj.getMp().setMultFillAlpha(alpha);
        }
        this.mpRef.setMultFillAlpha(alpha);
    }

    @Override
    public void setMultDrawAlpha(double alpha) {
        for (MathObject obj : this.objects) {
            obj.getMp().setMultDrawAlpha(alpha);
        }
        this.mpRef.setMultDrawAlpha(alpha);
    }

    @Override
    public PaintStyle getDrawColor() {
        return this.mpRef.getDrawColor();
    }

    @Override
    public PaintStyle getFillColor() {
        return this.mpRef.getFillColor();
    }

    @Override
    public Stylable getSubMP(int n) {
        return this.objects.get(n).getMp();
    }

    @Override
    public MODrawProperties getFirstMP() {
        return this.mpRef;
    }

    @Override
    public StrokeLineCap getLinecap() {
        return this.mpRef.getLinecap();
    }

    @Override
    public void setLinecap(StrokeLineCap linecap) {
        for (MathObject obj : this.objects) {
            obj.getMp().setLinecap(linecap);
        }
        this.mpRef.setLinecap(linecap);
    }

    @Override
    public Double getThickness() {
        return this.mpRef.getThickness();
    }

    @Override
    public void setThickness(Double thickness) {
        for (MathObject obj : this.objects) {
            obj.getMp().setThickness(thickness);
        }
        this.mpRef.setThickness(thickness);
    }

    @Override
    public void setDotStyle(Point.DotSyle dotStyle) {
        for (MathObject obj : this.objects) {
            obj.getMp().setDotStyle(dotStyle);
        }
        this.mpRef.setDotStyle(dotStyle);
    }

    @Override
    public Point.DotSyle getDotStyle() {
        return this.mpRef.getDotStyle();
    }

    @Override
    public void setDashStyle(MODrawProperties.DashStyle dashStyle) {
        for (MathObject obj : this.objects) {
            obj.getMp().setDashStyle(dashStyle);
        }
        this.mpRef.setDashStyle(dashStyle);
    }

    @Override
    public MODrawProperties.DashStyle getDashStyle() {
        return this.mpRef.getDashStyle();
    }

    @Override
    public Boolean isAbsoluteThickness() {
        return this.mpRef.isAbsoluteThickness();
    }

    @Override
    public void setAbsoluteThickness(Boolean absThickness) {
        for (MathObject obj : this.objects) {
            obj.getMp().setAbsoluteThickness(absThickness);
        }
        this.mpRef.setAbsoluteThickness(absThickness);
    }

    @Override
    public void multThickness(double multT) {
        for (MathObject obj : this.objects) {
            obj.getMp().multThickness(multT);
        }
        this.mpRef.multThickness(multT);
    }

    @Override
    public Boolean isFaceToCamera() {
        return this.mpRef.isFaceToCamera();
    }

    @Override
    public void setFaceToCamera(Boolean faceToCamera) {
        for (MathObject obj : this.objects) {
            obj.getMp().setFaceToCamera(faceToCamera);
        }
        this.mpRef.setFaceToCamera(faceToCamera);
    }

    @Override
    public Vec getFaceToCameraPivot() {
        return this.mpRef.getFaceToCameraPivot();
    }

    @Override
    public void setFaceToCameraPivot(Vec pivot) {
        for (MathObject obj : this.objects) {
            obj.getMp().setFaceToCameraPivot(pivot);
        }
        this.mpRef.setFaceToCameraPivot(pivot);
    }
}

