/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Stateable;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class AffineJTransform
implements Stateable {
    public RealMatrix matrix;
    public RealMatrix matrixBackup;

    public AffineJTransform() {
        this(MatrixUtils.createRealIdentityMatrix((int)4));
    }

    public AffineJTransform(RealMatrix rm) {
        this.matrix = rm;
    }

    public RealMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(RealMatrix matrix) {
        this.matrix = matrix;
    }

    public AffineJTransform copy() {
        RealMatrix copyMatrix = this.matrix.copy();
        return new AffineJTransform(copyMatrix);
    }

    public void setOriginImg(Vec v) {
        this.setOriginImg(v.x, v.y, v.z);
    }

    public void setOriginImg(Point p) {
        this.setOriginImg(p.v);
    }

    public void setOriginImg(double x, double y) {
        this.setOriginImg(x, y, 0.0);
    }

    public void setOriginImg(double x, double y, double z) {
        this.matrix.setRow(0, new double[]{1.0, x, y, z});
    }

    public void setV1Img(Vec v) {
        this.setV1Img(v.x, v.y, v.z);
    }

    public void setV1Img(Point p) {
        this.setV1Img(p.v);
    }

    public void setV1Img(double x, double y, double z) {
        this.matrix.setRow(1, new double[]{0.0, x, y, z});
    }

    public void setV1Img(double x, double y) {
        this.setV1Img(x, y, 0.0);
    }

    public void setV2Img(Vec v) {
        this.setV2Img(v.x, v.y, v.z);
    }

    public void setV2Img(Point p) {
        this.setV2Img(p.v);
    }

    public void setV2Img(double x, double y, double z) {
        this.matrix.setRow(2, new double[]{0.0, x, y, z});
    }

    public void setV2Img(double x, double y) {
        this.setV2Img(x, y, 0.0);
    }

    public void setV3Img(Vec v) {
        this.setV3Img(v.x, v.y, v.z);
    }

    public void setV3Img(Point p) {
        this.setV3Img(p.v);
    }

    public void setV3Img(double x, double y, double z) {
        this.matrix.setRow(3, new double[]{0.0, x, y, z});
    }

    public void setV3Img(double x, double y) {
        this.setV3Img(x, y, 0.0);
    }

    public void applyTransform(MathObject mObject) {
        mObject.applyAffineTransform(this);
    }

    public void applyTransformsToDrawingProperties(MathObject mObject) {
        double det = this.matrix.getEntry(1, 1) * this.matrix.getEntry(2, 2) - this.matrix.getEntry(2, 1) * this.matrix.getEntry(1, 2);
        if (!mObject.getMp().isAbsoluteThickness().booleanValue()) {
            double sqrtDet = Math.sqrt(Math.abs(det));
            mObject.getMp().multThickness(Math.sqrt(sqrtDet));
        }
    }

    public <T extends MathObject> T getTransformedObject(MathObject obj) {
        Object resul = obj.copy();
        this.applyTransform((MathObject)resul);
        return resul;
    }

    public AffineJTransform compose(AffineJTransform tr) {
        return new AffineJTransform(this.matrix.multiply(tr.matrix));
    }

    public AffineJTransform getInverse() {
        RealMatrix B = new LUDecomposition(this.matrix).getSolver().getInverse();
        return new AffineJTransform(B);
    }

    public static AffineJTransform createTranslationTransform(Point a, Point b) {
        return AffineJTransform.createTranslationTransform(new Vec(b.v.x - a.v.x, b.v.y - a.v.y, b.v.z - a.v.z));
    }

    public static AffineJTransform createTranslationTransform(Vec v) {
        AffineJTransform resul = new AffineJTransform();
        resul.setOriginImg(v);
        return resul;
    }

    public static AffineJTransform create2DRotationTransform(Point center, double angle) {
        AffineJTransform resul = new AffineJTransform();
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        resul.setV1Img(cos, sin);
        resul.setV2Img(-sin, cos);
        AffineJTransform tr1 = AffineJTransform.createTranslationTransform(center.v.mult(-1.0));
        AffineJTransform tr2 = AffineJTransform.createTranslationTransform(center.v);
        return tr1.compose(resul.compose(tr2));
    }

    public static AffineJTransform create3DRotationTransform(Point center, double anglex, double angley, double anglez) {
        AffineJTransform resul = new AffineJTransform();
        double sinz = Math.sin(anglez);
        double cosz = Math.cos(anglez);
        double siny = Math.sin(angley);
        double cosy = Math.cos(angley);
        double sinx = Math.sin(anglex);
        double cosx = Math.cos(anglex);
        resul.setV1Img(cosz * cosy, cosz * siny * sinx - sinz * cosx, cosz * siny * cosx + sinz * sinx);
        resul.setV2Img(sinz * cosy, sinz * siny * sinx + cosz * cosx, sinz * siny * cosx - cosz * sinx);
        resul.setV3Img(-siny, cosy * sinx, cosy * cosx);
        AffineJTransform tr1 = AffineJTransform.createTranslationTransform(center.v.mult(-1.0));
        AffineJTransform tr2 = AffineJTransform.createTranslationTransform(center.v);
        return tr1.compose(resul.compose(tr2));
    }

    public static AffineJTransform createScaleTransform(Point center, double scale) {
        return AffineJTransform.createScaleTransform(center, scale, scale, scale);
    }

    public static AffineJTransform createScaleTransform(Point center, double scalex, double scaley) {
        return AffineJTransform.createScaleTransform(center, scalex, scaley, 1.0);
    }

    public static AffineJTransform createScaleTransform(Point center, double scalex, double scaley, double scalez) {
        AffineJTransform resul = new AffineJTransform();
        resul.setV1Img(scalex, 0.0, 0.0);
        resul.setV2Img(0.0, scaley, 0.0);
        resul.setV3Img(0.0, 0.0, scalez);
        AffineJTransform tr1 = AffineJTransform.createTranslationTransform(center.v.mult(-1.0));
        AffineJTransform tr2 = AffineJTransform.createTranslationTransform(center.v);
        return tr1.compose(resul.compose(tr2));
    }

    public static AffineJTransform createDirect2DHomothecy(Point A, Point B, Point C, Point D, double alpha) {
        Vec v1 = A.to(B);
        Vec v2 = C.to(D);
        Vec v3 = A.to(C);
        double d1 = v1.norm();
        double d2 = v2.norm();
        double dotProd = v1.dot(v2) / d1 / d2;
        dotProd = dotProd > 1.0 ? 1.0 : dotProd;
        dotProd = dotProd < -1.0 ? -1.0 : dotProd;
        double angle = Math.acos(dotProd);
        if (v1.x * v2.y - v1.y * v2.x < 0.0) {
            angle = -angle;
        }
        AffineJTransform rotation = AffineJTransform.create2DRotationTransform(A, angle * alpha);
        AffineJTransform scale = AffineJTransform.createScaleTransform(A, 1.0 - alpha + d2 / d1 * alpha);
        AffineJTransform traslation = AffineJTransform.createTranslationTransform(v3.mult(alpha));
        return rotation.compose(scale).compose(traslation);
    }

    public static AffineJTransform createReflection(Point A, Point B, double alpha) {
        Point E1 = new Point(1.0, 0.0);
        Point E2 = new Point(-1.0, 0.0);
        AffineJTransform canonize = AffineJTransform.createDirect2DHomothecy(A, B, E1, E2, 1.0);
        AffineJTransform invCanonize = canonize.getInverse();
        AffineJTransform canonizedReflection = new AffineJTransform();
        canonizedReflection.setV1Img(E1.interpolate(E2, alpha));
        AffineJTransform resul = canonize.compose(canonizedReflection).compose(invCanonize);
        return resul;
    }

    public static AffineJTransform createReflectionByAxis(Point E1, Point E2, double alpha) {
        AffineJTransform canonize = AffineJTransform.createDirect2DHomothecy(E1, E2, new Point(0.0, 0.0), new Point(0.0, E2.v.norm()), 1.0);
        AffineJTransform invCanonize = canonize.getInverse();
        AffineJTransform canonizedReflection = new AffineJTransform();
        canonizedReflection.setV1Img(1.0 - alpha - 1.0 * alpha, 0.0, 0.0);
        AffineJTransform resul = canonize.compose(canonizedReflection).compose(invCanonize);
        return resul;
    }

    public AffineJTransform interpolate(AffineJTransform transform, double lambda) {
        double[] row1_1 = this.matrix.getRow(0);
        double[] row1_2 = transform.matrix.getRow(0);
        double interp11 = (1.0 - lambda) * row1_1[1] + lambda * row1_2[1];
        double interp12 = (1.0 - lambda) * row1_1[2] + lambda * row1_2[2];
        double interp13 = (1.0 - lambda) * row1_1[3] + lambda * row1_2[3];
        transform.setOriginImg(interp11, interp12, interp13);
        double[] row2_1 = this.matrix.getRow(1);
        double[] row2_2 = transform.matrix.getRow(1);
        double interp21 = (1.0 - lambda) * row2_1[1] + lambda * row2_2[1];
        double interp22 = (1.0 - lambda) * row2_1[2] + lambda * row2_2[2];
        double interp23 = (1.0 - lambda) * row2_1[3] + lambda * row2_2[3];
        transform.setV1Img(interp21, interp22, interp23);
        double[] row3_1 = this.matrix.getRow(2);
        double[] row3_2 = transform.matrix.getRow(2);
        double interp31 = (1.0 - lambda) * row3_1[1] + lambda * row3_2[1];
        double interp32 = (1.0 - lambda) * row3_1[2] + lambda * row3_2[2];
        double interp33 = (1.0 - lambda) * row3_1[3] + lambda * row3_2[3];
        transform.setV2Img(interp31, interp32, interp33);
        return transform;
    }

    public static AffineJTransform createAffineTransformation(Point A, Point B, Point C, Point D, Point E, Point F, double lambda) {
        AffineJTransform tr1 = new AffineJTransform();
        tr1.setOriginImg(A.copy());
        tr1.setV1Img(A.to(B));
        tr1.setV2Img(A.to(C));
        tr1 = tr1.getInverse();
        AffineJTransform tr2 = new AffineJTransform();
        tr2.setOriginImg(D.copy());
        tr2.setV1Img(D.to(E));
        tr2.setV2Img(D.to(F));
        AffineJTransform tr = tr1.compose(tr2);
        AffineJTransform id = new AffineJTransform();
        return id.interpolate(tr, lambda);
    }

    public static AffineJTransform createAffineTransformation(Rect r1, Rect r2, double lambda) {
        Point A1 = r1.getDL();
        Point A2 = r2.getDL();
        Point B1 = r1.getDR();
        Point B2 = r2.getDR();
        Point C1 = r1.getUL();
        Point C2 = r2.getUL();
        return AffineJTransform.createAffineTransformation(A1, B1, C1, A2, B2, C2, lambda);
    }

    public static AffineJTransform createRotateScaleXYTransformation(Point A, Point B, Point C, Point D, Point E, Point F, double lambda) {
        AffineJTransform tr1 = AffineJTransform.createDirect2DHomothecy(A, B, new Point(0.0, 0.0), new Point(1.0, 0.0), 1.0);
        AffineJTransform tr2 = new AffineJTransform();
        double proportionalHeight = F.to(E).norm() / D.to(E).norm() / (B.to(C).norm() / B.to(A).norm());
        tr2.setV2Img(0.0, proportionalHeight * lambda + (1.0 - lambda) * 1.0);
        AffineJTransform tr3 = AffineJTransform.createDirect2DHomothecy(A, B, D, E, lambda);
        return tr1.compose(tr2).compose(tr1.getInverse()).compose(tr3);
    }

    public void copyFrom(AffineJTransform resul) {
        this.setMatrix(resul.getMatrix().copy());
    }

    @Override
    public void saveState() {
        this.matrixBackup = this.matrix.copy();
    }

    @Override
    public void restoreState() {
        this.matrix = this.matrixBackup;
    }
}

