/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Utils.Boxable;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;

public class Anchor {
    public static Point getAnchorPoint(Boxable obj, Type anchor) {
        return Anchor.getAnchorPoint(obj, anchor, 0.0, 0.0);
    }

    public static Point getAnchorPoint(Boxable obj, Type anchor, double gap) {
        return Anchor.getAnchorPoint(obj, anchor, gap, gap);
    }

    public static Point getAnchorPoint(Boxable obj, Type anchor, double xgap, double ygap) {
        Point resul = new Point();
        Rect bb = obj.getBoundingBox();
        switch (anchor) {
            case BY_POINT: {
                if (obj instanceof Point) {
                    Point p = (Point)obj;
                    resul = p.copy();
                    break;
                }
                if (!(obj instanceof MathObject)) break;
                MathObject o = (MathObject)obj;
                resul = o.getAbsoluteAnchorPoint();
                break;
            }
            case CENTER: {
                resul = bb.getCenter();
                break;
            }
            case LEFT: {
                resul = bb.addGap(xgap, ygap).getLeft();
                break;
            }
            case RIGHT: {
                resul = bb.addGap(xgap, ygap).getRight();
                break;
            }
            case LOWER: {
                resul = bb.addGap(xgap, ygap).getLower();
                break;
            }
            case UPPER: {
                resul = bb.addGap(xgap, ygap).getUpper();
                break;
            }
            case UL: {
                resul = bb.addGap(xgap, ygap).getUL();
                break;
            }
            case UR: {
                resul = bb.addGap(xgap, ygap).getUR();
                break;
            }
            case DL: {
                resul = bb.addGap(xgap, ygap).getDL();
                break;
            }
            case DR: {
                resul = bb.addGap(xgap, ygap).getDR();
            }
        }
        return resul;
    }

    public static Type reverseAnchorPoint(Type anchorPoint) {
        Type resul = Type.CENTER;
        switch (anchorPoint) {
            case BY_POINT: {
                resul = Type.BY_POINT;
                break;
            }
            case CENTER: {
                resul = Type.CENTER;
                break;
            }
            case LEFT: {
                resul = Type.RIGHT;
                break;
            }
            case RIGHT: {
                resul = Type.LEFT;
                break;
            }
            case LOWER: {
                resul = Type.UPPER;
                break;
            }
            case UPPER: {
                resul = Type.LOWER;
                break;
            }
            case UL: {
                resul = Type.UR;
                break;
            }
            case UR: {
                resul = Type.UL;
                break;
            }
            case DL: {
                resul = Type.DR;
                break;
            }
            case DR: {
                resul = Type.DL;
            }
        }
        return resul;
    }

    public static Point getScreenAnchorPoint(Type anchor, double xMargin, double yMargin) {
        Point resul = new Point();
        Rect mathViewWithGap = JMathAnimConfig.getConfig().getCamera().getMathView().addGap(-xMargin, -yMargin);
        switch (anchor) {
            case CENTER: {
                resul = mathViewWithGap.getCenter();
                break;
            }
            case LEFT: {
                resul = mathViewWithGap.getLeft();
                break;
            }
            case RIGHT: {
                resul = mathViewWithGap.getRight();
                break;
            }
            case LOWER: {
                resul = mathViewWithGap.getLower();
                break;
            }
            case UPPER: {
                resul = mathViewWithGap.getUpper();
                break;
            }
            case UL: {
                resul = mathViewWithGap.getUL();
                break;
            }
            case UR: {
                resul = mathViewWithGap.getUR();
                break;
            }
            case DL: {
                resul = mathViewWithGap.getDL();
                break;
            }
            case DR: {
                resul = mathViewWithGap.getDR();
            }
        }
        return resul;
    }

    public static enum Type {
        BY_POINT,
        CENTER,
        RIGHT,
        UPPER,
        LEFT,
        LOWER,
        DR,
        UR,
        UL,
        DL;

    }
}

