/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import java.util.ArrayList;

public class CircularArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;

    @Override
    public E get(int index) throws ArrayIndexOutOfBoundsException {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Circular array with no elements");
        }
        while (index >= this.size()) {
            index -= this.size();
        }
        while (index < 0) {
            index += this.size();
        }
        return super.get(index);
    }

    @Override
    public E remove(int index) throws ArrayIndexOutOfBoundsException {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Circular array with no elements");
        }
        while (index >= this.size()) {
            index -= this.size();
        }
        while (index < 0) {
            index += this.size();
        }
        return super.remove(index);
    }

    @Override
    public void add(int index, E element) {
        if (!this.isEmpty()) {
            while (index >= this.size()) {
                index -= this.size();
            }
            while (index < 0) {
                index += this.size();
            }
        }
        super.add(index, element);
    }
}

