/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Styling.JMColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ColorScale {
    private final ArrayList<Double> markers = new ArrayList();
    private final HashMap<Double, JMColor> colors = new HashMap();

    public static ColorScale createDefault(double minValue, double maxValue) {
        ColorScale cs = new ColorScale();
        cs.addMarker(minValue, JMColor.BLUE);
        cs.addMarker(maxValue, JMColor.RED);
        return cs;
    }

    public void addMarker(double marker, JMColor color) {
        this.markers.add(marker);
        this.colors.put(marker, color);
        Collections.sort(this.markers);
    }

    public JMColor getColorValue(double x) {
        int n = 0;
        while (this.markers.get(n) <= x) {
            if (++n != this.markers.size()) continue;
            return this.colors.get(this.markers.get(this.markers.size() - 1));
        }
        if (n == 0) {
            return this.colors.get(this.markers.get(0));
        }
        double a = this.markers.get(n - 1);
        double b = this.markers.get(n);
        JMColor colA = this.colors.get(a).copy();
        double alpha = (x - a) / (b - a);
        JMColor colB = this.colors.get(b);
        return (JMColor)colA.interpolate(colB, alpha);
    }

    public ArrayList<Double> getMarkers() {
        return this.markers;
    }

    public void copyFrom(ColorScale colorScale) {
        double m;
        this.markers.clear();
        for (Double mark : colorScale.markers) {
            m = mark;
            this.markers.add(m);
        }
        this.colors.clear();
        for (Double c : this.colors.keySet()) {
            m = c;
            this.colors.put(m, this.colors.get(m).copy());
        }
    }
}

