/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.ConfigLoader;
import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.ResourceLoader;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import java.io.File;
import java.net.URL;
import java.util.HashMap;

public class JMathAnimConfig {
    private String outputFileName;
    private File resourcesDir;
    private File outputDir;
    public int mediaW = 800;
    public int mediaH = 600;
    public int fps = 30;
    private static JMathAnimConfig singletonConfig;
    private JMathAnimScene scene;
    private Renderer renderer;
    private boolean createMovie = false;
    private boolean saveToPNG = false;
    private boolean showPreview = true;
    private final HashMap<String, MODrawProperties> styles;
    private PaintStyle backgroundColor = JMColor.BLACK;
    public boolean delay = true;
    public boolean drawShadow = false;
    public int shadowKernelSize = 10;
    public int shadowOffsetX = 5;
    public int shadowOffsetY = 5;
    public float shadowAlpha = 0.5f;
    private URL backGroundImage = null;
    public boolean showFrameNumbers = false;

    public static JMathAnimConfig getConfig() {
        if (singletonConfig == null) {
            singletonConfig = new JMathAnimConfig();
        }
        return singletonConfig;
    }

    public void setDrawShadow(boolean drawShadow) {
        this.drawShadow = drawShadow;
    }

    public void setShadowParameters(int kernelSize, int offsetX, int offsetY, float alpha) {
        this.shadowKernelSize = kernelSize;
        this.shadowOffsetX = offsetX;
        this.shadowOffsetY = offsetY;
        this.shadowAlpha = alpha;
    }

    public void setBackGroundImage(String name) {
        ResourceLoader rl = new ResourceLoader();
        this.setBackGroundImage(rl.getResource(name, "images"));
        JMathAnimScene.logger.info("Background image set to " + rl.getResource(name, "images"));
    }

    public void setBackGroundImage(URL backGroundImage) {
        this.backGroundImage = backGroundImage;
    }

    public URL getBackGroundImage() {
        return this.backGroundImage;
    }

    private JMathAnimConfig() {
        this.styles = new HashMap();
        this.setDefaultMP();
        this.resourcesDir = new File("." + File.separator + "resources");
        this.outputDir = new File("." + File.separator + "media");
    }

    public void setLowQuality() {
        this.mediaW = 854;
        this.mediaH = 480;
        this.fps = 30;
    }

    public void setMediumQuality() {
        this.mediaW = 1280;
        this.mediaH = 720;
        this.fps = 30;
    }

    public void setAdjustPreviewToFPS(boolean delay) {
        this.delay = delay;
    }

    public void setHighQuality() {
        this.mediaW = 1920;
        this.mediaH = 1080;
        this.fps = 60;
    }

    public JMathAnimScene getScene() {
        return this.scene;
    }

    public void setScene(JMathAnimScene scene) {
        this.scene = scene;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Camera getFixedCamera() {
        return this.renderer.getFixedCamera();
    }

    public Camera getCamera() {
        return this.renderer.getCamera();
    }

    public PaintStyle getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(PaintStyle bakcgroundColor) {
        this.backgroundColor = bakcgroundColor;
    }

    public void setCreateMovie(boolean createMovie) {
        this.createMovie = createMovie;
    }

    public void setShowPreviewWindow(boolean showPreviewWindow) {
        this.showPreview = showPreviewWindow;
    }

    public final void setDefaultMP() {
        MODrawProperties defaultMP = new MODrawProperties();
        defaultMP.setDrawColor(JMColor.WHITE);
        defaultMP.setFillColor(JMColor.GRAY);
        defaultMP.setFillAlpha(0.0);
        defaultMP.thickness = 1.0;
        defaultMP.dashStyle = MODrawProperties.DashStyle.SOLID;
        defaultMP.absoluteThickness = false;
        this.styles.put("DEFAULT", defaultMP);
        MODrawProperties latexDefaultMP = defaultMP.copy();
        latexDefaultMP.setFillColor(JMColor.WHITE);
        latexDefaultMP.setFillAlpha(1.0);
        this.styles.put("LATEXDEFAULT", latexDefaultMP);
    }

    public MODrawProperties getDefaultMP() {
        return this.styles.get("DEFAULT").copy();
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public void setResourcesDir(String path) {
        this.resourcesDir = new File(path);
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String str) {
        this.outputDir = new File(str);
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public HashMap<String, MODrawProperties> getStyles() {
        return this.styles;
    }

    public boolean isCreateMovie() {
        return this.createMovie;
    }

    public boolean isShowPreview() {
        return this.showPreview;
    }

    public MODrawProperties createStyleFrom(Stylable mp, String styleName) {
        JMathAnimScene.logger.info("Creating style {}", (Object)styleName.toUpperCase());
        MODrawProperties mpO = mp.getFirstMP();
        return this.styles.put(styleName.toUpperCase(), mpO);
    }

    public MODrawProperties createStyleFrom(MathObject obj, String styleName) {
        return this.createStyleFrom(obj.getMp(), styleName);
    }

    public void setMediaW(int mediaW) {
        this.mediaW = mediaW;
    }

    public void setMediaH(int mediaH) {
        this.mediaH = mediaH;
    }

    public void setFPS(int fps) {
        this.fps = fps;
    }

    public void parseFile(String url) {
        ConfigLoader.parseFile(url);
    }

    public boolean isSaveToPNG() {
        return this.saveToPNG;
    }

    public void setSaveToPNG(boolean saveToPNG) {
        this.saveToPNG = saveToPNG;
    }

    public void setShowDebugFrameNumbers(boolean showFrameNumbers) {
        this.showFrameNumbers = showFrameNumbers;
    }
}

