/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils.Layouts;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Layouts.GroupLayout;
import com.jmathanim.mathobjects.Point;

public abstract class AbstractBoxLayout
extends GroupLayout {
    protected Point corner;
    protected double inRowGap;
    protected double inColGap;
    Anchor.Type inRowStack;
    Anchor.Type inColStack;
    Anchor.Type firstElementStack;
    RowAlignType rowAlignType;

    public AbstractBoxLayout(Point corner, double inRowGap, double inColGap) {
        this.inRowGap = inRowGap;
        this.inColGap = inColGap;
        this.corner = corner;
    }

    public <T extends AbstractBoxLayout> T setDirection(Direction dir) {
        this.computeDirections(dir);
        return (T)this;
    }

    protected final void computeDirections(Direction direction) {
        switch (direction) {
            case RIGHT_UP: {
                this.inRowStack = Anchor.Type.RIGHT;
                this.inColStack = Anchor.Type.UPPER;
                this.firstElementStack = Anchor.Type.DL;
                break;
            }
            case RIGHT_DOWN: {
                this.inRowStack = Anchor.Type.RIGHT;
                this.inColStack = Anchor.Type.LOWER;
                this.firstElementStack = Anchor.Type.UL;
                break;
            }
            case LEFT_UP: {
                this.inRowStack = Anchor.Type.LEFT;
                this.inColStack = Anchor.Type.UPPER;
                this.firstElementStack = Anchor.Type.DR;
                break;
            }
            case LEFT_DOWN: {
                this.inRowStack = Anchor.Type.LEFT;
                this.inColStack = Anchor.Type.LOWER;
                this.firstElementStack = Anchor.Type.UR;
                break;
            }
            case UP_RIGHT: {
                this.inRowStack = Anchor.Type.UPPER;
                this.inColStack = Anchor.Type.RIGHT;
                this.firstElementStack = Anchor.Type.DL;
                break;
            }
            case UP_LEFT: {
                this.inRowStack = Anchor.Type.UPPER;
                this.inColStack = Anchor.Type.LEFT;
                this.firstElementStack = Anchor.Type.DR;
                break;
            }
            case DOWN_RIGHT: {
                this.inRowStack = Anchor.Type.LOWER;
                this.inColStack = Anchor.Type.RIGHT;
                this.firstElementStack = Anchor.Type.UL;
                break;
            }
            case DOWN_LEFT: {
                this.inRowStack = Anchor.Type.LOWER;
                this.inColStack = Anchor.Type.LEFT;
                this.firstElementStack = Anchor.Type.UR;
                break;
            }
            default: {
                this.inRowStack = Anchor.Type.RIGHT;
                this.inColStack = Anchor.Type.UPPER;
                this.firstElementStack = Anchor.Type.DL;
            }
        }
    }

    public void setRowAlign(RowAlignType type) {
        switch (type) {
            case UPPER: {
                if (this.inRowStack == Anchor.Type.LEFT) {
                    this.inRowStack = Anchor.Type.UL;
                }
                if (this.inRowStack == Anchor.Type.RIGHT) {
                    this.inRowStack = Anchor.Type.UR;
                }
                if (this.inRowStack == Anchor.Type.UPPER) {
                    this.inRowStack = Anchor.Type.UL;
                }
                if (this.inRowStack != Anchor.Type.LOWER) break;
                this.inRowStack = Anchor.Type.DL;
                break;
            }
            case MIDDLE: {
                break;
            }
            case LOWER: {
                if (this.inRowStack == Anchor.Type.LEFT) {
                    this.inRowStack = Anchor.Type.DL;
                }
                if (this.inRowStack == Anchor.Type.RIGHT) {
                    this.inRowStack = Anchor.Type.DR;
                }
                if (this.inRowStack == Anchor.Type.UPPER) {
                    this.inRowStack = Anchor.Type.UR;
                }
                if (this.inRowStack != Anchor.Type.LOWER) break;
                this.inRowStack = Anchor.Type.DR;
            }
        }
    }

    public Point getCorner() {
        return this.corner;
    }

    public void setCorner(Point corner) {
        this.corner = corner;
    }

    public double getInRowGap() {
        return this.inRowGap;
    }

    public <T extends AbstractBoxLayout> T setInRowGap(double inRowGap) {
        this.inRowGap = inRowGap;
        return (T)this;
    }

    public double getInColGap() {
        return this.inColGap;
    }

    public <T extends AbstractBoxLayout> T setInColGap(double inColGap) {
        this.inColGap = inColGap;
        return (T)this;
    }

    public static enum Direction {
        RIGHT_UP,
        RIGHT_DOWN,
        LEFT_UP,
        LEFT_DOWN,
        UP_RIGHT,
        UP_LEFT,
        DOWN_RIGHT,
        DOWN_LEFT;

    }

    public static enum RowAlignType {
        UPPER,
        LOWER,
        MIDDLE;

    }
}

