/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils.Layouts;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Layouts.AbstractBoxLayout;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;

public class BoxLayout
extends AbstractBoxLayout {
    int rowSize;

    public static BoxLayout make(int rowSize) {
        return new BoxLayout(rowSize);
    }

    public BoxLayout(int rowSize) {
        this(null, rowSize, AbstractBoxLayout.Direction.RIGHT_UP, 0.0, 0.0);
    }

    public BoxLayout(Point corner, int rowSize) {
        this(corner, rowSize, AbstractBoxLayout.Direction.RIGHT_UP, 0.0, 0.0);
    }

    public BoxLayout(Point corner, int rowSize, AbstractBoxLayout.Direction direction, double inRowGap, double inColGap) {
        super(corner, inRowGap, inColGap);
        this.computeDirections(direction);
        this.rowSize = rowSize;
    }

    public BoxLayout(int rowSize, AbstractBoxLayout.Direction direction, double inRowGap, double inColGap) {
        this(null, rowSize, direction, inRowGap, inColGap);
    }

    @Override
    public void applyLayout(MathObjectGroup group) {
        int rowCounter = 0;
        MathObject firstOfTheRow = group.get(0);
        if (this.corner != null) {
            group.get(0).stackTo(this.firstElementStack, this.corner, Anchor.Type.CENTER, 0.0);
        }
        for (int n = 1; n < group.size(); ++n) {
            if (++rowCounter < this.rowSize) {
                group.get(n).stackTo(group.get(n - 1), this.inRowStack, this.inRowGap);
            }
            if (rowCounter != this.rowSize) continue;
            rowCounter = 0;
            group.get(n).stackTo(firstOfTheRow, this.inColStack, this.inColGap);
            firstOfTheRow = group.get(n);
        }
    }

    public MathObjectGroup getRowGroups(MathObjectGroup group) {
        MathObjectGroup rowGroups = MathObjectGroup.make(new MathObject[0]);
        int rowCounter = 0;
        MathObjectGroup currentRow = MathObjectGroup.make(new MathObject[0]);
        for (int n = 0; n < group.size(); ++n) {
            if (rowCounter < this.rowSize) {
                ++rowCounter;
            } else {
                rowCounter = 1;
                rowGroups.add((MathObject)currentRow);
                currentRow = MathObjectGroup.make(new MathObject[0]);
            }
            currentRow.add(group.get(n));
        }
        if (!rowGroups.getObjects().contains(currentRow)) {
            rowGroups.add((MathObject)currentRow);
        }
        return rowGroups;
    }

    public MathObjectGroup getColumnGroups(MathObjectGroup group) {
        MathObjectGroup colGroup = MathObjectGroup.make(new MathObject[0]);
        MathObjectGroup currentCol = MathObjectGroup.make(new MathObject[0]);
        for (int n = 0; n < this.rowSize; ++n) {
            for (int index = n; index < group.size(); index += this.rowSize) {
                currentCol.add(group.get(index));
            }
            colGroup.add((MathObject)currentCol);
            currentCol = MathObjectGroup.make(new MathObject[0]);
        }
        return colGroup;
    }

    public BoxLayout copy() {
        if (this.corner != null) {
            return new BoxLayout(this.corner.copy(), this.rowSize, AbstractBoxLayout.Direction.RIGHT_UP, this.inRowGap, this.inColGap);
        }
        return new BoxLayout(this.rowSize, AbstractBoxLayout.Direction.RIGHT_UP, this.inRowGap, this.inColGap);
    }
}

