/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils.Layouts;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Layouts.AbstractBoxLayout;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import java.util.ArrayList;
import java.util.function.IntToDoubleFunction;

public class FlowLayout
extends AbstractBoxLayout {
    public IntToDoubleFunction rowLength;
    AbstractBoxLayout.Direction direction;

    public FlowLayout(Point corner, double width, AbstractBoxLayout.Direction direction, double inRowGap, double inColGap) {
        super(corner, inRowGap, inColGap);
        this.rowLength = row -> width;
        this.direction = direction;
        this.computeDirections(direction);
    }

    public FlowLayout(Point corner, IntToDoubleFunction widthFunction, AbstractBoxLayout.Direction direction, double inRowGap, double inColGap) {
        super(corner, inRowGap, inColGap);
        this.rowLength = widthFunction;
        this.direction = direction;
        this.computeDirections(direction);
    }

    private double getAppropiateSize(MathObject obj) {
        double resul = 0.0;
        switch (this.direction) {
            case DOWN_LEFT: 
            case DOWN_RIGHT: 
            case UP_LEFT: 
            case UP_RIGHT: {
                resul = obj.getHeight();
                break;
            }
            case LEFT_DOWN: 
            case LEFT_UP: 
            case RIGHT_DOWN: 
            case RIGHT_UP: {
                resul = obj.getWidth();
            }
        }
        return resul;
    }

    @Override
    public void applyLayout(MathObjectGroup group) {
        ArrayList<MathObjectGroup> rowGroups = this.getRowGroups(group);
        rowGroups.get(0).get(0).stackTo(this.firstElementStack, this.corner, Anchor.Type.CENTER, 0.0);
        for (int n = 1; n < rowGroups.get(0).size(); ++n) {
            rowGroups.get(0).get(n).stackTo(rowGroups.get(0).get(n - 1), this.inRowStack, this.inRowGap);
        }
        for (int k = 1; k < rowGroups.size(); ++k) {
            rowGroups.get(k).get(0).stackTo(rowGroups.get(k - 1).get(0), this.inColStack, this.inColGap);
            for (int n = 1; n < rowGroups.get(k).size(); ++n) {
                rowGroups.get(k).get(n).stackTo(rowGroups.get(k).get(n - 1), this.inRowStack, this.inRowGap);
            }
            MathObject.Align align = null;
            switch (this.direction) {
                case RIGHT_DOWN: 
                case RIGHT_UP: {
                    align = MathObject.Align.LEFT;
                    break;
                }
                case LEFT_DOWN: 
                case LEFT_UP: {
                    align = MathObject.Align.RIGHT;
                    break;
                }
                case UP_LEFT: 
                case UP_RIGHT: {
                    align = MathObject.Align.LOWER;
                    break;
                }
                case DOWN_LEFT: 
                case DOWN_RIGHT: {
                    align = MathObject.Align.UPPER;
                }
            }
            rowGroups.get(k).align(rowGroups.get(0), align);
        }
    }

    public ArrayList<MathObjectGroup> getRowGroups(MathObjectGroup group) {
        ArrayList<MathObjectGroup> resul = new ArrayList<MathObjectGroup>();
        MathObject firstOfTheRow = group.get(0);
        MathObjectGroup currentRow = MathObjectGroup.make(firstOfTheRow);
        resul.add(currentRow);
        int rowNumber = 0;
        double totalWidth = this.getAppropiateSize(firstOfTheRow);
        firstOfTheRow.stackTo(this.corner, this.firstElementStack);
        for (int n = 1; n < group.size(); ++n) {
            if ((totalWidth += this.getAppropiateSize(group.get(n)) + this.inRowGap) <= this.rowLength.applyAsDouble(rowNumber)) {
                currentRow.add(group.get(n));
                continue;
            }
            ++rowNumber;
            firstOfTheRow = group.get(n);
            totalWidth = this.getAppropiateSize(firstOfTheRow);
            currentRow = MathObjectGroup.make(firstOfTheRow);
            resul.add(currentRow);
        }
        return resul;
    }

    private MathObjectGroup.Layout getInRowLayout() {
        MathObjectGroup.Layout resul = null;
        switch (this.direction) {
            // Empty switch
        }
        return resul;
    }

    public FlowLayout copy() {
        if (this.corner != null) {
            return new FlowLayout(this.corner.copy(), this.rowLength, this.direction, this.inRowGap, this.inColGap);
        }
        return new FlowLayout(null, this.rowLength, this.direction, this.inRowGap, this.inColGap);
    }
}

