/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils.Layouts;

import com.jmathanim.Utils.Rect;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Shape;

public abstract class GroupLayout {
    public abstract void applyLayout(MathObjectGroup var1);

    public Rect getBoundingBox(MathObjectGroup group) {
        if (group.isEmpty()) {
            return null;
        }
        MathObjectGroup boxedGroup = this.createBoxedGroup(group, 0.0, 0.0);
        this.applyLayout(boxedGroup);
        Rect bbox = boxedGroup.getBoundingBox();
        return bbox;
    }

    protected MathObjectGroup createBoxedGroup(MathObjectGroup group, double hgap, double vgap) {
        MathObjectGroup resul = MathObjectGroup.make(new MathObject[0]);
        for (MathObject ob : group) {
            resul.add((MathObject)Shape.rectangle(ob.getBoundingBox().addGap(hgap, vgap)));
        }
        return resul;
    }

    public abstract <T extends GroupLayout> T copy();
}

