/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils.Layouts;

import com.jmathanim.Utils.Layouts.GroupLayout;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import java.util.ArrayList;
import java.util.Iterator;

public class HeapLayout
extends GroupLayout {
    private final ArrayList<MathObjectGroup> rightSide;
    private final ArrayList<MathObjectGroup> leftSide;
    MathObjectGroup center = new MathObjectGroup();
    private final Point base;
    private final double horizontalGap;
    private final double verticalGap;

    public HeapLayout() {
        this(0.0, 0.0);
    }

    public HeapLayout(double hgap, double vgap) {
        this(null, hgap, vgap);
    }

    public HeapLayout(Point base, double hgap, double vgap) {
        this.rightSide = new ArrayList();
        this.leftSide = new ArrayList();
        this.base = base;
        this.horizontalGap = hgap;
        this.verticalGap = vgap;
    }

    @Override
    public void applyLayout(MathObjectGroup group) {
        MathObjectGroup get;
        int col;
        Iterator<MathObjectGroup> col2;
        this.center.clear();
        this.rightSide.clear();
        this.leftSide.clear();
        int n = group.size();
        int k = 0;
        int step = 2;
        while (k < n) {
            this.center.add(group.get(k));
            k += step;
            step += 2;
        }
        int colIndex = 1;
        while (colIndex * colIndex < n) {
            k = colIndex * colIndex;
            col2 = new MathObjectGroup();
            step = (colIndex + 1) * 2;
            while (k < n) {
                ((MathObjectGroup)((Object)col2)).add(group.get(k));
                k += step;
                step += 2;
            }
            this.leftSide.add((MathObjectGroup)((Object)col2));
            ++colIndex;
        }
        colIndex = 2;
        while (colIndex * colIndex - 1 < n) {
            k = colIndex * colIndex - 1;
            col2 = new MathObjectGroup();
            step = colIndex * 2;
            while (k < n) {
                ((MathObjectGroup)((Object)col2)).add(group.get(k));
                k += step;
                step += 2;
            }
            this.rightSide.add((MathObjectGroup)((Object)col2));
            ++colIndex;
        }
        this.center.setLayout(MathObjectGroup.Layout.UPPER, this.verticalGap);
        for (MathObjectGroup cols : this.leftSide) {
            cols.setLayout(MathObjectGroup.Layout.UPPER, this.verticalGap);
        }
        for (MathObjectGroup cols : this.rightSide) {
            cols.setLayout(MathObjectGroup.Layout.UPPER, this.verticalGap);
        }
        MathObjectGroup whole = MathObjectGroup.make(new MathObject[0]);
        for (col = 0; col < this.leftSide.size(); ++col) {
            get = this.leftSide.get(this.leftSide.size() - 1 - col);
            whole.add((MathObject)get);
        }
        whole.add((MathObject)this.center);
        for (col = 0; col < this.rightSide.size(); ++col) {
            get = this.rightSide.get(col);
            whole.add((MathObject)get);
        }
        whole.setLayout(MathObjectGroup.Layout.DRIGHT, this.horizontalGap);
        Point a = this.center.get(0).getBoundingBox().getLower();
        if (this.base != null) {
            whole.shift(a.to(this.base));
        }
    }

    public HeapLayout copy() {
        return new HeapLayout(this.base.copy(), this.verticalGap, this.verticalGap);
    }
}

