/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils.Layouts;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Layouts.GroupLayout;
import com.jmathanim.Utils.Rect;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class PascalLayout
extends GroupLayout {
    private final Point top;
    private final double horizontalGap;
    private final double verticalGap;

    public PascalLayout() {
        this(0.0, 0.0);
    }

    public PascalLayout(double horizontalGap, double verticalGap) {
        this.top = null;
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
    }

    public PascalLayout(Point top, double horizontalGap, double verticalGap) {
        this.top = top;
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
    }

    @Override
    public void applyLayout(MathObjectGroup group) {
        if (group.isEmpty()) {
            return;
        }
        double w = 0.0;
        double h = 0.0;
        for (MathObject g : group) {
            w = Math.max(w, g.getWidth());
            h = Math.max(h, g.getHeight());
        }
        Rect r = new Rect(0.0, 0.0, w, h);
        r = r.addGap(0.5 * this.horizontalGap, 0.5 * this.verticalGap);
        MathObjectGroup workGroup = MathObjectGroup.make(new MathObject[0]);
        int num = 0;
        int k = 0;
        while (num < group.size()) {
            num = k * (k + 1) / 2;
            ++k;
        }
        for (int n = 0; n < num; ++n) {
            workGroup.add((MathObject)Shape.rectangle(r));
        }
        int rowSize = 1;
        int counter = 0;
        int rowCounter = 0;
        MathObjectGroup rows = MathObjectGroup.make(new MathObject[0]);
        while (counter < workGroup.size()) {
            MathObjectGroup grRow = MathObjectGroup.make(new MathObject[0]);
            while (rowCounter < rowSize) {
                if (counter < workGroup.size()) {
                    grRow.add(workGroup.get(counter));
                }
                ++counter;
                ++rowCounter;
            }
            grRow.setLayout(MathObjectGroup.Layout.RIGHT, 0.0);
            rows.add((MathObject)grRow);
            ++rowSize;
            rowCounter = 0;
        }
        rows.setLayout(MathObjectGroup.Layout.LOWER, 0.0);
        for (int n = 0; n < group.size(); ++n) {
            group.get(n).stackTo(workGroup.get(n), Anchor.Type.CENTER);
        }
        Point A = Anchor.getAnchorPoint(group.get(0), Anchor.Type.UPPER);
        if (this.top != null) {
            group.shift(A.to(this.top));
        }
    }

    public MathObjectGroup getRowGroups(MathObjectGroup group) {
        int rowSize = 1;
        int counter = 0;
        int rowCounter = 0;
        MathObjectGroup rows = MathObjectGroup.make(new MathObject[0]);
        while (counter < group.size()) {
            MathObjectGroup grRow = MathObjectGroup.make(new MathObject[0]);
            while (rowCounter < rowSize) {
                if (counter < group.size()) {
                    grRow.add(group.get(counter));
                }
                ++counter;
                ++rowCounter;
            }
            rows.add((MathObject)grRow);
            ++rowSize;
            rowCounter = 0;
        }
        return rows;
    }

    public PascalLayout copy() {
        if (this.top != null) {
            return new PascalLayout(this.top.copy(), this.horizontalGap, this.verticalGap);
        }
        return new PascalLayout(null, this.horizontalGap, this.verticalGap);
    }
}

