/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils.Layouts;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Layouts.GroupLayout;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;

public class SpiralLayout
extends GroupLayout {
    private final Point center;
    private double horizontalGap;
    private double verticalGap;
    private int spiralGap;
    Orientation orientation;
    Anchor.Type[] stacks;

    public SpiralLayout() {
        this(null, Orientation.RIGHT_CLOCKWISE, 0.0, 0.0);
    }

    public SpiralLayout(Point center, Orientation orientation, double hgap, double vgap) {
        this.center = center;
        this.orientation = orientation;
        this.horizontalGap = hgap;
        this.verticalGap = vgap;
        this.spiralGap = 0;
        switch (orientation) {
            case LEFT_CLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.LEFT, Anchor.Type.UPPER, Anchor.Type.RIGHT, Anchor.Type.LOWER};
                break;
            }
            case RIGHT_CLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.RIGHT, Anchor.Type.LOWER, Anchor.Type.LEFT, Anchor.Type.UPPER};
                break;
            }
            case UPPER_CLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.UPPER, Anchor.Type.RIGHT, Anchor.Type.LOWER, Anchor.Type.LEFT};
                break;
            }
            case LOWER_CLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.LOWER, Anchor.Type.LEFT, Anchor.Type.UPPER, Anchor.Type.RIGHT};
                break;
            }
            case LEFT_COUNTERCLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.LEFT, Anchor.Type.LOWER, Anchor.Type.RIGHT, Anchor.Type.UPPER};
                break;
            }
            case RIGHT_COUNTERCLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.RIGHT, Anchor.Type.UPPER, Anchor.Type.LEFT, Anchor.Type.LOWER};
                break;
            }
            case UPPER_COUNTERCLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.UPPER, Anchor.Type.LEFT, Anchor.Type.LOWER, Anchor.Type.RIGHT};
                break;
            }
            case LOWER_COUNTERCLOCKWISE: {
                this.stacks = new Anchor.Type[]{Anchor.Type.LOWER, Anchor.Type.RIGHT, Anchor.Type.UPPER, Anchor.Type.LEFT};
            }
        }
    }

    @Override
    public void applyLayout(MathObjectGroup group) {
        if (this.center != null) {
            group.get(0).stackTo(this.center, Anchor.Type.CENTER);
        }
        int stackType = 0;
        int numberOfStacks = Math.max(1, this.spiralGap);
        int turnNumber = 1;
        for (int n = 1; n < group.size(); ++n) {
            Anchor.Type stack = this.stacks[stackType];
            group.get(n).stackTo(Anchor.reverseAnchorPoint(stack), group.get(n - 1), stack, this.horizontalGap, this.verticalGap);
            if (--numberOfStacks != 0) continue;
            numberOfStacks = ((this.spiralGap + 1) * ++turnNumber + 1) / 2;
            stackType = (stackType + 1) % 4;
        }
    }

    public SpiralLayout copy() {
        if (this.center != null) {
            return new SpiralLayout(this.center.copy(), this.orientation, this.verticalGap, this.verticalGap);
        }
        return new SpiralLayout(null, this.orientation, this.verticalGap, this.verticalGap);
    }

    public <T extends SpiralLayout> T setSpiralGap(int spiralGap) {
        this.spiralGap = spiralGap;
        return (T)this;
    }

    public static enum Orientation {
        UPPER_CLOCKWISE,
        UPPER_COUNTERCLOCKWISE,
        RIGHT_CLOCKWISE,
        RIGHT_COUNTERCLOCKWISE,
        LOWER_CLOCKWISE,
        LOWER_COUNTERCLOCKWISE,
        LEFT_CLOCKWISE,
        LEFT_COUNTERCLOCKWISE;

    }
}

