/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Cameras.Camera3D;
import com.jmathanim.Utils.CircularArrayList;
import com.jmathanim.Utils.Vec;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.Point;
import java.util.ArrayList;

public class PathUtils {
    public static final double DEFAULT_TENSION = 0.7;

    public static void generateControlPointsBySimpleSlopes(JMPath path) {
        PathUtils.generateControlPointsBySimpleSlopes(path, 0.7);
    }

    public static void generateControlPointsBySimpleSlopes(JMPath path, double tension) {
        if (path.pathType == 2) {
            return;
        }
        int numPoints = path.jmPathPoints.size();
        for (int n = 0; n < numPoints + 1; ++n) {
            int i = n - 1;
            int k = n + 1;
            int L = n + 2;
            JMPathPoint p1 = path.jmPathPoints.get(i);
            JMPathPoint p2 = path.jmPathPoints.get(n);
            JMPathPoint p3 = path.jmPathPoints.get(k);
            JMPathPoint p4 = path.jmPathPoints.get(L);
            double x1 = p1.p.v.x;
            double y1 = p1.p.v.y;
            double z1 = p1.p.v.z;
            double x2 = p2.p.v.x;
            double y2 = p2.p.v.y;
            double z2 = p2.p.v.z;
            double x3 = p3.p.v.x;
            double y3 = p3.p.v.y;
            double z3 = p3.p.v.z;
            double x4 = p4.p.v.x;
            double y4 = p4.p.v.y;
            double z4 = p4.p.v.z;
            if (p3.isCurved) {
                double mod31 = p1.p.to(p3.p).norm();
                double mod42 = p4.p.to(p2.p).norm();
                double mod23 = p2.p.to(p3.p).norm();
                double cx1 = x2 + mod23 / mod31 * (1.0 - tension) * (x3 - x1);
                double cy1 = y2 + mod23 / mod31 * (1.0 - tension) * (y3 - y1);
                double cz1 = z2 + mod23 / mod31 * (1.0 - tension) * (z3 - z1);
                double cx2 = x3 - mod23 / mod42 * (1.0 - tension) * (x4 - x2);
                double cy2 = y3 - mod23 / mod42 * (1.0 - tension) * (y4 - y2);
                double cz2 = z3 - mod23 / mod42 * (1.0 - tension) * (z4 - z2);
                p2.cpExit.v.x = cx1;
                p2.cpExit.v.y = cy1;
                p2.cpExit.v.z = cz1;
                p3.cpEnter.v.x = cx2;
                p3.cpEnter.v.y = cy2;
                p3.cpEnter.v.z = cz2;
                continue;
            }
            p2.cpExit.v.copyFrom(p2.p.v);
            p3.cpEnter.v.copyFrom(p3.p.v);
        }
        JMPathPoint jp0 = path.jmPathPoints.get(0);
        if (!jp0.isThisSegmentVisible) {
            JMPathPoint jp1 = path.jmPathPoints.get(1);
            Vec v = jp0.p.to(jp1.cpEnter).multInSite(0.7);
            jp0.cpExit.copyFrom(jp0.p.add(v));
            jp1 = path.jmPathPoints.get(numPoints - 2);
            jp0 = path.jmPathPoints.get(numPoints - 1);
            if (jp0.isCurved) {
                v = jp0.p.to(jp1.cpExit).multInSite(0.7);
                jp0.cpEnter.copyFrom(jp0.p.add(v));
            }
        }
    }

    public JMPathPoint getInterpolatedPoint(JMPathPoint jmp1, JMPathPoint jmp2, double alpha) {
        JMPathPoint interpolate;
        if (jmp2.isCurved) {
            Point E = jmp1.p.interpolate(jmp1.cpExit, alpha);
            Point G = jmp2.cpEnter.interpolate(jmp2.p, alpha);
            Point F = jmp1.cpExit.interpolate(jmp2.cpEnter, alpha);
            Point H = E.interpolate(F, alpha);
            Point J = F.interpolate(G, alpha);
            Point K = H.interpolate(J, alpha);
            interpolate = new JMPathPoint(K, jmp2.isThisSegmentVisible, JMPathPoint.JMPathPointType.INTERPOLATION_POINT);
            interpolate.cpExit.v.copyFrom(J.v);
            interpolate.cpEnter.v.copyFrom(H.v);
        } else {
            Point K = jmp1.p.interpolate(jmp2.p, alpha);
            interpolate = new JMPathPoint(K, jmp2.isThisSegmentVisible, JMPathPoint.JMPathPointType.INTERPOLATION_POINT);
        }
        interpolate.isCurved = jmp2.isCurved;
        return interpolate;
    }

    public void determineStraightSegments(JMPath path) {
        CircularArrayList<JMPathPoint> jmPathPoints = path.jmPathPoints;
        for (int n = 0; n < path.size(); ++n) {
            JMPathPoint p1 = jmPathPoints.get(n);
            JMPathPoint p2 = jmPathPoints.get(n + 1);
            p2.isCurved = !(p1.p.to(p1.cpExit).norm() < 1.0E-4) || !(p2.p.to(p2.cpEnter).norm() < 1.0E-4);
        }
    }

    public ArrayList<ArrayList<Point>> computePolygonalPieces(Camera cam, JMPath path) {
        CircularArrayList<JMPathPoint> jmPathPoints = path.jmPathPoints;
        ArrayList<ArrayList<Point>> resul = new ArrayList<ArrayList<Point>>();
        ArrayList<Point> connectedSegments = new ArrayList<Point>();
        for (int n = 0; n < path.size(); ++n) {
            JMPathPoint p = jmPathPoints.get(n);
            JMPathPoint q = jmPathPoints.get(n + 1);
            if (q.isThisSegmentVisible) {
                this.computeStraightenedPoints(connectedSegments, p, q, cam);
                continue;
            }
            resul.add(connectedSegments);
            connectedSegments = new ArrayList();
        }
        if (!connectedSegments.isEmpty()) {
            resul.add(connectedSegments);
        }
        return resul;
    }

    private void computeStraightenedPoints(ArrayList<Point> connectedSegments, JMPathPoint p, JMPathPoint q, Camera cam) {
        if (connectedSegments.isEmpty()) {
            connectedSegments.add(p.p);
        }
        if (q.isCurved) {
            int num = this.appropiateSubdivisionNumber(p.p.v, q.p.v, cam);
            for (int n = 1; n < num; ++n) {
                connectedSegments.add((Point)p.interpolate((JMPathPoint)q, (double)((double)n * 1.0 / (double)num)).p.drawColor("blue"));
            }
        }
        connectedSegments.add(q.p);
    }

    private int appropiateSubdivisionNumber(Vec v1, Vec v2, Camera cam) {
        double mathviewHeight;
        if (cam instanceof Camera3D) {
            Camera3D cam3D = (Camera3D)cam;
            double zDepth = v1.interpolate(v2, 0.5).minus(cam3D.eye.v).norm();
            mathviewHeight = cam3D.getMathViewHeight3D(zDepth);
        } else {
            mathviewHeight = cam.getMathView().getHeight();
        }
        double d = (Math.abs(v1.x - v2.x) + Math.abs(v1.y - v2.y) + Math.abs(v1.z - v2.z)) / mathviewHeight;
        if (d >= 1.0) {
            return 30;
        }
        if (d > 0.5) {
            return 20;
        }
        if (d > 0.2) {
            return 15;
        }
        if (d > 0.1) {
            return 10;
        }
        if (d > 0.05) {
            return 7;
        }
        return 5;
    }
}

