/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Boxable;
import com.jmathanim.Utils.Vec;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Stateable;
import java.util.Arrays;
import java.util.List;

public class Rect
implements Stateable,
Boxable {
    public double xmin;
    public double ymin;
    public double xmax;
    public double ymax;
    public double zmin;
    public double zmax;
    private Rect rBackup;

    public static Rect make(Point ... points) {
        return Rect.make(Arrays.asList(points));
    }

    public static Rect make(List<Point> points) {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        double zmin = Double.MAX_VALUE;
        double zmax = -1.7976931348623157E308;
        for (Point p : points) {
            xmin = xmin < p.v.x ? xmin : p.v.x;
            xmax = xmax > p.v.x ? xmax : p.v.x;
            ymin = ymin < p.v.y ? ymin : p.v.y;
            ymax = ymax > p.v.y ? ymax : p.v.y;
            zmin = zmin < p.v.z ? zmin : p.v.z;
            zmax = zmax > p.v.z ? zmax : p.v.z;
        }
        return new Rect(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    public Rect(double xmin, double ymin, double xmax, double ymax) {
        this(xmin, ymin, 0.0, xmax, ymax, 0.0);
    }

    public Rect(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.zmin = zmin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.zmax = zmax;
    }

    public double[] intersectLine(double x1, double y1, double x2, double y2) {
        double lambda2;
        double lambda1;
        Vec vRect = new Vec(x2 - x1, y2 - y1);
        if (x1 == this.xmin & x2 == this.xmin) {
            return new double[]{this.xmin, y1 < y2 ? this.ymin : this.ymax, this.xmin, y1 < y2 ? this.ymax : this.ymin};
        }
        if (x1 == this.xmax & x2 == this.xmax) {
            return new double[]{this.xmax, y1 < y2 ? this.ymin : this.ymax, this.xmax, y1 < y2 ? this.ymax : this.ymin};
        }
        if (y1 == this.ymin & y2 == this.ymin) {
            return new double[]{x1 < x2 ? this.xmin : this.xmax, this.ymin, x1 < x2 ? this.xmax : this.xmin, this.ymin};
        }
        if (y1 == this.ymax & y2 == this.ymax) {
            return new double[]{x1 < x2 ? this.xmin : this.xmax, this.ymax, x1 < x2 ? this.xmax : this.xmin, this.ymax};
        }
        double interx1 = this.xmin;
        double interx2 = this.xmax;
        double intery1 = this.ymin;
        double intery2 = this.ymax;
        Vec v1 = new Vec(this.xmin - x1, this.ymin - y1);
        Vec v2 = new Vec(this.xmin - x1, this.ymax - y1);
        Vec v3 = new Vec(this.xmax - x1, this.ymax - y1);
        Vec v4 = new Vec(this.xmax - x1, this.ymin - y1);
        double sc1 = vRect.cross((Vec)v1).z;
        double sc2 = vRect.cross((Vec)v2).z;
        double sc3 = vRect.cross((Vec)v3).z;
        double sc4 = vRect.cross((Vec)v4).z;
        if (sc1 < 0.0) {
            sc1 = -sc1;
            sc2 = -sc2;
            sc3 = -sc3;
            sc4 = -sc4;
        }
        if (sc1 > 0.0 & sc2 > 0.0 && sc3 > 0.0 && sc4 > 0.0) {
            return null;
        }
        if (sc1 > 0.0 & sc2 < 0.0 && sc3 < 0.0 && sc4 < 0.0) {
            lambda1 = (this.xmin - x1) / vRect.x;
            interx1 = this.xmin;
            intery1 = y1 + lambda1 * vRect.y;
            lambda2 = (this.ymin - y1) / vRect.y;
            interx2 = x1 + lambda2 * vRect.x;
            intery2 = this.ymin;
        }
        if (sc1 > 0.0 & sc2 < 0.0 && sc3 > 0.0 && sc4 > 0.0) {
            lambda1 = (this.xmin - x1) / vRect.x;
            interx1 = this.xmin;
            intery1 = y1 + lambda1 * vRect.y;
            lambda2 = (this.ymax - y1) / vRect.y;
            interx2 = x1 + lambda2 * vRect.x;
            intery2 = this.ymax;
        }
        if (sc1 > 0.0 & sc2 > 0.0 && sc3 < 0.0 && sc4 > 0.0) {
            lambda1 = (this.xmax - x1) / vRect.x;
            interx1 = this.xmax;
            intery1 = y1 + lambda1 * vRect.y;
            lambda2 = (this.ymax - y1) / vRect.y;
            interx2 = x1 + lambda2 * vRect.x;
            intery2 = this.ymax;
        }
        if (sc1 > 0.0 & sc2 > 0.0 && sc3 > 0.0 && sc4 < 0.0) {
            lambda1 = (this.xmax - x1) / vRect.x;
            interx1 = this.xmax;
            intery1 = y1 + lambda1 * vRect.y;
            lambda2 = (this.ymin - y1) / vRect.y;
            interx2 = x1 + lambda2 * vRect.x;
            intery2 = this.ymin;
        }
        if (sc1 > 0.0 & sc2 < 0.0 && sc3 < 0.0 && sc4 > 0.0) {
            lambda1 = (this.xmin - x1) / vRect.x;
            interx1 = this.xmin;
            intery1 = y1 + lambda1 * vRect.y;
            lambda2 = (this.xmax - x1) / vRect.x;
            interx2 = this.xmax;
            intery2 = y1 + lambda2 * vRect.y;
        }
        if (sc1 > 0.0 & sc2 > 0.0 && sc3 < 0.0 && sc4 < 0.0) {
            lambda1 = (this.ymin - y1) / vRect.y;
            interx1 = x1 + lambda1 * vRect.x;
            intery1 = this.ymin;
            lambda2 = (this.ymax - y1) / vRect.y;
            interx2 = x1 + lambda2 * vRect.x;
            intery2 = this.ymax;
        }
        if (sc4 == 0.0 & sc1 > 0.0 & sc2 > 0.0 && sc3 > 0.0) {
            return new double[]{this.xmax, this.ymin, this.xmax, this.ymin};
        }
        if (sc3 == 0.0 & sc1 > 0.0 & sc2 > 0.0 && sc4 > 0.0) {
            return new double[]{this.xmax, this.ymax, this.xmax, this.ymax};
        }
        if (sc2 == 0.0 & sc1 > 0.0 & sc3 > 0.0 && sc4 > 0.0) {
            return new double[]{this.xmin, this.ymax, this.xmin, this.ymax};
        }
        if (sc1 == 0.0 && sc2 > 0.0 & sc3 > 0.0 & sc4 > 0.0 | sc2 < 0.0 & sc3 < 0.0 & sc4 < 0.0) {
            return new double[]{this.xmin, this.ymin, this.xmin, this.ymin};
        }
        v1 = new Vec(interx1 - x1, intery1 - y1);
        v2 = new Vec(interx2 - x1, intery2 - y1);
        double[] resul = vRect.dot(v1) > 0.0 ? new double[]{interx2, intery2, interx1, intery1} : new double[]{interx1, intery1, interx2, intery2};
        return resul;
    }

    public static Rect union(Rect a, Rect b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Rect(Math.min(a.xmin, b.xmin), Math.min(a.ymin, b.ymin), Math.min(a.zmin, b.zmin), Math.max(a.xmax, b.xmax), Math.max(a.ymax, b.ymax), Math.max(a.zmax, b.zmax));
    }

    public Point getCenter() {
        return new Point(0.5 * (this.xmin + this.xmax), 0.5 * (this.ymin + this.ymax), 0.5 * (this.zmin + this.zmax));
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public String toString() {
        return "Rect{xmin=" + this.xmin + ", ymin=" + this.ymin + ", xmax=" + this.xmax + ", ymax=" + this.ymax + '}';
    }

    public Rect interpolate(Rect rDst, double t) {
        return new Rect((1.0 - t) * this.xmin + t * rDst.xmin, (1.0 - t) * this.ymin + t * rDst.ymin, (1.0 - t) * this.zmin + t * rDst.zmin, (1.0 - t) * this.xmax + t * rDst.xmax, (1.0 - t) * this.ymax + t * rDst.ymax, (1.0 - t) * this.zmax + t * rDst.zmax);
    }

    public Point getLeft() {
        return new Point(this.xmin, 0.5 * (this.ymin + this.ymax), 0.5 * (this.zmin + this.zmax));
    }

    public Point getRight() {
        return new Point(this.xmax, 0.5 * (this.ymin + this.ymax), 0.5 * (this.zmin + this.zmax));
    }

    public Point getUpper() {
        return new Point(0.5 * (this.xmin + this.xmax), this.ymax, 0.5 * (this.zmin + this.zmax));
    }

    public Point getLower() {
        return new Point(0.5 * (this.xmin + this.xmax), this.ymin, 0.5 * (this.zmin + this.zmax));
    }

    public Point getUL() {
        return new Point(this.xmin, this.ymax, 0.5 * (this.zmin + this.zmax));
    }

    public Point getUR() {
        return new Point(this.xmax, this.ymax, 0.5 * (this.zmin + this.zmax));
    }

    public Point getDL() {
        return new Point(this.xmin, this.ymin, 0.5 * (this.zmin + this.zmax));
    }

    public Point getDR() {
        return new Point(this.xmax, this.ymin, 0.5 * (this.zmin + this.zmax));
    }

    public Rect addGap(double xgap, double ygap) {
        return new Rect(this.xmin - xgap, this.ymin - ygap, this.zmin, this.xmax + xgap, this.ymax + ygap, this.zmax);
    }

    public Rect scale(double xs, double ys, double zs) {
        Point p = this.getCenter();
        double xminNew = p.v.x - 0.5 * this.getWidth() * xs;
        double xmaxNew = p.v.x + 0.5 * this.getWidth() * xs;
        double yminNew = p.v.y - 0.5 * this.getHeight() * ys;
        double ymaxNew = p.v.y + 0.5 * this.getHeight() * ys;
        double zminNew = p.v.z - 0.5 * this.getHeight() * zs;
        double zmaxNew = p.v.z + 0.5 * this.getHeight() * zs;
        return new Rect(xminNew, yminNew, zminNew, xmaxNew, ymaxNew, zmaxNew);
    }

    public Rect scale(double xs, double ys) {
        return this.scale(xs, ys, 1.0);
    }

    public Rect scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Rect shifted(Vec v) {
        return new Rect(this.xmin + v.x, this.ymin + v.y, this.zmin + v.z, this.xmax + v.x, this.ymax + v.y, this.zmax + v.z);
    }

    public void copyFrom(Rect r) {
        this.xmin = r.xmin;
        this.xmax = r.xmax;
        this.ymin = r.ymin;
        this.ymax = r.ymax;
        this.zmin = r.zmin;
        this.zmax = r.zmax;
    }

    @Override
    public void saveState() {
        this.rBackup = new Rect(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.rBackup.copyFrom(this);
    }

    @Override
    public void restoreState() {
        this.copyFrom(this.rBackup);
    }

    public Rect getRotatedRect(double rotateAngle) {
        Point center = this.getCenter();
        Point A = (Point)this.getUL().rotate(center, rotateAngle);
        Point B = (Point)this.getUR().rotate(center, rotateAngle);
        Point C = (Point)this.getDR().rotate(center, rotateAngle);
        Point D = (Point)this.getDL().rotate(center, rotateAngle);
        Rect r1 = Rect.make(A, C);
        Rect r2 = Rect.make(B, D);
        return Rect.union(r1, r2);
    }

    public Point getRelPoint(double relX, double relY) {
        return Point.at(this.xmin + relX * (this.xmax - this.xmin), this.ymin + relY * (this.ymax - this.ymin));
    }

    public Point getRelPoint3D(double relX, double relY, double relZ) {
        return Point.at(this.xmin + relX * (this.xmax - this.xmin), this.ymin + relY * (this.ymax - this.ymin), this.zmin + relZ * (this.zmax - this.zmin));
    }

    public Rect copy() {
        return new Rect(this.xmin, this.ymin, this.zmin, this.xmax, this.ymax, this.zmax);
    }

    public void centerAt(Point dstCenter) {
        Vec v = this.getCenter().to(dstCenter);
        this.xmin += v.x;
        this.xmax += v.x;
        this.ymin += v.y;
        this.ymax += v.y;
        this.zmin += v.z;
        this.zmax += v.z;
    }

    @Override
    public Rect getBoundingBox() {
        return this.copy();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Point getFromAnchor(Anchor.Type anchor) {
        switch (anchor) {
            case UPPER: {
                return this.getUpper();
            }
            case LOWER: {
                return this.getLower();
            }
            case LEFT: {
                return this.getLeft();
            }
            case RIGHT: {
                return this.getRight();
            }
            case UL: {
                return this.getUL();
            }
            case UR: {
                return this.getUR();
            }
            case DL: {
                return this.getDL();
            }
            case DR: {
                return this.getDR();
            }
            case CENTER: {
                return this.getCenter();
            }
        }
        return null;
    }
}

