/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.jmathanim.JMathAnimScene;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceLoader {
    JMathAnimConfig config = JMathAnimConfig.getConfig();

    public URL getResource(String resource, String folder) {
        if (resource.startsWith("!")) {
            return this.parseExternalAbsoluteResource(resource.substring(1));
        }
        if (resource.startsWith("#")) {
            return this.parseInternalResource(resource.substring(1), folder);
        }
        return this.parseExternalRelativeResource(resource, folder);
    }

    private URL parseExternalRelativeResource(String resource, String folder) {
        URL externalResource = null;
        String baseFileName = "";
        try {
            File resourcesDir = JMathAnimConfig.getConfig().getResourcesDir();
            baseFileName = resourcesDir.getCanonicalPath() + File.separator + folder + File.separator + resource;
            File file = new File(baseFileName);
            externalResource = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            JMathAnimScene.logger.error("Couldn't load resource " + baseFileName);
        }
        catch (IOException ex) {
            JMathAnimScene.logger.error("An unknown I/O error. Maybe you don't have permissionsto acces files on your working directory or simply this file doesn't exists at all!");
            JMathAnimScene.logger.error("Couldn't load resource " + baseFileName);
        }
        return externalResource;
    }

    private URL parseInternalResource(String resource, String folder) {
        String urlStr = folder + "/" + resource;
        return this.getClass().getClassLoader().getResource(urlStr);
    }

    private URL parseExternalAbsoluteResource(String resource) {
        URL externalResource = null;
        try {
            File file = new File(resource);
            externalResource = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ResourceLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ResourceLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return externalResource;
    }
}

