/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.PathUtils;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.SVGMathObject;
import com.jmathanim.mathobjects.Shape;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGUtils {
    private double currentX;
    private double currentY;
    private double closeX;
    private double closeY;
    private double previousX;
    private double previousY;
    private final AffineJTransform currentTransform;
    private final JMathAnimScene scene;

    public SVGUtils(JMathAnimScene scene) {
        this.scene = scene;
        this.currentX = 0.0;
        this.currentY = 0.0;
        this.closeX = 0.0;
        this.closeY = 0.0;
        this.previousX = 0.0;
        this.previousY = 0.0;
        this.currentTransform = new AffineJTransform();
    }

    public void importSVG(URL urlSvg, MultiShapeObject msh) throws Exception {
        JMathAnimScene.logger.debug("Importing SVG file {}", (Object)urlSvg.toString());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://xml.org/sax/features/namespaces", false);
        dbFactory.setFeature("http://xml.org/sax/features/validation", false);
        dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(urlSvg.openStream());
        this.processChildNodes(doc.getDocumentElement(), msh.getMp().getFirstMP(), this.currentTransform, msh);
    }

    private void processChildNodes(Element gNode, MODrawProperties localMP, AffineJTransform transform, MultiShapeObject msh) throws NumberFormatException {
        NodeList nList = gNode.getChildNodes();
        block16: for (int nchild = 0; nchild < nList.getLength(); ++nchild) {
            Node node = nList.item(nchild);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            MODrawProperties mpCopy = localMP.copy();
            this.processStyleAttributeCommands(el, mpCopy);
            AffineJTransform transfCopy = transform.copy();
            this.processTransformAttributeCommands(el, transfCopy);
            switch (el.getTagName()) {
                case "g": {
                    this.processChildNodes(el, mpCopy, transfCopy, msh);
                    continue block16;
                }
                case "path": {
                    Shape shape;
                    try {
                        JMPath path = this.processPathCommands(el.getAttribute("d"));
                        PathUtils pathUtils = new PathUtils();
                        pathUtils.determineStraightSegments(path);
                        if (path.jmPathPoints.size() <= 0) continue block16;
                        path.pathType = 2;
                        shape = new Shape(path, mpCopy);
                        transfCopy.applyTransform(shape);
                        msh.add(shape);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(SVGMathObject.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    continue block16;
                }
                case "rect": {
                    double x = Double.parseDouble(el.getAttribute("x"));
                    double y = -Double.parseDouble(el.getAttribute("y"));
                    double w = Double.parseDouble(el.getAttribute("width"));
                    double h = -Double.parseDouble(el.getAttribute("height"));
                    Shape shape = (Shape)Shape.rectangle(new Point(x, y), new Point(x + w, y + h)).setMp(mpCopy);
                    transfCopy.applyTransform(shape);
                    msh.add(shape);
                    continue block16;
                }
                case "circle": {
                    double cx = Double.parseDouble(el.getAttribute("cx"));
                    double cy = -Double.parseDouble(el.getAttribute("cy"));
                    double radius = Double.parseDouble(el.getAttribute("r"));
                    Shape shape = (Shape)((MathObject)((MathObject)Shape.circle().scale(radius)).shift(cx, cy)).setMp(mpCopy);
                    transfCopy.applyTransform(shape);
                    msh.add(shape);
                    continue block16;
                }
                case "ellipse": {
                    double cxe = Double.parseDouble(el.getAttribute("cx"));
                    double cye = -Double.parseDouble(el.getAttribute("cy"));
                    double rxe = Double.parseDouble(el.getAttribute("rx"));
                    double rye = -Double.parseDouble(el.getAttribute("ry"));
                    Shape shape = (Shape)((MathObject)((MathObject)Shape.circle().scale(rxe, rye)).shift(cxe, cye)).setMp(mpCopy);
                    transfCopy.applyTransform(shape);
                    msh.add(shape);
                }
            }
        }
    }

    private JMPath processPathCommands(String s) throws Exception {
        JMPath resul = new JMPath();
        JMPathPoint previousPoint = new JMPathPoint(new Point(0.0, 0.0), true, JMPathPoint.JMPathPointType.VERTEX);
        String t = s.replace("-", " -");
        t = t.replace("e -", "e-");
        t = t.replace("E -", "E-");
        t = t.replace("M", " M ");
        t = t.replace("m", " m ");
        t = t.replace("H", " H ");
        t = t.replace("h", " h ");
        t = t.replace("V", " V ");
        t = t.replace("v", " v ");
        t = t.replace("C", " C ");
        t = t.replace("c", " c ");
        t = t.replace("S", " S ");
        t = t.replace("s", " s ");
        t = t.replace("L", " L ");
        t = t.replace("l", " l ");
        t = t.replace("Z", " Z ");
        t = t.replace("z", " z ");
        t = t.replaceAll(",", " ");
        t = t.replaceAll("^ +| +$|( )+", "$1");
        String[] tokens_1 = t.split(" ");
        ArrayList<String> tokens = new ArrayList<String>();
        for (String tok : tokens_1) {
            StringBuilder st = new StringBuilder(tok);
            String tok2 = tok;
            int index = st.indexOf(".");
            if (index > -1 && st.indexOf(".", index + 1) > -1) {
                st.setCharAt(index, '|');
                tok2 = st.toString();
                tok2 = tok2.replace(".", " .");
                tok2 = tok2.replace("- .", "-.");
                tok2 = tok2.replace("|", ".");
            }
            tokens.addAll(Arrays.asList(tok2.split(" ")));
        }
        Iterator it = tokens.iterator();
        String previousCommand = "";
        this.currentX = 0.0;
        this.currentY = 0.0;
        previousPoint.p.v.x = 0.0;
        previousPoint.p.v.y = 0.0;
        block71: while (it.hasNext()) {
            double cy2;
            double cx2;
            double cy1;
            double yy;
            double xx;
            String token;
            switch (token = ((String)it.next()).trim()) {
                case "": {
                    continue block71;
                }
                case "A": {
                    throw new Exception("Arc command A still not implemented. Sorry.");
                }
                case "a": {
                    throw new Exception("Arc command a still not implemented. Sorry.");
                }
                case "Q": {
                    throw new Exception("Quadratic Bezier command Q still not implemented. Sorry.");
                }
                case "q": {
                    throw new Exception("Quadratic Bezier command q still not implemented. Sorry.");
                }
                case "M": {
                    previousCommand = token;
                    this.getPoint((String)it.next(), (String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, false);
                    this.closeX = this.currentX;
                    this.closeY = this.currentY;
                    previousPoint.isThisSegmentVisible = false;
                    continue block71;
                }
                case "m": {
                    previousCommand = token;
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    this.getPoint((String)it.next(), (String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    this.closeX = this.currentX;
                    this.closeY = this.currentY;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, false);
                    previousPoint.isThisSegmentVisible = false;
                    continue block71;
                }
                case "L": {
                    previousCommand = token;
                    this.getPoint((String)it.next(), (String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "l": {
                    previousCommand = token;
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    this.getPoint((String)it.next(), (String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "H": {
                    previousCommand = token;
                    this.getPointX((String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "h": {
                    previousCommand = token;
                    xx = previousPoint.p.v.x;
                    this.getPointX((String)it.next());
                    this.currentX += xx;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "V": {
                    previousCommand = token;
                    this.getPointY((String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "v": {
                    previousCommand = token;
                    yy = previousPoint.p.v.y;
                    this.getPointY((String)it.next());
                    this.currentY += yy;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "C": {
                    previousCommand = token;
                    double cx1 = Double.parseDouble((String)it.next());
                    cy1 = -Double.parseDouble((String)it.next());
                    cx2 = Double.parseDouble((String)it.next());
                    cy2 = -Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
                case "c": {
                    previousCommand = token;
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    double cx1 = xx + Double.parseDouble((String)it.next());
                    cy1 = yy - Double.parseDouble((String)it.next());
                    cx2 = xx + Double.parseDouble((String)it.next());
                    cy2 = yy - Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
                case "S": {
                    previousCommand = token;
                    double cx1 = previousPoint.p.v.x - (previousPoint.cpEnter.v.x - previousPoint.p.v.x);
                    cy1 = previousPoint.p.v.y - (previousPoint.cpEnter.v.y - previousPoint.p.v.y);
                    cx2 = Double.parseDouble((String)it.next());
                    cy2 = -Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
                case "s": {
                    previousCommand = token;
                    double cx1 = previousPoint.p.v.x - (previousPoint.cpEnter.v.x - previousPoint.p.v.x);
                    cy1 = previousPoint.p.v.y - (previousPoint.cpEnter.v.y - previousPoint.p.v.y);
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    cx2 = xx + Double.parseDouble((String)it.next());
                    cy2 = yy - Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
                case "Z": {
                    previousCommand = token;
                    previousPoint = this.pathLineTo(resul, this.closeX, this.closeY, true);
                    continue block71;
                }
                case "z": {
                    previousCommand = token;
                    previousPoint = this.pathLineTo(resul, this.closeX, this.closeY, true);
                    continue block71;
                }
            }
            if ("".equals(token.substring(0, 1))) continue;
            switch (previousCommand) {
                case "H": {
                    previousCommand = "H";
                    this.getPointX((String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "V": {
                    previousCommand = "V";
                    this.getPointY((String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "h": {
                    previousCommand = "h";
                    xx = previousPoint.p.v.x;
                    this.getPointX((String)it.next());
                    this.currentX += xx;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "v": {
                    previousCommand = "v";
                    yy = previousPoint.p.v.y;
                    this.getPointY((String)it.next());
                    this.currentY += yy;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "M": {
                    previousCommand = "L";
                    this.getPointX(token);
                    this.getPointY((String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "L": {
                    previousCommand = "L";
                    this.getPointX(token);
                    this.getPointY((String)it.next());
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "m": {
                    previousCommand = "l";
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    this.getPointX(token);
                    this.getPointY((String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "l": {
                    previousCommand = "l";
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    this.getPointX(token);
                    this.getPointY((String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    previousPoint = this.pathLineTo(resul, this.currentX, this.currentY, true);
                    continue block71;
                }
                case "C": {
                    double cx1 = Double.parseDouble(token);
                    cy1 = -Double.parseDouble((String)it.next());
                    cx2 = Double.parseDouble((String)it.next());
                    cy2 = -Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
                case "c": {
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    double cx1 = xx + Double.parseDouble(token);
                    cy1 = yy - Double.parseDouble((String)it.next());
                    cx2 = xx + Double.parseDouble((String)it.next());
                    cy2 = yy - Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
                case "S": {
                    double cx1 = previousPoint.p.v.x - (previousPoint.cpEnter.v.x - previousPoint.p.v.x);
                    cy1 = previousPoint.p.v.y - (previousPoint.cpEnter.v.y - previousPoint.p.v.y);
                    cx2 = Double.parseDouble(token);
                    cy2 = -Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
                case "s": {
                    double cx1 = previousPoint.p.v.x - (previousPoint.cpEnter.v.x - previousPoint.p.v.x);
                    cy1 = previousPoint.p.v.y - (previousPoint.cpEnter.v.y - previousPoint.p.v.y);
                    xx = previousPoint.p.v.x;
                    yy = previousPoint.p.v.y;
                    cx2 = xx + Double.parseDouble(token);
                    cy2 = yy - Double.parseDouble((String)it.next());
                    this.getPoint((String)it.next(), (String)it.next());
                    this.currentX += xx;
                    this.currentY += yy;
                    previousPoint = this.pathCubicBezier(resul, previousPoint, cx1, cy1, cx2, cy2, this.currentX, this.currentY);
                    continue block71;
                }
            }
            JMathAnimScene.logger.error("Unknow repeated command: <" + token + ">");
        }
        return resul;
    }

    private void getPoint(String x, String y) throws NumberFormatException {
        this.getPointX(x);
        this.getPointY(y);
    }

    private void getPointX(String x) throws NumberFormatException {
        this.previousX = this.currentX;
        this.currentX = Double.parseDouble(x);
    }

    private void getPointY(String y) throws NumberFormatException {
        this.previousY = this.currentY;
        this.currentY = -Double.parseDouble(y);
    }

    private JMPathPoint pathCubicBezier(JMPath path, JMPathPoint previousPoint, double cx1, double cy1, double cx2, double cy2, double x, double y) {
        JMPathPoint point = new JMPathPoint(new Point(this.currentX, this.currentY), true, JMPathPoint.JMPathPointType.VERTEX);
        point.isCurved = true;
        previousPoint.cpExit.v.x = cx1;
        previousPoint.cpExit.v.y = cy1;
        point.cpEnter.v.x = cx2;
        point.cpEnter.v.y = cy2;
        path.addJMPoint(point);
        return point;
    }

    private JMPathPoint pathLineTo(JMPath path, double currentX, double currentY, boolean isVisible) {
        JMPathPoint point = new JMPathPoint(new Point(currentX, currentY), isVisible, JMPathPoint.JMPathPointType.VERTEX);
        point.isCurved = false;
        point.cpExit.v.x = currentX;
        point.cpExit.v.y = currentY;
        point.cpEnter.v.x = currentX;
        point.cpEnter.v.y = currentY;
        path.addJMPoint(point);
        return point;
    }

    private void processStyleAttributeCommands(Element el, MODrawProperties ShMp) {
        if (!"".equals(el.getAttribute("style"))) {
            this.parseStyleAttribute(el.getAttribute("style"), ShMp);
        }
        if (!"".equals(el.getAttribute("stroke"))) {
            JMColor strokeColor = JMColor.parse(el.getAttribute("stroke"));
            ShMp.setDrawColor(strokeColor);
        }
        if (!"".equals(el.getAttribute("stroke-width"))) {
            double th = Double.parseDouble(el.getAttribute("stroke-width"));
            double th2 = this.scene.getRenderer().MathWidthToThickness(th);
            ShMp.setThickness(th2);
        }
        if (!"".equals(el.getAttribute("fill"))) {
            JMColor fillColor = JMColor.parse(el.getAttribute("fill"));
            ShMp.setFillColor(fillColor);
        }
    }

    private void processTransformAttributeCommands(Element el, AffineJTransform currentTransform) {
        if (!"".equals(el.getAttribute("transform"))) {
            this.parseTransformAttribute(el.getAttribute("transform"), currentTransform);
        }
    }

    private void parseStyleAttribute(String str, MODrawProperties ShMp) {
        String[] decls;
        block10: for (String pairs : decls = str.split(";")) {
            String[] decl = pairs.split(":");
            switch (decl[0]) {
                case "fill": {
                    JMColor fillColor = JMColor.parse(decl[1]);
                    ShMp.setFillColor(fillColor);
                    continue block10;
                }
                case "stroke": {
                    JMColor strokeColor = JMColor.parse(decl[1]);
                    ShMp.setDrawColor(strokeColor);
                    continue block10;
                }
                case "stroke-width": {
                    double th = Double.parseDouble(decl[1]);
                    double th2 = this.scene.getRenderer().MathWidthToThickness(th);
                    ShMp.setThickness(th2);
                }
            }
        }
    }

    private AffineJTransform parseTransformAttribute(String trans, AffineJTransform currentTransform) {
        ArrayList<AffineJTransform> transforms = new ArrayList<AffineJTransform>();
        String delims = "[()]+";
        String[] tokens = trans.split(delims);
        Iterator it = Arrays.stream(tokens).iterator();
        while (it.hasNext()) {
            String command = (String)it.next();
            String arguments = (String)it.next();
            AffineJTransform tr = this.parseCommand(command.toUpperCase(), arguments);
            transforms.add(0, tr);
        }
        AffineJTransform resul = currentTransform.copy();
        for (AffineJTransform tr : transforms) {
            resul = tr.compose(resul);
        }
        currentTransform.copyFrom(resul);
        return resul;
    }

    private AffineJTransform parseCommand(String command, String arguments) {
        AffineJTransform resul = new AffineJTransform();
        String argDelims = "[ ,]+";
        String[] args = arguments.split(argDelims);
        switch (command) {
            case "MATRIX": {
                double a = Double.parseDouble(args[0]);
                double b = Double.parseDouble(args[1]);
                double c = Double.parseDouble(args[2]);
                double d = Double.parseDouble(args[3]);
                double e = Double.parseDouble(args[4]);
                double f = Double.parseDouble(args[5]);
                resul.setOriginImg(e, f);
                resul.setV1Img(a, b);
                resul.setV2Img(c, d);
                break;
            }
            case "TRANSLATE": {
                double b;
                double a = Double.parseDouble(args[0]);
                try {
                    b = Double.parseDouble(args[1]);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b = 0.0;
                }
                resul.setOriginImg(a, b);
                resul.setV1Img(1.0, 0.0);
                resul.setV2Img(0.0, 1.0);
                break;
            }
            case "SCALE": {
                double b;
                double a = Double.parseDouble(args[0]);
                try {
                    b = Double.parseDouble(args[1]);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b = a;
                }
                resul = AffineJTransform.createScaleTransform(Point.origin(), a, b);
                break;
            }
            case "ROTATE": {
                double c;
                double b;
                double a = Double.parseDouble(args[0]);
                try {
                    b = Double.parseDouble(args[1]);
                    c = Double.parseDouble(args[2]);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    b = 0.0;
                    c = 0.0;
                }
                resul = AffineJTransform.create2DRotationTransform(Point.at(b, c), a * (Math.PI / 180));
                break;
            }
            case "SKEWX": {
                double a = 1.0;
                double b = 0.0;
                double c = Math.tan(Double.parseDouble(args[0]) * (Math.PI / 180));
                double d = 1.0;
                double e = 0.0;
                double f = 0.0;
                resul.setOriginImg(e, f);
                resul.setV1Img(a, b);
                resul.setV2Img(c, d);
                break;
            }
            case "SKEWY": {
                double a = 1.0;
                double b = Math.tan(Double.parseDouble(args[0]) * (Math.PI / 180));
                double c = 0.0;
                double d = 1.0;
                double e = 0.0;
                double f = 0.0;
                resul.setOriginImg(e, f);
                resul.setV1Img(a, b);
                resul.setV2Img(c, d);
            }
        }
        AffineJTransform sc1 = AffineJTransform.createScaleTransform(Point.origin(), 1.0, -1.0);
        AffineJTransform sc2 = AffineJTransform.createScaleTransform(Point.origin(), 1.0, -1.0);
        resul = sc1.compose(resul).compose(sc2);
        return resul;
    }
}

