/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import java.util.function.DoubleUnaryOperator;

public class UsefulLambdas {
    public static DoubleUnaryOperator bounce1() {
        return UsefulLambdas.bounce1(2.2, 4.0);
    }

    private static DoubleUnaryOperator bounce1(double a, double b) {
        final double aa = a;
        final double aaRoot = 1.0 / Math.sqrt(a);
        final double bb = b;
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                if (t < aaRoot) {
                    return aa * t * t;
                }
                return 1.0 + bb * (t - aaRoot) * (t - 1.0);
            }
        };
    }

    public static DoubleUnaryOperator bounce2() {
        return UsefulLambdas.bounce2(2.5, 8.0);
    }

    private static DoubleUnaryOperator bounce2(double a, double b) {
        final double aa = a;
        final double aaRoot1 = 1.0 / Math.sqrt(a);
        final double aaRoot2 = (2.0 - aaRoot1) * aaRoot1;
        final double bb = b;
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                if (t < aaRoot1) {
                    return aa * t * t;
                }
                if (t < aaRoot2) {
                    return 1.0 + bb * (t - aaRoot1) * (t - aaRoot2);
                }
                return 1.0 + bb * (t - 1.0) * (t - aaRoot2);
            }
        };
    }

    public static DoubleUnaryOperator backAndForthLinear() {
        return UsefulLambdas.backAndForthLinear(0.5);
    }

    public static DoubleUnaryOperator backAndForthLinear(final double percentage) {
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                if (t < percentage) {
                    return t / percentage;
                }
                return 1.0 - (t - percentage) / (1.0 - percentage);
            }
        };
    }

    public static DoubleUnaryOperator backAndForth() {
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                return 4.0 * t * (1.0 - t);
            }
        };
    }

    public static DoubleUnaryOperator backAndForthBounce1() {
        return UsefulLambdas.backAndForthBounce1(0.7, 1.0);
    }

    private static DoubleUnaryOperator backAndForthBounce1(final double a, double b) {
        double aa = a;
        final double bb = b * 4.0 / (a * a);
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                if (t < a) {
                    return bb * t * (a - t);
                }
                return (a - t) * (t - 1.0) * bb;
            }
        };
    }

    public static DoubleUnaryOperator backAndForthBounce2() {
        return UsefulLambdas.backAndForthBounce2(0.7, 1.0);
    }

    private static DoubleUnaryOperator backAndForthBounce2(final double a, double b) {
        final double norm = b * 4.0 / (a * a);
        final double c = a + a * (1.0 - a);
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                if (t < a) {
                    return Math.min(1.0, norm * t * (a - t));
                }
                if (t < c) {
                    return Math.min(1.0, (a - t) * (t - c) * norm);
                }
                return Math.min(1.0, (c - t) * (t - 1.0) * norm);
            }
        };
    }

    public static DoubleUnaryOperator smooth() {
        return UsefulLambdas.smooth(0.9);
    }

    public static DoubleUnaryOperator smooth(final double smoothness) {
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                double h = t == 0.0 ? 0.0 : Math.exp(-1.0 / t);
                double h2 = t == 1.0 ? 0.0 : Math.exp(-1.0 / (1.0 - t));
                return (1.0 - smoothness) * t + smoothness * h / (h + h2);
            }
        };
    }

    public static DoubleUnaryOperator allocateTo(final double a, final double b) {
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                if (t < a) {
                    return 0.0;
                }
                if (t > b) {
                    return 1.0;
                }
                return (t - a) / (b - a);
            }
        };
    }

    public static DoubleUnaryOperator restrictTo(final double a, final double b) {
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                return t * (b - a) + a;
            }
        };
    }

    public static DoubleUnaryOperator reverse() {
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                return 1.0 - t;
            }
        };
    }

    public static DoubleUnaryOperator clone(final int cloneNumber) {
        return new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double t) {
                return t * (double)cloneNumber - Math.floor(t * (double)cloneNumber);
            }
        };
    }
}

