/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Utils;

import com.jmathanim.mathobjects.Stateable;

public class Vec
implements Stateable {
    public double x;
    public double y;
    public double z;
    public double xState;
    public double yState;
    public double zState;

    public Vec(double[] xy) {
        this(xy[0], xy[1]);
    }

    public Vec(double x, double y) {
        this(x, y, 0.0);
    }

    public Vec(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double dot(Vec b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public Vec cross(Vec b) {
        return new Vec(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public Vec multInSite(double lambda) {
        this.x *= lambda;
        this.y *= lambda;
        this.z *= lambda;
        return this;
    }

    public Vec mult(double lambda) {
        return this.copy().multInSite(lambda);
    }

    public Vec addInSite(Vec b) {
        this.x += b.x;
        this.y += b.y;
        this.z += b.z;
        return this;
    }

    public Vec minusInSite(Vec b) {
        this.x -= b.x;
        this.y -= b.y;
        this.z -= b.z;
        return this;
    }

    public Vec minus(Vec b) {
        return this.copy().minusInSite(b);
    }

    public Vec add(Vec b) {
        return this.copy().addInSite(b);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec interpolate(Vec v2, double alpha) {
        return new Vec((1.0 - alpha) * this.x + alpha * v2.x, (1.0 - alpha) * this.y + alpha * v2.y, (1.0 - alpha) * this.z + alpha * v2.z);
    }

    public Vec copy() {
        Vec resul = new Vec(this.x, this.y, this.z);
        return resul;
    }

    public void copyFrom(Vec v) {
        if (v != null) {
            this.x = v.x;
            this.y = v.y;
            this.z = v.z;
        }
    }

    @Override
    public void saveState() {
        this.xState = this.x;
        this.yState = this.y;
        this.zState = this.z;
    }

    @Override
    public void restoreState() {
        this.x = this.xState;
        this.y = this.yState;
        this.z = this.zState;
    }

    public double getAngle() {
        double angle;
        for (angle = Math.atan2(this.y, this.x); angle < 0.0; angle += Math.PI * 2) {
        }
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public Vec rotateInSite(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double a = this.x;
        double b = this.y;
        this.x = c * a - s * b;
        this.y = s * a + c * b;
        return this;
    }

    public Vec rotate(double angle) {
        return this.copy().rotateInSite(angle);
    }

    public double getAngleFirstQuad() {
        double angle = Math.atan(this.y / this.x);
        return angle;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec other = (Vec)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "Vec(" + this.x + ", " + this.y + ')';
    }

    public static Vec to(double x, double y, double z) {
        return new Vec(x, y, z);
    }

    public static Vec to(double x, double y) {
        return new Vec(x, y);
    }

    public Vec normalize() {
        double norm = this.norm();
        if (norm > 0.0) {
            return this.mult(1.0 / norm);
        }
        return this;
    }
}

