/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.jmathanim;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.PlayAnim;
import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Shape;
import com.jmathanim.mathobjects.Text.LaTeXMathObject;
import com.jmathanim.mathobjects.updateableObjects.Updateable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMathAnimScene {
    public static final Logger logger = LoggerFactory.getLogger((String)"com.jmathanim.jmathanim.JMathAnimScene");
    public static final double PI = Math.PI;
    public static final double GOLDEN_RATIO = 1.618033988749895;
    public static final double DEGREES = Math.PI / 180;
    private final ArrayList<MathObject> sceneObjects = new ArrayList();
    private final HashSet<MathObject> objectsAlreadyDrawed = new HashSet();
    final ArrayList<Updateable> objectsToBeUpdated;
    final ArrayList<MathObject> objectsToBeRemoved;
    protected Renderer renderer;
    protected int frameCount;
    protected double fps;
    protected double dt;
    public JMathAnimConfig config = JMathAnimConfig.getConfig();
    protected final PlayAnim play;
    public long nanoTime;
    public long previousNanoTime;
    private int exitCode;
    private boolean animationIsDisabled;

    public Renderer getRenderer() {
        return this.renderer;
    }

    public JMathAnimScene() {
        this.config.setLowQuality();
        this.objectsToBeUpdated = new ArrayList();
        this.objectsToBeRemoved = new ArrayList();
        this.play = new PlayAnim(this);
        this.config.setOutputFileName(this.getClass().getSimpleName());
        this.animationIsDisabled = false;
    }

    public abstract void setupSketch();

    abstract void createRenderer();

    public final int execute() {
        String sketchName = this.getClass().getName();
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        try {
            URL url = this.getClass().getClassLoader().getResource("logback.xml");
            configurator.doConfigure(url);
        }
        catch (JoranException ex) {
            java.util.logging.Logger.getLogger(JMathAnimScene.class.getName()).log(Level.SEVERE, null, ex);
        }
        logger.info("Running sketch {} ", (Object)sketchName);
        this.setupSketch();
        this.createRenderer();
        JMathAnimConfig.getConfig().setRenderer(this.renderer);
        this.exitCode = 0;
        this.config.setScene(this);
        try {
            this.runSketch();
            this.renderer.finish(this.frameCount);
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(JMathAnimScene.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.exitCode != 0) {
            logger.error("An error ocurred. Check the logs.");
        }
        return this.exitCode;
    }

    public ArrayList<MathObject> getObjects() {
        return this.sceneObjects;
    }

    public MathObject[] everything() {
        MathObject[] arr = new MathObject[this.sceneObjects.size()];
        for (int n = 0; n < this.sceneObjects.size(); ++n) {
            arr[n] = this.sceneObjects.get(n);
        }
        return arr;
    }

    public ArrayList<Updateable> getObjectsToBeUpdated() {
        return this.objectsToBeUpdated;
    }

    public abstract void runSketch() throws Exception;

    public final synchronized void registerUpdateable(Updateable ... objs) {
        for (Updateable obj : objs) {
            if (this.objectsToBeUpdated.contains(obj)) continue;
            this.objectsToBeUpdated.add(obj);
        }
    }

    public final synchronized void unregisterUpdateable(Updateable ... objs) {
        this.objectsToBeUpdated.removeAll(Arrays.asList(objs));
    }

    public void addOnce(MathObject ... objs) {
        this.add(objs);
        this.objectsToBeRemoved.addAll(Arrays.asList(objs));
    }

    public final synchronized void add(MathObject ... objs) {
        for (MathObject obj : objs) {
            if (obj == null) continue;
            if (!this.sceneObjects.contains(obj)) {
                if (obj instanceof MathObjectGroup) {
                    for (MathObject subobj : ((MathObjectGroup)obj).getObjects()) {
                        this.add(subobj);
                    }
                } else if (obj instanceof MultiShapeObject) {
                    this.sceneObjects.add(obj);
                } else {
                    this.sceneObjects.add(obj);
                }
            }
            this.registerUpdateable(obj);
            obj.addToSceneHook(this);
        }
    }

    public final synchronized void remove(ArrayList<MathObject> objs) {
        this.remove(objs.toArray(new MathObject[objs.size()]));
    }

    public final synchronized void remove(MathObject ... objs) {
        for (MathObject obj : objs) {
            MathObject o;
            Iterator<MathObject> iterator;
            MathObject msh;
            if (obj instanceof MultiShapeObject) {
                this.sceneObjects.remove(obj);
                this.unregisterUpdateable(obj);
                msh = (MultiShapeObject)obj;
                ((MultiShapeObject)msh).isAddedToScene = false;
                iterator = ((MultiShapeObject)msh).iterator();
                while (iterator.hasNext()) {
                    o = (Shape)iterator.next();
                    this.remove(o);
                }
            }
            if (obj instanceof MathObjectGroup) {
                msh = (MathObjectGroup)obj;
                iterator = ((MathObjectGroup)msh).iterator();
                while (iterator.hasNext()) {
                    o = iterator.next();
                    this.remove(o);
                }
            }
            this.sceneObjects.remove(obj);
            this.unregisterUpdateable(obj);
        }
    }

    protected final void doDraws() {
        this.objectsAlreadyDrawed.clear();
        this.doUpdates();
        if (!this.animationIsDisabled) {
            this.sceneObjects.sort((o1, o2) -> o1.getLayer() - o2.getLayer());
            for (MathObject obj : this.sceneObjects) {
                if (!obj.isVisible() || this.isAlreadyDrawed(obj)) continue;
                obj.draw(this, this.renderer);
                this.markAsAlreadyDrawed(obj);
            }
        }
        this.remove(this.objectsToBeRemoved.toArray(new MathObject[this.objectsToBeRemoved.size()]));
        this.objectsToBeRemoved.clear();
    }

    private void doUpdates() {
        this.objectsToBeUpdated.sort((o1, o2) -> o1.getUpdateLevel() - o2.getUpdateLevel());
        ArrayList<Updateable> updatesCopy = new ArrayList<Updateable>();
        updatesCopy.addAll(this.objectsToBeUpdated);
        for (Updateable obj : updatesCopy) {
            obj.update(this);
        }
    }

    public final void advanceFrame() {
        if (!this.animationIsDisabled) {
            this.renderer.clear();
        }
        this.doDraws();
        if (!this.animationIsDisabled) {
            ++this.frameCount;
            this.saveMPFrame();
            this.previousNanoTime = this.nanoTime;
            this.nanoTime = System.nanoTime();
        }
    }

    private void saveMPFrame() {
        try {
            this.renderer.saveFrame(this.frameCount);
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(JMathAnimScene.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void playAnimation(Animation ... anims) {
        ArrayList<Animation> animArray = new ArrayList<Animation>();
        animArray.addAll(Arrays.asList(anims));
        this.playAnimation(animArray);
    }

    public void playAnimation(ArrayList<Animation> anims) {
        for (Animation anim : anims) {
            if (anim == null) continue;
            if (anim.getStatus() == Animation.Status.FINISHED) {
                anim.setStatus(Animation.Status.NOT_INITIALIZED);
            }
            anim.initialize(this);
            if (!"".equals(anim.getDebugName())) {
                logger.info("Begin animation: " + anim.getDebugName());
            }
            if (!this.animationIsDisabled) continue;
            anim.setT(1.0);
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            for (Animation anim : anims) {
                if (anim == null) continue;
                boolean resultAnimation = anim.processAnimation();
                finished &= resultAnimation;
                if (!resultAnimation) continue;
                anim.finishAnimation();
            }
            this.advanceFrame();
        }
    }

    public void waitSeconds(double time) {
        if (this.animationIsDisabled) {
            return;
        }
        logger.info("Waiting " + time + " seconds");
        int numFrames = (int)(time * this.fps);
        for (int n = 0; n < numFrames; ++n) {
            try {
                this.advanceFrame();
                continue;
            }
            catch (Exception ex) {
                java.util.logging.Logger.getLogger(JMathAnimScene.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Camera getCamera() {
        return this.renderer.getCamera();
    }

    public Camera getFixedCamera() {
        return this.renderer.getFixedCamera();
    }

    public void formulaHelper(String ... formulas) {
        LaTeXMathObject[] texes = new LaTeXMathObject[formulas.length];
        int n = 0;
        for (String t : formulas) {
            LaTeXMathObject lat;
            texes[n] = lat = LaTeXMathObject.make(t);
            ++n;
        }
        this.formulaHelper(texes);
    }

    public void formulaHelper(LaTeXMathObject ... texes) {
        MathObjectGroup group = new MathObjectGroup();
        for (LaTeXMathObject lat : texes) {
            int k = 0;
            for (Shape sh : lat) {
                sh.debugText("" + k);
                ++k;
            }
            group.add((MathObject)lat);
        }
        group.setLayout(MathObjectGroup.Layout.LOWER, 0.2);
        ((Camera)this.renderer.getCamera()).zoomToObjects(group);
        this.add(group);
    }

    public JMathAnimConfig getConfig() {
        return this.config;
    }

    public void disableAnimations() {
        this.animationIsDisabled = true;
    }

    public void enableAnimations() {
        this.animationIsDisabled = false;
    }

    public Rect getMathView() {
        return ((Camera)this.renderer.getCamera()).getMathView();
    }

    public double getViewWidth() {
        return this.getMathView().getWidth();
    }

    public double getViewHeight() {
        return this.getMathView().getHeight();
    }

    public MathObject[] getObjectsFromLayers(int ... layers) {
        ArrayList<Integer> arLayers = new ArrayList<Integer>();
        for (int k : layers) {
            arLayers.add(k);
        }
        MathObject[] resul = (MathObject[])this.getObjects().stream().filter(obj -> arLayers.contains(obj.getLayer())).toArray(MathObject[]::new);
        return resul;
    }

    public boolean isAlreadyDrawed(MathObject obj) {
        return this.objectsAlreadyDrawed.contains(obj);
    }

    public void markAsAlreadyDrawed(MathObject obj) {
        this.objectsAlreadyDrawed.add(obj);
    }

    public void reset() {
        for (MathObject obj : this.getObjects().toArray(new MathObject[this.getObjects().size()])) {
            this.remove(obj);
        }
        for (Updateable upd : this.getObjectsToBeUpdated().toArray(new Updateable[this.getObjectsToBeUpdated().size()])) {
            this.unregisterUpdateable(upd);
        }
        ((Camera)this.renderer.getCamera()).reset();
    }
}

