/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import javafx.scene.image.Image;

public abstract class AbstractJMImage
extends MathObject {
    public Rect bbox;
    public boolean preserveRatio = false;
    public double rotateAngle = 0.0;
    public double rotateAngleBackup = 0.0;
    private boolean cached = false;

    @Override
    public Rect getBoundingBox() {
        return this.bbox.getRotatedRect(this.rotateAngle);
    }

    @Override
    public <T extends MathObject> T shift(Vec shiftVector) {
        this.bbox.copyFrom(this.bbox.shifted(shiftVector));
        return (T)this;
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible()) {
            r.drawImage(this);
        }
        scene.markAsAlreadyDrawed(this);
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public abstract String getId();

    public abstract Image getImage();
}

