/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.ResourceLoader;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.SVGMathObject;
import com.jmathanim.mathobjects.Shape;
import java.net.URL;

public class Arrow2D
extends MathObject {
    private final MODrawPropertiesArray mpArray;
    private MultiShapeObject arrowHeadToDraw1;
    private MultiShapeObject arrowHeadToDraw2;
    private Shape bodyToDraw;
    private double scaleFactorHead1;
    private double scaleFactorHead2;
    private double scaleFactorHead1Backup;
    private double scaleFactorHead2Backup;
    private int anchorPoint1;
    private int anchorPoint2;
    private final ArrowType type1;
    private final ArrowType type2;
    private final Point p1;
    private final Point p2;
    private final Shape body;
    public ArrowType arrowType = ArrowType.TYPE_1;
    private final MultiShapeObject head1;
    private final MultiShapeObject head2;
    private double defaultArrowHead1Size1 = 0.015;
    private double defaultArrowHead1Size2 = 0.015;

    public static Arrow2D makeSimpleArrow2D(Point p1, Point p2) {
        return Arrow2D.makeSimpleArrow2D(p1, p2, ArrowType.TYPE_1);
    }

    public static Arrow2D makeSimpleArrow2D(Point p1, Point p2, ArrowType type) {
        return new Arrow2D(p1, p2, type, ArrowType.NONE);
    }

    public static Arrow2D makeDoubleArrow2D(Point p1, Point p2, ArrowType type1, ArrowType type2) {
        return new Arrow2D(p1, p2, type1, type2);
    }

    private Arrow2D(Point p1, Point p2, ArrowType type1, ArrowType type2) {
        this.type1 = type1;
        this.type2 = type2;
        this.p1 = p1;
        this.p2 = p2;
        this.body = Shape.segment(p1, p2);
        this.head1 = this.buildArrowHead(type1, 1);
        this.head2 = this.buildArrowHead(type2, 2);
        this.body.objectLabel = "body";
        this.head1.objectLabel = "head1";
        this.head2.objectLabel = "head2";
        this.head1.drawColor(this.body.getMp().getDrawColor());
        this.head1.fillColor(this.body.getMp().getDrawColor());
        this.scaleArrowHead1(1.0);
        this.head2.drawColor(this.body.getMp().getDrawColor());
        this.head2.fillColor(this.body.getMp().getDrawColor());
        this.scaleArrowHead2(1.0);
        this.mpArray = new MODrawPropertiesArray();
        this.mpArray.add(this.head1);
        this.mpArray.add(this.head2);
        this.mpArray.add(this.body);
    }

    private MultiShapeObject buildArrowHead(ArrowType type, int side) {
        double scaleDefaultValue;
        int anchorValue;
        switch (type) {
            case TYPE_1: {
                anchorValue = 2;
                scaleDefaultValue = 1.5;
                break;
            }
            case TYPE_2: {
                anchorValue = 7;
                scaleDefaultValue = 1.5;
                break;
            }
            case TYPE_3: {
                anchorValue = 7;
                scaleDefaultValue = 1.0;
                break;
            }
            default: {
                anchorValue = 2;
                scaleDefaultValue = 1.5;
            }
        }
        if (side == 1) {
            this.anchorPoint1 = anchorValue;
            this.defaultArrowHead1Size1 *= scaleDefaultValue;
        } else {
            this.anchorPoint2 = anchorValue;
            this.defaultArrowHead1Size2 *= scaleDefaultValue;
        }
        MultiShapeObject resul = Arrow2D.buildArrowHead(type);
        resul.getMp().copyFrom(this.getMp());
        resul.thickness(4.0);
        return resul;
    }

    public static MultiShapeObject buildArrowHead(ArrowType type) {
        MultiShapeObject head;
        String name = "#arrow";
        if (type != ArrowType.NONE) {
            switch (type) {
                case TYPE_1: {
                    name = name + "1";
                    break;
                }
                case TYPE_2: {
                    name = name + "2";
                    break;
                }
                case TYPE_3: {
                    name = name + "3";
                    break;
                }
                default: {
                    name = name + "1";
                }
            }
            name = name + ".svg";
            try {
                ResourceLoader rl = new ResourceLoader();
                URL arrowUrl = rl.getResource(name, "arrows");
                head = new SVGMathObject(arrowUrl);
            }
            catch (NullPointerException ex) {
                JMathAnimScene.logger.error("Arrow head " + name + " not found");
                head = new MultiShapeObject();
            }
        } else {
            head = new MultiShapeObject();
        }
        return head;
    }

    public Shape getBody() {
        return this.body;
    }

    public MultiShapeObject getArrowHead1() {
        this.update(JMathAnimConfig.getConfig().getScene());
        return this.arrowHeadToDraw1;
    }

    public MultiShapeObject getArrowHead2() {
        this.update(JMathAnimConfig.getConfig().getScene());
        return this.arrowHeadToDraw2;
    }

    public Point getStart() {
        return this.p1;
    }

    public Point getEnd() {
        return this.p2;
    }

    public final <T extends Arrow2D> T scaleArrowHead1(double sc) {
        this.scaleFactorHead1 = sc;
        return (T)this;
    }

    public final <T extends Arrow2D> T scaleArrowHead2(double sc) {
        this.scaleFactorHead2 = sc;
        return (T)this;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.getMp().restoreState();
        this.body.restoreState();
        this.head1.restoreState();
        this.head2.restoreState();
        this.scaleFactorHead1 = this.scaleFactorHead1Backup;
        this.scaleFactorHead2 = this.scaleFactorHead2Backup;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.getMp().saveState();
        this.body.saveState();
        this.head1.saveState();
        this.head2.saveState();
        this.scaleFactorHead1Backup = this.scaleFactorHead1;
        this.scaleFactorHead2Backup = this.scaleFactorHead2;
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        this.updateDrawableParts();
        if (this.isVisible()) {
            this.bodyToDraw.draw(scene, r);
            this.arrowHeadToDraw1.draw(scene, r);
            this.arrowHeadToDraw2.draw(scene, r);
        }
        scene.markAsAlreadyDrawed(this);
    }

    @Override
    public void update(JMathAnimScene scene) {
        this.scene = scene;
        this.updateDrawableParts();
    }

    protected void updateDrawableParts() {
        JMPathPoint pa;
        AffineJTransform tr;
        double angle;
        Vec v;
        Point headPoint;
        double mw;
        this.bodyToDraw = this.body.copy();
        this.arrowHeadToDraw1 = this.head1.copy();
        this.arrowHeadToDraw2 = this.head2.copy();
        if (this.head1.size() > 0) {
            mw = this.scene.getCamera().getMathView().getHeight();
            double sc1 = this.scaleFactorHead1 * this.defaultArrowHead1Size1 * mw / this.head1.getBoundingBox().getHeight();
            this.arrowHeadToDraw1.scale(sc1);
            headPoint = this.arrowHeadToDraw1.getBoundingBox().getUpper();
            this.arrowHeadToDraw1.shift(headPoint.to(this.p2));
            v = this.p1.to(this.p2);
            angle = v.getAngle();
            tr = AffineJTransform.create2DRotationTransform(this.p2, -1.5707963267948966 + angle);
            tr.applyTransform(this.arrowHeadToDraw1);
            pa = this.bodyToDraw.get(1);
            pa.p.v.copyFrom(this.arrowHeadToDraw1.get((int)0).get((int)this.anchorPoint1).p.v);
            this.arrowHeadToDraw1.drawColor(this.getMp().getDrawColor());
            this.arrowHeadToDraw1.fillColor(this.getMp().getDrawColor());
        }
        if (this.head2.size() > 0) {
            mw = JMathAnimConfig.getConfig().getCamera().getMathView().getHeight();
            double sc2 = this.scaleFactorHead2 * this.defaultArrowHead1Size2 * mw / this.head2.getBoundingBox().getHeight();
            this.arrowHeadToDraw2.scale(sc2);
            headPoint = this.arrowHeadToDraw2.getBoundingBox().getUpper();
            this.arrowHeadToDraw2.shift(headPoint.to(this.p1));
            v = this.p2.to(this.p1);
            angle = v.getAngle();
            tr = AffineJTransform.create2DRotationTransform(this.p1, -1.5707963267948966 + angle);
            tr.applyTransform(this.arrowHeadToDraw2);
            pa = this.bodyToDraw.get(0);
            pa.p.v.copyFrom(this.arrowHeadToDraw2.get((int)0).get((int)this.anchorPoint2).p.v);
            this.arrowHeadToDraw2.drawColor(this.getMp().getDrawColor());
            this.arrowHeadToDraw2.fillColor(this.getMp().getDrawColor());
        }
    }

    @Override
    public <T extends MathObject> T scale(Point scaleCenter, double sx, double sy, double sz) {
        this.body.scale(scaleCenter, sx, sy, sz);
        return (T)this;
    }

    @Override
    public <T extends MathObject> T shift(Vec shiftVector) {
        this.body.shift(shiftVector);
        return (T)this;
    }

    @Override
    public <T extends MathObject> T copy() {
        Arrow2D copy = new Arrow2D(this.p1.copy(), this.p2.copy(), this.type1, this.type2);
        copy.head1.getMp().copyFrom(this.head1.getMp());
        copy.head2.getMp().copyFrom(this.head2.getMp());
        copy.body.getMp().copyFrom(this.body.getMp());
        return (T)copy;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof Arrow2D)) {
            return;
        }
        Arrow2D ar = (Arrow2D)obj;
        this.getMp().copyFrom(ar.getMp());
        this.p1.copyStateFrom(ar.p1);
        this.p2.copyStateFrom(ar.p2);
        this.head1.copyStateFrom(ar.head1);
        this.head2.copyStateFrom(ar.head2);
        this.body.copyStateFrom(ar.body);
    }

    @Override
    public <T extends MathObject> T thickness(double th) {
        this.body.thickness(th);
        return (T)this;
    }

    @Override
    public Rect getBoundingBox() {
        this.updateDrawableParts();
        Rect r = this.body.getBoundingBox();
        this.update(JMathAnimConfig.getConfig().getScene());
        if (this.arrowHeadToDraw1.size() > 0) {
            r = Rect.union(r, this.arrowHeadToDraw1.getBoundingBox());
        }
        if (this.arrowHeadToDraw2.size() > 0) {
            r = Rect.union(r, this.arrowHeadToDraw2.getBoundingBox());
        }
        return r;
    }

    public double getScaleArrowHead1() {
        return this.scaleFactorHead1;
    }

    public double getScaleArrowHead2() {
        return this.scaleFactorHead2;
    }

    public MultiShapeObject getHead1() {
        return this.head1;
    }

    public MultiShapeObject getHead2() {
        return this.head2;
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        this.getBody().applyAffineTransform(tr);
        tr.applyTransformsToDrawingProperties(this);
        return (T)this;
    }

    @Override
    public Stylable getMp() {
        return this.mpArray;
    }

    public static enum ArrowType {
        NONE,
        TYPE_1,
        TYPE_2,
        TYPE_3;

    }
}

