/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Axes;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Axes.TickAxes;
import com.jmathanim.mathobjects.Line;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;

public class Axes
extends MathObject {
    public static final double LEGEND_TICKS_GAP = 0.5;
    DecimalFormat format;
    MODrawPropertiesArray mpArray = new MODrawPropertiesArray();
    private final Line xAxis;
    private final ArrayList<TickAxes> xticks;
    private final ArrayList<TickAxes> xticksBase;
    private final Line yAxis;
    private final ArrayList<TickAxes> yticks;
    private final ArrayList<TickAxes> yticksBase;

    public Axes() {
        this.getMp().loadFromStyle("axisdefault");
        this.xticksBase = new ArrayList();
        this.xticks = new ArrayList();
        this.yticksBase = new ArrayList();
        this.yticks = new ArrayList();
        this.xAxis = (Line)Line.make(Point.at(0.0, 0.0), Point.at(1.0, 0.0)).style("axisdefault");
        this.yAxis = (Line)Line.make(Point.at(0.0, 0.0), Point.at(0.0, 1.0)).style("axisdefault");
        this.mpArray.add(this.xAxis, this.yAxis);
        Locale locale = new Locale("en", "UK");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        String pattern = "#.####";
        this.format = new DecimalFormat(pattern, symbols);
    }

    public void addXTicksLegend(double x, TickAxes.TickType tickType, double maxWidthToShow) {
        this.addXTicksLegend("$" + this.format.format(x) + "$", x, tickType, maxWidthToShow);
    }

    public void addXTicksLegend(String latex, double x, TickAxes.TickType tickType, double maxWidthToShow) {
        if (!this.xticksBase.stream().anyMatch(t -> t.location == x)) {
            TickAxes tick = TickAxes.makeXTick(x, latex, tickType, maxWidthToShow);
            this.xticksBase.add(tick);
            this.mpArray.add(tick);
        }
    }

    public void addYTicksLegend(double y, TickAxes.TickType tickType, double maxWidthToShow) {
        this.addYTicksLegend("$" + this.format.format(y) + "$", y, tickType, maxWidthToShow);
    }

    public void addYTicksLegend(String latex, double y, TickAxes.TickType tickType, double maxWidthToShow) {
        if (!this.yticksBase.stream().anyMatch(t -> t.location == y)) {
            TickAxes tick = TickAxes.makeYTick(y, latex, tickType, maxWidthToShow);
            this.yticksBase.add(tick);
            this.mpArray.add(tick);
        }
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        return (T)this;
    }

    @Override
    public <T extends MathObject> T copy() {
        return null;
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible()) {
            this.xAxis.draw(scene, r);
            this.yAxis.draw(scene, r);
            for (TickAxes xtick : this.xticks) {
                xtick.draw(scene, r);
            }
            for (TickAxes ytick : this.yticks) {
                ytick.draw(scene, r);
            }
        }
        scene.markAsAlreadyDrawed(this);
    }

    public Axes generatePrimaryXTicks(double start, double finish, double step) {
        for (double x = start; x <= finish; x += step) {
            if (x == 0.0) continue;
            this.addXTicksLegend(x, TickAxes.TickType.PRIMARY, 0.0);
        }
        return this;
    }

    public Axes generatePrimaryYTicks(double start, double finish, double step) {
        for (double y = start; y <= finish; y += step) {
            if (y == 0.0) continue;
            this.addYTicksLegend(y, TickAxes.TickType.PRIMARY, 0.0);
        }
        return this;
    }

    public Axes generateSecondaryXTicks(double start, double finish, double step, double maxWidthToShow) {
        for (double x = start; x < finish; x += step) {
            if (x == 0.0) continue;
            this.addXTicksLegend(x, TickAxes.TickType.SECONDARY, maxWidthToShow);
        }
        return this;
    }

    public Axes generateSecondaryYTicks(double start, double finish, double step, double maxWidthToShow) {
        for (double y = start; y < finish; y += step) {
            if (y == 0.0) continue;
            this.addYTicksLegend(y, TickAxes.TickType.SECONDARY, maxWidthToShow);
        }
        return this;
    }

    @Override
    public Rect getBoundingBox() {
        return JMathAnimConfig.getConfig().getCamera().getMathView();
    }

    @Override
    public Point getCenter() {
        return Point.at(0.0, 0.0);
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormat(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public Stylable getMp() {
        return this.mpArray;
    }

    public ArrayList<TickAxes> getXticks() {
        return this.xticks;
    }

    public ArrayList<TickAxes> getYticks() {
        return this.yticks;
    }

    public Line getxAxis() {
        return this.xAxis;
    }

    public Line getyAxis() {
        return this.yAxis;
    }

    @Override
    public <T extends MathObject> T thickness(double newThickness) {
        this.xAxis.thickness(newThickness);
        this.yAxis.thickness(newThickness);
        for (TickAxes s : this.xticksBase) {
            s.tick.thickness(newThickness);
        }
        for (TickAxes s : this.yticksBase) {
            s.tick.thickness(newThickness);
        }
        return (T)this;
    }

    @Override
    public void update(JMathAnimScene scene) {
        TickAxes copy;
        int n;
        double xmax = scene.getCamera().getMathView().xmax;
        double xmin = scene.getCamera().getMathView().xmin;
        double scale = (xmax - xmin) / 4.0;
        this.xticks.clear();
        for (n = 0; n < this.xticksBase.size(); ++n) {
            if (!this.xticksBase.get(n).shouldDraw(scene.getCamera())) continue;
            copy = this.xticksBase.get(n).copy();
            copy.tick.scale(scale);
            copy.legend.scale(scale);
            copy.legend.stackTo(copy.tick, Anchor.Type.LOWER, 0.5 * copy.legend.getHeight());
            this.xticks.add(copy);
        }
        this.yticks.clear();
        for (n = 0; n < this.yticksBase.size(); ++n) {
            if (!this.yticksBase.get(n).shouldDraw(scene.getCamera())) continue;
            copy = this.yticksBase.get(n).copy();
            copy.tick.scale(scale);
            copy.legend.scale(scale);
            copy.legend.stackTo(copy.tick, Anchor.Type.RIGHT, 0.5 * copy.legend.getHeight());
            this.yticks.add(copy);
        }
    }

    @Override
    public void copyStateFrom(MathObject obj) {
    }

    public static enum TickScale {
        PRIMARY,
        SECONDARY;

    }
}

