/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Axes;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import com.jmathanim.mathobjects.Text.LaTeXMathObject;

public class TickAxes
extends MathObject {
    private static final double INITIAL_LEGEND_SCALE = 0.3;
    private static final double INITIAL_MARK_SCALE = 0.025;
    LaTeXMathObject legend;
    double location;
    double maximumScaleToShow;
    MODrawPropertiesArray mpArray = new MODrawPropertiesArray();
    TickOrientation orientation;
    Shape tick;
    TickType tickType;

    public static double getMarkScaleFortype(TickType type) {
        switch (type) {
            case PRIMARY: {
                return 1.0;
            }
            case SECONDARY: {
                return 0.75;
            }
        }
        return 1.0;
    }

    public static String getStyleNameFortype(TickType type) {
        switch (type) {
            case PRIMARY: {
                return "axisPrimaryTickDefault";
            }
            case SECONDARY: {
                return "axisSecondaryTickDefault";
            }
        }
        return "axisPrimaryTickDefault";
    }

    public static TickAxes makeXTick(double x, String latex, TickType tt, double maxShowScale) {
        double markScale = TickAxes.getMarkScaleFortype(tt);
        Shape xtick = (Shape)Shape.segment(Point.at(x, -0.025 * markScale), Point.at(x, 0.025 * markScale)).style(TickAxes.getStyleNameFortype(tt));
        LaTeXMathObject xtickLegend = (LaTeXMathObject)LaTeXMathObject.make(latex).style("axislegenddefault");
        xtickLegend.scale(0.3);
        return new TickAxes(x, xtickLegend, xtick, TickOrientation.XAXIS, maxShowScale);
    }

    public static TickAxes makeYTick(double y, String latex, TickType tt, double maxShowScale) {
        double markScale = TickAxes.getMarkScaleFortype(tt);
        Shape ytick = (Shape)Shape.segment(Point.at(-0.025 * markScale, y), Point.at(0.025 * markScale, y)).style(TickAxes.getStyleNameFortype(tt));
        LaTeXMathObject ytickLegend = (LaTeXMathObject)LaTeXMathObject.make(latex).style("axislegenddefault");
        ytickLegend.scale(0.3);
        return new TickAxes(y, ytickLegend, ytick, TickOrientation.YAXIS, maxShowScale);
    }

    public TickAxes(double location, LaTeXMathObject legend, Shape mark, TickOrientation type, double maximumScaleToShow) {
        this.location = location;
        this.legend = legend;
        this.tick = mark;
        this.mpArray.add(legend, this.tick);
        this.maximumScaleToShow = maximumScaleToShow;
        this.orientation = type;
    }

    public TickAxes copy() {
        TickAxes copy = new TickAxes(this.location, this.legend.copy(), this.tick.copy(), this.orientation, this.maximumScaleToShow);
        copy.copyStateFrom(this);
        return copy;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof TickAxes)) {
            return;
        }
        TickAxes t = (TickAxes)obj;
        this.getMp().copyFrom(t.getMp());
        this.getLegend().copyStateFrom(t.getLegend());
        this.getTick().copyStateFrom(t.getTick());
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible() && this.shouldDraw((Camera)r.getCamera())) {
            this.legend.draw(scene, r);
            this.tick.draw(scene, r);
        }
        scene.markAsAlreadyDrawed(this);
    }

    @Override
    public Rect getBoundingBox() {
        return Rect.union(this.tick.getBoundingBox(), this.legend.getBoundingBox());
    }

    public LaTeXMathObject getLegend() {
        return this.legend;
    }

    public double getLocation() {
        return this.location;
    }

    public double getMaximumScaleToShow() {
        return this.maximumScaleToShow;
    }

    @Override
    public Stylable getMp() {
        return this.mpArray;
    }

    public TickOrientation getOrientation() {
        return this.orientation;
    }

    public Shape getTick() {
        return this.tick;
    }

    public TickType getTickType() {
        return this.tickType;
    }

    public boolean shouldDraw(Camera cam) {
        boolean locationCondition;
        boolean scaleCondition = this.maximumScaleToShow == 0.0 | cam.getMathView().getWidth() < this.maximumScaleToShow;
        if (this.orientation == TickOrientation.XAXIS) {
            double xmin = cam.getMathView().xmin;
            double xmax = cam.getMathView().xmax;
            locationCondition = this.location > xmin && this.location < xmax;
        } else {
            double ymin = cam.getMathView().ymin;
            double ymax = cam.getMathView().ymax;
            locationCondition = this.location > ymin && this.location < ymax;
        }
        return scaleCondition && locationCondition;
    }

    public static enum TickType {
        PRIMARY,
        SECONDARY;

    }

    public static enum TickOrientation {
        XAXIS,
        YAXIS;

    }
}

