/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.Collection;

public class CanonicalJMPath {
    public final ArrayList<JMPath> paths;

    public static CanonicalJMPath make(MultiShapeObject msho) {
        CanonicalJMPath resul = new CanonicalJMPath();
        for (Shape sh : msho) {
            CanonicalJMPath aa = sh.getPath().canonicalForm();
            resul.paths.addAll(aa.paths);
        }
        return resul;
    }

    public CanonicalJMPath(ArrayList<JMPath> paths) {
        this.paths = paths;
    }

    public MultiShapeObject createMultiShape(MathObject obj) {
        MODrawProperties mpCopy = null;
        MultiShapeObject msh = new MultiShapeObject();
        if (obj != null) {
            mpCopy = obj.getMp().copy();
            msh.getMp().copyFrom(mpCopy);
        }
        for (JMPath p : this.paths) {
            Shape shape = new Shape(p.referencedCopy());
            if (obj != null) {
                shape.getMp().copyFrom(mpCopy);
            }
            msh.add(shape);
        }
        if (obj != null) {
            msh.layer(obj.getLayer());
        }
        return msh;
    }

    public void clear() {
        this.paths.clear();
    }

    public boolean add(JMPath e) {
        return this.paths.add(e);
    }

    public boolean addAll(Collection<? extends JMPath> c) {
        return this.paths.addAll(c);
    }

    public boolean addAll(CanonicalJMPath c) {
        return this.paths.addAll(c.getPaths());
    }

    public CanonicalJMPath() {
        this(new ArrayList<JMPath>());
    }

    public ArrayList<JMPath> getPaths() {
        return this.paths;
    }

    public int getNumberOfPaths() {
        return this.paths.size();
    }

    public JMPath get(int index) {
        return this.paths.get(index);
    }

    public int getTotalNumberOfPoints() {
        int getTotalNumberOfPoints = 0;
        for (JMPath p : this.paths) {
            getTotalNumberOfPoints += p.size();
        }
        return getTotalNumberOfPoints;
    }

    public int getTotalNumberOfSegments() {
        int getTotalNumberOfSegments = 0;
        for (JMPath p : this.paths) {
            getTotalNumberOfSegments += p.size() - 1;
        }
        return getTotalNumberOfSegments;
    }

    public int[] getSegmentLocation(int k) {
        k %= this.getTotalNumberOfSegments();
        int n = 0;
        while (this.paths.get(n).size() - 1 <= k) {
            k -= this.paths.get(n).size() - 1;
            ++n;
        }
        return new int[]{n, k};
    }

    public JMPath subpath(int pathNumber, double t) {
        JMPath resul = this.paths.get(pathNumber).copy();
        if (t < 1.0) {
            double a = t * (double)(resul.size() - 1);
            int k = (int)Math.floor(a);
            double alpha = a - (double)k;
            ++k;
            if (alpha > 0.0 && alpha < 1.0) {
                JMPathPoint interp = resul.interpolateBetweenTwoPoints(k, alpha);
                interp.isThisSegmentVisible = true;
            }
            ArrayList<JMPathPoint> subList = new ArrayList<JMPathPoint>();
            if (alpha == 0.0) {
                --k;
            }
            for (int n = 0; n < k + 1; ++n) {
                subList.add(resul.jmPathPoints.get(n));
            }
            resul.jmPathPoints.clear();
            resul.jmPathPoints.addAll(subList);
        }
        return resul;
    }

    public JMPath toJMPath() {
        JMPath resul = new JMPath();
        for (JMPath p : this.paths) {
            resul.addJMPointsFrom(p);
        }
        return resul;
    }

    public int size() {
        return this.paths.size();
    }
}

