/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Delimiters;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.EmptyRect;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Delimiters.LengthMeasure;
import com.jmathanim.mathobjects.Delimiters.ShapeDelimiter;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import com.jmathanim.mathobjects.Text.JMNumber;
import com.jmathanim.mathobjects.Text.LaTeXMathObject;
import com.jmathanim.mathobjects.updateableObjects.AnchoredMathObject;

public abstract class Delimiter
extends MathObject {
    protected final Point A;
    protected final Point B;
    protected final Point scaledA;
    protected final Point scaledB;
    protected double amplitudeScale;
    protected MathObject delimiterLabel;
    protected MathObject delimiterLabelToDraw;
    protected MODrawPropertiesArray mpDelimiter;
    public final Point labelMarkPoint;
    protected double labelMarkGap;
    protected Rotation rotateLabel;
    protected MathObjectGroup delimiterToDraw;
    protected double delimiterScale;
    protected double minimumWidthToShrink;
    protected Type type;
    protected double gap;

    public static Delimiter make(Point A, Point B, Type type, double gap) {
        Delimiter resul = null;
        switch (type) {
            case BRACE: 
            case PARENTHESIS: 
            case BRACKET: {
                resul = ShapeDelimiter.make(A, B, type, gap);
                break;
            }
            case LENGTH_ARROW: 
            case LENGTH_BRACKET: {
                resul = LengthMeasure.make(A, B, type, gap);
            }
        }
        resul.amplitudeScale = 1.0;
        resul.delimiterScale = 1.0;
        return resul;
    }

    public static Delimiter stackTo(MathObject obj, Anchor.Type anchorType, Type delimiterType, double gap) {
        Anchor.Type anchorB;
        Anchor.Type anchorA;
        JMathAnimScene sce = JMathAnimConfig.getConfig().getScene();
        switch (anchorType) {
            case UPPER: {
                anchorA = Anchor.Type.UL;
                anchorB = Anchor.Type.UR;
                break;
            }
            case LOWER: {
                anchorA = Anchor.Type.DR;
                anchorB = Anchor.Type.DL;
                break;
            }
            case RIGHT: {
                anchorA = Anchor.Type.UR;
                anchorB = Anchor.Type.DR;
                break;
            }
            case LEFT: {
                anchorA = Anchor.Type.DL;
                anchorB = Anchor.Type.UL;
                break;
            }
            default: {
                JMathAnimScene.logger.error("Invalid anchor for delimiter object " + anchorType.name());
                return null;
            }
        }
        Point A = Anchor.getAnchorPoint(obj, anchorA);
        Point B = Anchor.getAnchorPoint(obj, anchorB);
        sce.registerUpdateable(new AnchoredMathObject(A, Anchor.Type.CENTER, obj, anchorA));
        sce.registerUpdateable(new AnchoredMathObject(B, Anchor.Type.CENTER, obj, anchorB));
        Delimiter resul = Delimiter.make(A, B, delimiterType, gap);
        return resul;
    }

    public Delimiter setLabel(String text, double labelGap) {
        return this.setLabel(LaTeXMathObject.make(text), labelGap);
    }

    public <T extends Delimiter> T setLabel(MathObject label, double labelGap) {
        this.mpDelimiter.add(label);
        this.labelMarkGap = labelGap;
        this.delimiterLabel = label;
        return (T)this;
    }

    public <T extends Delimiter> T removeLabel() {
        this.mpDelimiter.remove(this.delimiterLabel);
        this.delimiterLabel = Shape.polyLine(Point.at(0.0, 0.0)).visible(false);
        return (T)this;
    }

    public Delimiter(Point A, Point B, Type type, double gap) {
        this.A = A;
        this.B = B;
        this.scaledA = A.copy();
        this.scaledB = B.copy();
        this.type = type;
        this.gap = gap;
        this.delimiterLabel = Shape.polyLine(Point.at(0.0, 0.0)).visible(false);
        this.mpDelimiter = new MODrawPropertiesArray();
        this.labelMarkPoint = Point.at(0.0, 0.0);
        this.rotateLabel = Rotation.SMART;
        this.delimiterScale = 1.0;
        this.amplitudeScale = 1.0;
    }

    public void setGap(double gap) {
        this.gap = gap;
    }

    protected abstract MathObjectGroup buildDelimiterShape();

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible()) {
            if (this.delimiterScale == 0.0) {
                return;
            }
            this.scaledA.v.copyFrom(this.A.interpolate((Point)this.B, (double)(0.5 * (1.0 - this.amplitudeScale))).v);
            this.scaledB.v.copyFrom(this.B.interpolate((Point)this.A, (double)(0.5 * (1.0 - this.amplitudeScale))).v);
            this.delimiterLabel.update(scene);
            this.delimiterToDraw = this.buildDelimiterShape();
            this.delimiterToDraw.draw(scene, r);
        }
    }

    @Override
    public Rect getBoundingBox() {
        if (this.A.isEquivalentTo(this.B, 0.0) || this.delimiterScale == 0.0) {
            return new EmptyRect();
        }
        return this.buildDelimiterShape().getBoundingBox();
    }

    public void setAmplitudeScale(double delimiterScale) {
        this.amplitudeScale = delimiterScale;
    }

    public Delimiter copy() {
        Delimiter copy = Delimiter.make(this.A.copy(), this.B.copy(), this.type, this.gap);
        copy.getMp().copyFrom(this.getMp());
        if (this.delimiterLabel != null) {
            copy.setLabel((MathObject)this.getLabel().copy(), this.labelMarkGap);
        }
        copy.amplitudeScale = this.amplitudeScale;
        copy.delimiterScale = this.delimiterScale;
        return copy;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof Delimiter)) {
            return;
        }
        Delimiter del = (Delimiter)obj;
        this.getMp().copyFrom(obj.getMp());
        if (del.delimiterLabel != null) {
            this.setLabel((MathObject)del.getLabel().copy(), del.labelMarkGap);
            this.getLabel().getMp().copyFrom(del.getLabel().getMp());
        }
        this.amplitudeScale = del.amplitudeScale;
        this.delimiterScale = del.delimiterScale;
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(this.A.getUpdateLevel(), this.B.getUpdateLevel()) + 1;
    }

    @Override
    public final Stylable getMp() {
        return this.mpDelimiter;
    }

    public Point getLabelMarkPoint() {
        return this.labelMarkPoint;
    }

    public Rotation getRotationType() {
        return this.rotateLabel;
    }

    public <T extends Delimiter> T setRotationType(Rotation rotateLabel) {
        this.rotateLabel = rotateLabel;
        return (T)this;
    }

    public double getDelimiterScale() {
        return this.delimiterScale;
    }

    public <T extends Delimiter> T setDelimiterScale(double delimiterScale) {
        this.delimiterScale = delimiterScale;
        return (T)this;
    }

    public MathObject getLabel() {
        return this.delimiterLabel;
    }

    public <T extends Delimiter> T addLengthLabel(String format, double gap) {
        JMNumber jm = JMNumber.length(this.scaledA, this.scaledB);
        jm.setFormat(format);
        return this.setLabel(jm, gap);
    }

    public <T extends Delimiter> T addLengthLabel(double gap) {
        return this.addLengthLabel("#.##", gap);
    }

    public static enum Type {
        BRACE,
        PARENTHESIS,
        BRACKET,
        LENGTH_BRACKET,
        LENGTH_ARROW;

    }

    public static enum Rotation {
        FIXED,
        SMART,
        ROTATE;

    }
}

