/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Delimiters;

import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.UsefulLambdas;
import com.jmathanim.mathobjects.Delimiters.Delimiter;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class LengthMeasure
extends Delimiter {
    private final double hgap;

    public static LengthMeasure make(Point A, Point B, Delimiter.Type type, double gap) {
        LengthMeasure resul = new LengthMeasure(A, B, type, gap);
        return resul;
    }

    private LengthMeasure(Point A, Point B, Delimiter.Type type, double gap) {
        super(A, B, type, gap);
        this.gap = gap;
        this.hgap = 0.05;
        this.minimumWidthToShrink = 0.5;
    }

    @Override
    protected MathObjectGroup buildDelimiterShape() {
        this.delimiterLabelToDraw = this.delimiterLabel.copy();
        double width = this.A.to(this.B).norm();
        double angle = this.A.to(this.B).getAngle();
        Point AA = Point.at(0.0, 0.0);
        Point BB = Point.at(width, 0.0);
        double realAmplitudeScale = UsefulLambdas.allocateTo(0.0, this.minimumWidthToShrink).applyAsDouble(width);
        double gapToUse = this.hgap * realAmplitudeScale;
        this.delimiterLabelToDraw.scale(realAmplitudeScale);
        double vCenter = 0.025 * this.delimiterScale;
        MathObjectGroup delShape = MathObjectGroup.make(new MathObject[0]);
        double xOffset = 0.0;
        switch (this.type) {
            case LENGTH_ARROW: {
                xOffset = vCenter;
                break;
            }
            case LENGTH_BRACKET: {
                xOffset = 0.0;
            }
        }
        Shape verticalBar = Shape.polyLine(Point.at(xOffset, -vCenter), Point.at(0.0, 0.0), Point.at(xOffset, vCenter));
        delShape.add((MathObject)verticalBar);
        double segmentLength = 0.5 * (width - this.delimiterLabelToDraw.getWidth()) - gapToUse;
        Shape segment = Shape.segment(Point.at(0.0, 0.0), Point.at(segmentLength, 0.0));
        delShape.add((MathObject)segment);
        switch (this.rotateLabel) {
            case FIXED: {
                this.delimiterLabelToDraw.rotate(-angle);
                break;
            }
            case ROTATE: {
                break;
            }
            case SMART: {
                if (!(angle > 1.5707963267948966) || !(angle < 4.71238898038469)) break;
                this.delimiterLabelToDraw.rotate(Math.PI);
            }
        }
        this.delimiterLabelToDraw.stackTo(segment, Anchor.Type.RIGHT, gapToUse);
        this.labelMarkPoint.copyFrom(this.delimiterLabelToDraw.getCenter());
        delShape.add((MathObject)segment.copy().stackTo(this.delimiterLabelToDraw, Anchor.Type.RIGHT, gapToUse));
        delShape.add((MathObject)((MathObject)verticalBar.copy().scale(Point.at(0.0, 0.0), -1.0, 1.0)).shift(width, 0.0));
        delShape.shift(0.0, vCenter + this.gap * this.amplitudeScale);
        this.delimiterLabelToDraw.shift(0.0, vCenter + this.gap * this.amplitudeScale);
        this.delimiterLabelToDraw.scale(this.amplitudeScale);
        delShape.scale(this.amplitudeScale);
        delShape.getMp().copyFrom(this.mpDelimiter);
        AffineJTransform tr = AffineJTransform.createDirect2DHomothecy(AA, BB, this.A, this.B, 1.0);
        tr.applyTransform(delShape);
        tr.applyTransform(this.delimiterLabelToDraw);
        delShape.add(this.delimiterLabelToDraw);
        return delShape;
    }

    public static enum TYPE {
        ARROW,
        SIMPLE;

    }
}

