/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Delimiters;

import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.ResourceLoader;
import com.jmathanim.Utils.UsefulLambdas;
import com.jmathanim.mathobjects.Delimiters.Delimiter;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.SVGMathObject;
import com.jmathanim.mathobjects.Shape;

public class ShapeDelimiter
extends Delimiter {
    private SVGMathObject body;
    private Shape delimiterShape;

    public static ShapeDelimiter make(Point A, Point B, Delimiter.Type type, double gap) {
        String name;
        ShapeDelimiter resul = new ShapeDelimiter(A, B, type, gap);
        ResourceLoader rl = new ResourceLoader();
        switch (type) {
            case PARENTHESIS: {
                name = "#parenthesis.svg";
                break;
            }
            case BRACKET: {
                name = "#bracket.svg";
                break;
            }
            default: {
                name = "#braces.svg";
            }
        }
        resul.body = new SVGMathObject(rl.getResource(name, "delimiters"));
        resul.mpDelimiter.add(resul.body);
        resul.style("latexdefault");
        return resul;
    }

    private ShapeDelimiter(Point A, Point B, Delimiter.Type type, double gap) {
        super(A, B, type, gap);
        this.minimumWidthToShrink = 0.5;
        this.delimiterShape = new Shape();
        this.mpDelimiter.add(this.delimiterShape);
    }

    @Override
    protected MathObjectGroup buildDelimiterShape() {
        double wSpace;
        double hasToGrow;
        double wr;
        if (this.amplitudeScale == 0.0) {
            return MathObjectGroup.make(new MathObject[0]);
        }
        double width = this.scaledA.to(this.scaledB).norm();
        double angle = this.A.to(this.B).getAngle();
        SVGMathObject bodyCopy = this.body.copy();
        this.delimiterShape.getPath().clear();
        if (this.type == Delimiter.Type.BRACE) {
            this.minimumWidthToShrink = 0.5;
            wr = 0.25 * this.delimiterScale * UsefulLambdas.allocateTo(0.0, this.minimumWidthToShrink).applyAsDouble(width);
            bodyCopy.setWidth(wr);
            hasToGrow = Math.max(0.0, width - wr);
            wSpace = 0.5 * hasToGrow;
            this.delimiterShape.getPath().jmPathPoints.addAll(bodyCopy.get((int)0).getPath().jmPathPoints);
            ((Shape)((Shape)this.delimiterShape.merge((Shape)bodyCopy.get(2).shift(wSpace, 0.0), true, false)).merge((Shape)bodyCopy.get(1).shift(2.0 * wSpace, 0.0), true, false)).merge((Shape)bodyCopy.get(3).shift(wSpace, 0.0), true, true);
        }
        if (this.type == Delimiter.Type.BRACKET) {
            this.minimumWidthToShrink = 0.5;
            wr = 0.8 * this.delimiterScale * UsefulLambdas.allocateTo(0.0, this.minimumWidthToShrink).applyAsDouble(width);
            bodyCopy.setWidth(wr);
            wSpace = hasToGrow = Math.max(0.0, width - wr);
            this.delimiterShape.merge(bodyCopy.get(0), false, false);
            this.delimiterShape.merge((Shape)bodyCopy.get(1).shift(wSpace, 0.0), true, true);
        }
        if (this.type == Delimiter.Type.PARENTHESIS) {
            this.minimumWidthToShrink = 0.5;
            wr = 0.48 * this.delimiterScale * UsefulLambdas.allocateTo(0.0, this.minimumWidthToShrink).applyAsDouble(width);
            bodyCopy.setWidth(wr);
            double wSpace2 = Math.max(0.0, width - wr);
            this.delimiterShape.merge(bodyCopy.get(0), false, false);
            this.delimiterShape.merge((Shape)bodyCopy.get(1).shift(wSpace2, 0.0), true, true);
        }
        MathObjectGroup resul = MathObjectGroup.make(this.delimiterShape);
        Rect bb = this.delimiterShape.getBoundingBox();
        this.delimiterShape.shift(0.0, this.gap * this.amplitudeScale);
        this.labelMarkPoint.stackTo(this.delimiterShape, Anchor.Type.UPPER, this.labelMarkGap * this.amplitudeScale);
        this.delimiterLabelToDraw = this.delimiterLabel.copy();
        resul.add(this.delimiterLabelToDraw);
        this.delimiterLabelToDraw.scale(this.amplitudeScale);
        switch (this.rotateLabel) {
            case FIXED: {
                this.delimiterLabelToDraw.rotate(-angle);
                break;
            }
            case ROTATE: {
                break;
            }
            case SMART: {
                if (!(angle > 1.5707963267948966) || !(angle < 4.71238898038469)) break;
                this.delimiterLabelToDraw.rotate(Math.PI);
            }
        }
        this.delimiterLabelToDraw.stackTo(Anchor.Type.LOWER, this.labelMarkPoint, Anchor.Type.UPPER, 0.0);
        AffineJTransform tr = AffineJTransform.createDirect2DHomothecy(bb.getDL(), bb.getDR(), this.scaledA, this.scaledB, 1.0);
        tr.applyTransform(resul);
        tr.applyTransform(this.labelMarkPoint);
        return resul;
    }
}

