/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.ColorScale;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.AbstractJMImage;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public class DensityPlot
extends AbstractJMImage {
    BiFunction<Double, Double, Double> densityLambdaFunction;
    WritableImage raster;
    double widthView;
    double heightView;
    private int wRaster;
    private int hRaster;
    private ColorScale colorScale;

    public static DensityPlot make(Rect area, BiFunction<Double, Double, Double> densityMap) {
        return new DensityPlot(area, densityMap);
    }

    public DensityPlot(Rect area, BiFunction<Double, Double, Double> densityMap) {
        this.bbox = area.copy();
        this.densityLambdaFunction = densityMap;
        this.widthView = -1.0;
        this.heightView = -1.0;
        this.colorScale = new ColorScale();
        this.scene = JMathAnimConfig.getConfig().getScene();
    }

    @Override
    public <T extends MathObject> T copy() {
        DensityPlot copy = new DensityPlot(this.bbox, this.densityLambdaFunction);
        copy.colorScale.copyFrom(this.colorScale);
        return (T)this;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof DensityPlot)) {
            return;
        }
        DensityPlot dp = (DensityPlot)obj;
        this.bbox.copyFrom(dp.bbox);
        this.densityLambdaFunction = dp.densityLambdaFunction;
        this.widthView = dp.widthView;
        this.heightView = dp.heightView;
        this.colorScale.copyFrom(dp.colorScale);
    }

    @Override
    public int getUpdateLevel() {
        return 0;
    }

    @Override
    public void update(JMathAnimScene scene) {
        super.update(scene);
        this.createRasterImage();
    }

    private void createRasterImage() {
        double w = this.scene.getCamera().getMathView().getWidth();
        double h = this.scene.getCamera().getMathView().getHeight();
        if (w != this.widthView || h != this.heightView) {
            this.widthView = w;
            this.heightView = h;
            double[] xy1 = this.scene.getCamera().mathToScreen(this.bbox.xmin, this.bbox.ymax);
            double[] xy2 = this.scene.getCamera().mathToScreen(this.bbox.xmax, this.bbox.ymin);
            this.wRaster = (int)(xy2[0] - xy1[0]);
            this.hRaster = (int)(xy2[1] - xy1[1]);
            this.raster = new WritableImage(this.wRaster, this.hRaster);
            this.updatePixels();
        }
    }

    private void updatePixels() {
        FutureTask<Integer> task = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                DensityPlot.this.createColorScale();
                PixelWriter pixelWriter = DensityPlot.this.raster.getPixelWriter();
                for (int i = 0; i < DensityPlot.this.wRaster; ++i) {
                    for (int j = 0; j < DensityPlot.this.hRaster; ++j) {
                        Point p = DensityPlot.this.bbox.getRelPoint((double)i * 1.0 / (double)DensityPlot.this.wRaster, 1.0 - (double)j * 1.0 / (double)DensityPlot.this.hRaster);
                        double z = DensityPlot.this.densityLambdaFunction.apply(p.v.x, p.v.y);
                        pixelWriter.setColor(i, j, DensityPlot.this.colorScale.getColorValue(z).getFXColor());
                    }
                }
                return 0;
            }
        });
        Platform.runLater(task);
        try {
            task.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(DensityPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void createColorScale() {
        if (this.colorScale.getMarkers().isEmpty()) {
            double a = Double.MAX_VALUE;
            double b = -1.7976931348623157E308;
            for (int i = 0; i < this.wRaster; ++i) {
                for (int j = 0; j < this.hRaster; ++j) {
                    Point p = this.bbox.getRelPoint((double)i * 1.0 / (double)this.wRaster, 1.0 - (double)j * 1.0 / (double)this.hRaster);
                    double z = this.densityLambdaFunction.apply(p.v.x, p.v.y);
                    if (z < a) {
                        a = z;
                    }
                    if (!(z > b)) continue;
                    b = z;
                }
            }
            this.colorScale = ColorScale.createDefault(-1.0, 1.0);
        }
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public Image getImage() {
        return this.raster;
    }

    public BiFunction<Double, Double, Double> getFunction() {
        return this.densityLambdaFunction;
    }

    public void setFunction(BiFunction<Double, Double, Double> densityMap) {
        this.densityLambdaFunction = densityMap;
        this.updatePixels();
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale colorScale) {
        this.colorScale = colorScale;
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        return (T)this;
    }
}

