/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.DoubleUnaryOperator;

public class FunctionGraph
extends Shape {
    public static final double DELTA_DERIVATIVE = 1.0E-5;
    public static final int DEFAULT_NUMBER_OF_POINTS = 49;
    public static final double CONTINUUM_THRESHOLD = 100.0;
    public static final double ANGLE_THRESHOLD = 0.5235987755982988;
    public DoubleUnaryOperator function;
    public final ArrayList<Double> xPoints;
    public FunctionDefinitionType functionType;
    public DoubleUnaryOperator functionBase;

    public static FunctionGraph make(DoubleUnaryOperator function) {
        Rect r = JMathAnimConfig.getConfig().getCamera().getMathView();
        return new FunctionGraph(function, r.xmin, r.xmax);
    }

    public static FunctionGraph make(DoubleUnaryOperator function, double xmin, double xmax) {
        return new FunctionGraph(function, xmin, xmax);
    }

    public FunctionGraph(DoubleUnaryOperator function, double xmin, double xmax) {
        this(function, xmin, xmax, 49);
    }

    public FunctionGraph(DoubleUnaryOperator function, double xmin, double xmax, int numPoints) {
        this.style("FunctionGraphDefault");
        this.function = function;
        this.functionBase = function;
        this.functionType = FunctionDefinitionType.LAMBDA;
        this.xPoints = new ArrayList();
        for (int n = 0; n < numPoints; ++n) {
            double x = xmin + (xmax - xmin) * (double)n / (double)(numPoints - 1);
            this.xPoints.add(x);
        }
        this.generateFunctionPoints();
    }

    public FunctionGraph(DoubleUnaryOperator function, ArrayList<Double> xPoints) {
        this.function = function;
        this.xPoints = xPoints;
        this.functionBase = function;
        this.functionType = FunctionDefinitionType.LAMBDA;
        this.generateFunctionPoints();
    }

    private void generateFunctionPoints() {
        this.adaptativeAddPoints();
        for (int n = 0; n < this.xPoints.size(); ++n) {
            double x = this.xPoints.get(n);
            double y = this.getFunctionValue(x);
            Point p = Point.at(x, y);
            JMPathPoint jmp = JMPathPoint.curveTo(p);
            this.getPath().addJMPoint(jmp);
            if (n != 0) continue;
            jmp.isThisSegmentVisible = false;
        }
        this.generateControlPoints();
    }

    private void adaptativeAddPoints() {
        ArrayList<Double> newPoints = new ArrayList<Double>();
        boolean goon = true;
        int recursionCounter = 0;
        while (goon) {
            goon = false;
            for (int n = 0; n < this.xPoints.size() - 2; ++n) {
                double x0 = this.xPoints.get(n);
                double x1 = this.xPoints.get(n + 1);
                double x2 = this.xPoints.get(n + 2);
                double y0 = this.getFunctionValue(x0);
                double y1 = this.getFunctionValue(x1);
                double y2 = this.getFunctionValue(x2);
                Vec v1 = Vec.to(x1 - x0, y1 - y0);
                Vec v2 = Vec.to(x2 - x1, y2 - y1);
                double ang = v1.getAngle() - v2.getAngle();
                if (!(Math.abs(ang) > 0.5235987755982988)) continue;
                newPoints.add(0.5 * (x1 + x2));
                newPoints.add(0.5 * (x0 + x1));
                goon = true;
            }
            this.xPoints.addAll(newPoints);
            Collections.sort(this.xPoints);
            newPoints.clear();
            if (++recursionCounter <= 3) continue;
            goon = false;
        }
    }

    protected void generateControlPoints() {
        for (int n = 0; n < this.xPoints.size(); ++n) {
            Vec v;
            double deltaX;
            JMPathPoint jmp = this.get(n);
            double x = jmp.p.v.x;
            if (n < this.xPoints.size() - 1) {
                deltaX = 0.3 * (this.xPoints.get(n + 1) - x);
                v = new Vec(deltaX, this.getSlope(x, 1) * deltaX);
                jmp.cpExit.copyFrom(jmp.p.add(v));
            }
            if (n <= 0) continue;
            deltaX = 0.3 * (this.xPoints.get(n - 1) - x);
            v = new Vec(deltaX, this.getSlope(x, -1) * deltaX);
            jmp.cpEnter.copyFrom(jmp.p.add(v));
            double h = x - this.xPoints.get(n - 1);
            double deriv = (this.getFunctionValue(x) - this.getFunctionValue(this.xPoints.get(n - 1))) / h;
            jmp.isThisSegmentVisible = Math.abs(deriv) < 100.0;
        }
    }

    public void updatePoints() {
        for (JMPathPoint jmp : this.getPath().jmPathPoints) {
            jmp.p.v.y = this.getFunctionValue(jmp.p.v.x);
        }
        this.generateControlPoints();
    }

    public double getFunctionValue(double x) {
        double y = 0.0;
        if (this.functionType == FunctionDefinitionType.LAMBDA) {
            y = this.function.applyAsDouble(x);
        }
        return y;
    }

    public JMPathPoint addX(double x) {
        int n = 0;
        if (this.xPoints.size() > 0) {
            if (this.xPoints.get(this.xPoints.size() - 1) < x) {
                n = this.xPoints.size();
            } else {
                double x0 = this.xPoints.get(0);
                while (x0 < x) {
                    x0 = this.xPoints.get(++n);
                }
                if (x0 == x) {
                    return this.get(n);
                }
            }
        }
        this.xPoints.add(n, x);
        double y = this.getFunctionValue(x);
        Point p = Point.at(x, y);
        JMPathPoint jmp = JMPathPoint.curveTo(p);
        this.getPath().jmPathPoints.add(n, jmp);
        return jmp;
    }

    public double getSlope(double x, int direction) {
        double delta = (double)direction * 1.0E-5;
        double slope = (this.getFunctionValue(x + delta) - this.getFunctionValue(x)) / delta;
        return slope;
    }

    @Override
    public FunctionGraph copy() {
        ArrayList<Double> xPointsCopy = new ArrayList<Double>(this.xPoints);
        FunctionGraph resul = new FunctionGraph(this.function, xPointsCopy);
        resul.getMp().copyFrom(this.getMp());
        return resul;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.functionBase = this.function;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.functionBase = this.function;
    }

    public Shape getAreaShape(double a, double b) {
        double ma = Math.min(a, b);
        double mb = Math.max(a, b);
        FunctionGraph funcAux = FunctionGraph.make(this.function, ma, mb);
        for (double x : this.xPoints) {
            if (!(x >= ma) || !(x <= mb)) continue;
            funcAux.addX(x);
        }
        funcAux.generateControlPoints();
        JMPath areaPath = funcAux.getPath();
        areaPath.addPoint(Point.at(mb, 0.0), Point.at(ma, 0.0));
        areaPath.jmPathPoints.get((int)0).isThisSegmentVisible = true;
        return new Shape(areaPath);
    }

    public static enum FunctionDefinitionType {
        LAMBDA;

    }
}

