/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Renderers.FXRenderer.JavaFXRenderer;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.AbstractJMImage;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import javafx.scene.image.Image;

public class JMImage
extends AbstractJMImage {
    private String filename;
    private final JavaFXRenderer renderer;

    public static JMImage make(String filename) {
        return new JMImage(filename);
    }

    public JMImage(String filename) {
        this.setCached(true);
        this.filename = filename;
        this.renderer = (JavaFXRenderer)JMathAnimConfig.getConfig().getRenderer();
        this.bbox = this.renderer.createImage(filename);
        double sc = (double)this.renderer.getMediaHeight() * 1.0 / 1080.0;
        this.scale(sc);
    }

    public void setImage(String fn) {
        Rect bb = this.renderer.createImage(fn);
        bb.centerAt(this.bbox.getCenter());
        this.filename = fn;
    }

    public JMImage copy() {
        JMImage resul = new JMImage(this.filename);
        resul.bbox.copyFrom(this.bbox);
        resul.getMp().copyFrom(this.getMp());
        resul.preserveRatio = this.preserveRatio;
        resul.rotateAngle = this.rotateAngle;
        resul.rotateAngleBackup = this.rotateAngleBackup;
        return resul;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof JMImage)) {
            return;
        }
        JMImage img = (JMImage)obj;
        this.bbox.copyFrom(img.bbox);
        this.getMp().copyFrom(img.getMp());
        this.preserveRatio = img.preserveRatio;
        this.rotateAngle = img.rotateAngle;
        this.rotateAngleBackup = img.rotateAngleBackup;
    }

    @Override
    public void update(JMathAnimScene scene) {
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.bbox.restoreState();
        this.rotateAngle = this.rotateAngleBackup;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.bbox.saveState();
        this.rotateAngleBackup = this.rotateAngle;
    }

    @Override
    public <T extends MathObject> T scale(Point scaleCenter, double sx, double sy, double sz) {
        this.bbox.copyFrom(Rect.make((Point)this.bbox.getUL().scale(scaleCenter, sx, sy, sz), (Point)this.bbox.getDR().scale(scaleCenter, sx, sy, sz)));
        return (T)this;
    }

    @Override
    public <T extends MathObject> T rotate(Point center, double angle) {
        Point centerBbox = this.bbox.getCenter();
        centerBbox.rotate(center, angle);
        this.bbox.copyFrom(this.bbox.shifted(this.bbox.getCenter().to(centerBbox)));
        this.rotateAngle += angle;
        return (T)this;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getId() {
        return this.getFilename();
    }

    @Override
    public Image getImage() {
        return this.renderer.getImageFromCatalog(this);
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        return (T)this;
    }
}

